ORCA/M Asm65816 2.1.0

0001 9E1E              *********************************************************************************
0002 9E1E              *
0003 9E1E              * FONT MANAGER
0004 9E1E              * Version 3.2
0005 9E1E              *
0006 9E1E              * Copyright Apple Computer, Inc. 1986-1991
0007 9E1E              * All Rights Reserved
0008 9E1E              *
0009 9E1E              * V1.0              11/19/86            Cheryl Ewy
0010 9E1E              * V1.1              04/09/87            Bennet Marks, Cheryl Ewy
0011 9E1E              * V2.0              05/14/87            Bennet Marks, Cheryl Ewy
0012 9E1E              *
0013 9E1E              *
0014 9E1E              * Version 2.3
0015 9E1E              *
0016 9E1E              * 28 Apr 88         Harry Yee
0017 9E1E              *
0018 9E1E              * Fixed problem w/FixFontMenu where the handle to the FMParam block was not
0019 9E1E              * being locked and deref. at the correct place.
0020 9E1E              *
0021 9E1E              * 15 Jun 88         Harry Yee
0022 9E1E              *
0023 9E1E              * Prototype bit taken out of version #
0024 9E1E              *
0025 9E1E              *
0026 9E1E              *
0027 9E1E              * Version 2.4
0028 9E1E              *
0029 9E1E              * 29 Jun 88         Steven Glass
0030 9E1E              *
0031 9E1E              * Changed version number to 8204 for changes to scaling that make it run
0032 9E1E              * in ROM.
0033 9E1E              *
0034 9E1E              *
0035 9E1E              * 14 Jul 88         Steven Glass
0036 9E1E              *
0037 9E1E              * Two calls to GetWAP did not set the system/User flag correctly.  Instead they
0038 9E1E              * were pushing the program ID.  This caused the ToolLocator to return random values
0039 9E1E              * from the UserWAP Table.  This let the font manager use strange direct page
0040 9E1E              * locations.  Its a wonder it ever worked.
0041 9E1E              *
0042 9E1E              * The two routines that were affected are: DrawGuts and DrawSize.
0043 9E1E              *
0044 9E1E              * 15 Jul 88         Steven Glass
0045 9E1E              *
0046 9E1E              * LoadFont did not return valid fontstats if the font was not already in 
0047 9E1E              * memory.  This was because the LoadTheFont routine trashed the d-page location
0048 9E1E              * TempPtr during the load.
0049 9E1E              *
0050 9E1E              * 5 Dec 88          Sue Dumont
0051 9E1E              *
0052 9E1E              * InstallFont would not recreate a font that had been purged out of memory.  This was
0053 9E1E              * due to the fact that FindBestFit thought that the font was still hanging around.  Now,
0054 9E1E              * the font handle is checked to verify that it is valid before making that assumption.
0055 9E1E              *
0056 9E1E              * 10 Jan 89         Mensch
0057 9E1E              * 
0058 9E1E              * Choose font had a bug that hung the system if certain windows had pending update
0059 9E1E              * events. This was fixed by removing the use of taskmaster to perform auto updating
0060 9E1E              * and replacing it with a check of the updatergn of the window itself and calling 
0061 9E1E              * the update routine.
0062 9E1E              *
0063 9E1E              * 16 Jan 89         Mensch
0064 9E1E              *
0065 9E1E              * ChooseFont modified to use newwindow2 call and new control types. This reduces
0066 9E1E              * the size of the parameters handle allocated in RAM when the font manager starts
0067 9E1E              * and allows for internationalization in the future.
0068 9E1E              * ALSO fixed bug in install font, it did not always install the proper font.
0069 9E1E              *
0070 9E1E              * 20 Jan 89         Mensch
0071 9E1E              *
0072 9E1E              * Use new ROMResource stuff in misc tools for use with the choosefont call
0073 9E1E              *
0074 9E1E              * 14 Feb 89         Yee
0075 9E1E              *
0076 9E1E              * TaskMask for ChooseFont dialog not correct. Bit 15 was clear which caused the choose
0077 9E1E              * font window to deactivate when the mouse was clicked in a window that had an info bar.
0078 9E1E              * This bottom window was then activated. Bit 15 is now set. BRC #41429.
0079 9E1E              *
0080 9E1E              * 3/24/89           Mensch (Guest apperance by Dave Lyons)
0081 9E1E              * 
0082 9E1E              * Fixed a bug in ReadFontLists that would cause the system to crash every now and then!
0083 9E1E              *
0084 9E1E              * 19 Apr 89         Yee
0085 9E1E              *
0086 9E1E              * Changed version number from 2.4 to 3.0
0087 9E1E              *
0088 9E1E              *********************************************************************************
0089 9E1E
0090 9E1E                       include 'all.macros' 
0091 9E1E
0092 9E1E                       include 'Special.macros' 
0093 9E1E
0094 9E1E                       string asis 
0095 9E1E
0096 9E1E
0097 9E1E              ;------------------------------------------
0098 9E1E              ;
0099 9E1E              ; Gequ from procedure FMData
0100 9E1E              ;
0101 9E1E              ;------------------------------------------
0102 9E1E              MaxSListCount equ   12                  ;max # of members in Size list
0103 9E1E
0104 9E1E              ;-----------------------------------------------
0105 9E1E              ;
0106 9E1E              ;   Imported address
0107 9E1E              ;
0108 9E1E              ;-----------------------------------------------
0109 9E1E
0110 9E1E
0111 9E1E                       import strip 
0112 9E1E                       import oerrout 
0113 9E1E                       import endcall 
0114 9E1E                       import errout 
0115 9E1E                       import oendcall 
0116 9E1E                       import scalefont 
0117 9E1E
0118 9E1E
0119 9E1E
0120 9E1E              ;-----------------------------------------------
0121 9E1E              ;
0122 9E1E              ;   Forward address and entries
0123 9E1E              ;
0124 9E1E              ;-----------------------------------------------
0125 9E1E                       ENTRY UnlockFMParams
0126 9E1E                       entry sortsizes 
0127 9E1E
0128 9E1E                       ENTRY UnLock
0129 9E1E                       ENTRY Lock
0130 9E1E                       ENTRY MakeString
0131 9E1E                       ENTRY UnLockItemList
0132 9E1E                       ENTRY UnLockMDList
0133 9E1E                       ENTRY IncItemPtr
0134 9E1E                       ENTRY LockItemList
0135 9E1E                       ENTRY IncMDPtr
0136 9E1E                       ENTRY LockMDList
0137 9E1E                       ENTRY BuildMDList
0138 9E1E                       ENTRY GetEOF
0139 9E1E                       ENTRY MakeCurrent
0140 9E1E                       ENTRY UnLockFont
0141 9E1E                       ENTRY LockFont
0142 9E1E                       ENTRY CheckSysFont
0143 9E1E                       ENTRY CheckNil
0144 9E1E                       ENTRY AddScaledFont
0145 9E1E                       ENTRY LoadTheFont
0146 9E1E                       ENTRY StdEnd6
0147 9E1E                       ENTRY StdErr6
0148 9E1E                       ENTRY CheckFontID
0149 9E1E                       ENTRY CheckHandle
0150 9E1E                       ENTRY WriteFile
0151 9E1E                       ENTRY CreateFile
0152 9E1E                       ENTRY LockFMParams
0153 9E1E                       ENTRY SetEOF
0154 9E1E                       ENTRY SetMark
0155 9E1E                       ENTRY GetDirEntry
0156 9E1E                       ENTRY UnLockFileList
0157 9E1E                       ENTRY UnLockNameList
0158 9E1E                       ENTRY UnLockFamList
0159 9E1E                       ENTRY UnLockIDList
0160 9E1E                       ENTRY CloseFile
0161 9E1E                       ENTRY ReadFile
0162 9E1E                       ENTRY OpenFile
0163 9E1E                       ENTRY CopyFileName
0164 9E1E                       ENTRY IncFilePtr
0165 9E1E                       ENTRY IncNamePtr
0166 9E1E                       ENTRY IncFamPtr
0167 9E1E                       ENTRY IncIDPtr
0168 9E1E                       ENTRY CopyFamName
0169 9E1E                       ENTRY LockFileList
0170 9E1E                       ENTRY LockNameList
0171 9E1E                       ENTRY LockFamList
0172 9E1E                       ENTRY LockIDList
0173 9E1E                       ENTRY StdEnd4
0174 9E1E                       ENTRY LockBlock
0175 9E1E                       ENTRY GetHandle
0176 9E1E                       ENTRY StdErr4
0177 9E1E                       ENTRY DrawGuts
0178 9E1E                       ENTRY SizeHit
0179 9E1E                       ENTRY SizeList
0180 9E1E                       ENTRY DrawSize
0181 9E1E                       ENTRY FontHit
0182 9E1E                       ENTRY GDENameBuf
0183 9E1E                       ENTRY InstallWithStats
0184 9E1E                       ENTRY FamNum2ItemID
0185 9E1E                       ENTRY FMGetCurFID
0186 9E1E                       ENTRY FMGetSysFID
0187 9E1E                       ENTRY FMSetSysFont
0188 9E1E                       ENTRY ItemID2FamNum
0189 9E1E                       ENTRY ChooseFont
0190 9E1E                       ENTRY FixFontMenu
0191 9E1E                       ENTRY AddFontVar
0192 9E1E                       ENTRY LoadSysFont
0193 9E1E                       ENTRY LoadFont
0194 9E1E                       ENTRY FindFontStats
0195 9E1E                       ENTRY CountFonts
0196 9E1E                       ENTRY SetPurgeStat
0197 9E1E                       ENTRY InstallFont
0198 9E1E                       ENTRY AddFamily
0199 9E1E                       ENTRY GetFamNum
0200 9E1E                       ENTRY GetFamInfo
0201 9E1E                       ENTRY FindFamily
0202 9E1E                       ENTRY CountFamilies
0203 9E1E                       ENTRY oStdEnd0
0204 9E1E                       ENTRY FMStatus
0205 9E1E                       ENTRY FMReset
0206 9E1E                       ENTRY FMVersion
0207 9E1E                       ENTRY FMShutDown
0208 9E1E                       ENTRY FMStartUp
0209 9E1E                       ENTRY FMBootInit
0210 9E1E
0211 9E1E
0212 9E1E
0213 9E1E              ****************************************************************
0214 9E1E              *
0215 9E1E              * FONT MANAGER DATA STRUCTURES
0216 9E1E              *
0217 9E1E              ****************************************************************
0218 9E1E
0219 9E1E              *---------------------------------------------------------------
0220 9E1E              *  The Font Manager keeps information about all of the available
0221 9E1E              *  fonts in 4 different lists.  The ID List contains entries
0222 9E1E              *  describing every available font.  The Family List contains
0223 9E1E              *  entries describing every distinct font family.  The Name List
0224 9E1E              *  contains entries for each distinct font family name.  The
0225 9E1E              *  File List contains entries for each font file on the system
0226 9E1E              *  disk.  The structure of each of the 4 list entries is shown
0227 9E1E              *  below. These structures are used throughout the Font Manager.
0228 9E1E              *---------------------------------------------------------------
0229 9E1E              *        ID List Entry                  14 bytes
0230 9E1E              *
0231 9E1E              *          Family #                     2 bytes        0 (offset)
0232 9E1E              *          Style                        1 byte         2
0233 9E1E              *          Size                         1 byte         3
0234 9E1E              *          Offset to Name List Entry    2 bytes        4
0235 9E1E              *          Offset to File List Entry    2 bytes        6
0236 9E1E              *          FontSpecBits                 2 bytes        8
0237 9E1E              *          Font Handle                  4 bytes        10
0238 9E1E              *---------------------------------------------------------------
0239 9E1E              *        Fam List Entry                 6 bytes
0240 9E1E              *
0241 9E1E              *          Family #                     2 bytes        0 (offset)
0242 9E1E              *          Offset to Name List Entry    2 bytes        2
0243 9E1E              *          FamSpecBits                  2 bytes        4
0244 9E1E              *---------------------------------------------------------------
0245 9E1E              *        Name List Entry                2-26 bytes
0246 9E1E              *
0247 9E1E              *          Family Name Length           1 byte
0248 9E1E              *          Family Name                  1-25 bytes
0249 9E1E              *---------------------------------------------------------------
0250 9E1E              *        File List Entry                2-16 bytes
0251 9E1E              *
0252 9E1E              *          File Name Length             1 byte
0253 9E1E              *          File Name                    1-15 bytes
0254 9E1E              *---------------------------------------------------------------
0255 9E1E              *  The following data structure is used only by
0256 9E1E              *  the FixFontMenu and ChooseFont routines.
0257 9E1E              *---------------------------------------------------------------
0258 9E1E              *        MD List Entry                  8 bytes
0259 9E1E              *
0260 9E1E              *          Pointer to Name List Entry   4 bytes        0 (offset)
0261 9E1E              *          List Manager Flags           1 byte         4
0262 9E1E              *          Padding                      1 byte         5
0263 9E1E              *          Family #                     2 bytes        6
0264 9E1E              *---------------------------------------------------------------
0265 9E1E              *  The following data structure is used only by
0266 9E1E              *  the ChooseFont routine.
0267 9E1E              *---------------------------------------------------------------
0268 9E1E              *        Size List Entry                5 bytes
0269 9E1E              *
0270 9E1E              *          Size                         2 bytes        0 (offset)
0271 9E1E              *          Unused                       2 bytes        2
0272 9E1E              *          List Manager Flags           1 byte         4
0273 9E1E              *---------------------------------------------------------------
0274 9E1E              *  The following data structure is used only by
0275 9E1E              *  the FixFontMenu and ItemID2FamNum routines.
0276 9E1E              *---------------------------------------------------------------
0277 9E1E              *        Item List Entry                2 bytes
0278 9E1E              *
0279 9E1E              *          Family #                     2 bytes
0280 9E1E              *---------------------------------------------------------------
0281 9E1E
0282 9E1E
0283 9E1E
0284 9E1E
0285 9E1E
0286 9E1E
0287 9E1E              ****************************************************************
0288 9E1E              *
0289 9E1E              * FONT MANAGER DATA DECLARATIONS
0290 9E1E              *
0291 9E1E              ****************************************************************
0292 9E1E
0293 9E1E              *---------------------------------------------------------------
0294 9E1E              * Constants
0295 9E1E              *---------------------------------------------------------------
0296 9E1E              ;
0297 9E1E              ;
0298 9E1E
0299 9E1E              FMVerNum equ   $0300
0300 9E1E
0301 9E1E              FMTSNum  equ   $1B                      ;tool set num for Font Manager
0302 9E1E
0303 9E1E              InitErr  equ   $1B01                    ;duplicate init call
0304 9E1E              ResetErr equ   $1B02                    ;can't reset Font Manager
0305 9E1E              ActiveErr equ   $1B03                   ;Font Manager not active
0306 9E1E              NoFamErr equ   $1B04                    ;family not found
0307 9E1E              NoFontErr equ   $1B05                   ;font not found
0308 9E1E              MemErr   equ   $1B06                    ;font not in memory
0309 9E1E              PurgeErr equ   $1B07                    ;system font cannot be purgeable
0310 9E1E              FamNumErr equ   $1B08                   ;illegal family number
0311 9E1E              SizeErr  equ   $1B09                    ;illegal size
0312 9E1E              NameErr  equ   $1B0A                    ;illegal name length
0313 9E1E              MenuErr  equ   $1B0B                    ;FixFontMenu never called
0314 9E1E              ;added 2/10/87 - BHM:
0315 9E1E              scaleSizeErr equ   $1B0C                ;font can't be scaled that large
0316 9E1E              ;(must match ScaleFont definition)
0317 9E1E              fmBadParmErr equ   $1b0d                ;the user id or dp address was stupid (added 25-Nov-90 DAL)
0318 9E1E              ;
0319 9E1E              ProDOS   equ   $E100A8                  ;ProDOS/16 entry vector
0320 9E1E              StackProDOS equ   $E100B0               ;ProDOS/16 stack-based entry vector
0321 9E1E              OpenCall equ   $10                      ;ProDOS/16 call number
0322 9E1E              ReadCall equ   $12                      ;           "
0323 9E1E              CloseCall equ   $14                     ;           "
0324 9E1E              SetMarkCall equ   $16                   ;           "
0325 9E1E              GetEOFCall equ   $19                    ;           "
0326 9E1E              CreateCall equ   $01                    ;           "
0327 9E1E              WriteCall equ   $13                     ;           "
0328 9E1E              SetEOFCall equ   $18                    ;           "
0329 9E1E              GDECall  equ   $1C                      ;           "
0330 9E1E              DestroyCall equ   $02
0331 9E1E
0332 9E1E              ButtonItem equ   10                     ;item type for dialog manager
0333 9E1E              StatTextItem equ   15+$8000             ;           "
0334 9E1E
0335 9E1E              KeyDownEvt equ   3                      ;event code
0336 9E1E              autoKeyEvt equ   5                      ;event code (DAL)
0337 9E1E              ListPartCode equ   $88                  ;part code for list
0338 9E1E
0339 9E1E              Message  equ   2                        ;offset into TaskRec
0340 9E1E              Where    equ   10                       ;         "
0341 9E1E              Modifiers equ   14                      ;         "
0342 9E1E              TaskMask equ   20                       ;         "
0343 9E1E
0344 9E1E              DirNameLen equ   14                     ;length of '*:System:Fonts'
0345 9E1E              MaxNameLen equ   25                     ;max length of font's family name
0346 9E1E              BlockSize equ   512
0347 9E1E              Illegal  equ   $FFFF                    ;illegal family number
0348 9E1E              FontType equ   $C8                      ;filetype for font files
0349 9E1E
0350 9E1E              MemOnlyBit equ   $0001                  ;FontSpecBits
0351 9E1E              RealOnlyBit equ   $0002
0352 9E1E              AnyFamBit equ   $0004
0353 9E1E              AnyStyleBit equ   $0008
0354 9E1E              AnySizeBit equ   $0010
0355 9E1E
0356 9E1E              MemBit   equ   $0001                    ;FontStatBits
0357 9E1E              UnrealBit equ   $0002
0358 9E1E              ApFamBit equ   $0004
0359 9E1E              ApVarBit equ   $0008
0360 9E1E              PurgeBit equ   $0010
0361 9E1E              NotDiskBit equ   $0020
0362 9E1E              NotFoundBit equ   $8000
0363 9E1E
0364 9E1E              BaseOnlyBit equ   $0020                 ;FamSpecBits
0365 9E1E
0366 9E1E              ;ApFamBit      equ $0004	;FamStatBits
0367 9E1E              NotBaseBit equ   $0020
0368 9E1E              ;NotFoundBit   equ $8000
0369 9E1E
0370 9E1E              NotMemBit equ   $FFFE                   ;all bits set except MemBit
0371 9E1E              UnPurgeable equ   $FFEF                 ;all bits set except PurgeBit
0372 9E1E              ;
0373 9E1E              ;added 2/10/87 - BHM:
0374 9E1E              dontScaleBit equ   $0001                ;(see scaleWord input in InstallFont)
0375 9E1E              currFlag equ   $0001                    ;make font current (see LoadTheFont)
0376 9E1E              notCurrFlag equ   $FFFE
0377 9E1E              newMemFlag equ   $0002                  ;(see LoadTheFont)
0378 9E1E              oldMemFlag equ   $0004                  ;(see LoadTheFont)
0379 9E1E              ;
0380 9E1E              ;                COPY new.cons
0381 9E1E              ;
0382 9E1E              ****************************************************************************
0383 9E1E              *                                                                          *
0384 9E1E              *  file NEW.CONS                                                           *
0385 9E1E              *                                                                          *
0386 9E1E              *    started 8/31/87                                                       *
0387 9E1E              *    Bennet Marks  x6245                                                   *
0388 9E1E              *                                                                          *
0389 9E1E              *  This file contains some new constants needed by the FMStartUp speed-up  *
0390 9E1E              *  experiment.  Also included are offsets used to make ProDOS stack-based  *
0391 9E1E              *  calls.                                                                  *
0392 9E1E              *                                                                          *
0393 9E1E              ****************************************************************************
0394 9E1E              ;
0395 9E1E              ***************************************
0396 9E1E              *                                     *
0397 9E1E              *  11/10/87  1:20 pm                  *
0398 9E1E              *  BHM  x6245                         *
0399 9E1E              *                                     *
0400 9E1E              ***************************************
0401 9E1E              ;
0402 9E1E              ;FONT.LISTS format version number:
0403 9E1E              ;
0404 9E1E              FLVerHi  equ   $0000
0405 9E1E              FLVerLo  equ   $0001
0406 9E1E              ;
0407 9E1E              ;offsets to data in the FONT.LISTS file:
0408 9E1E              ;
0409 9E1E              oRomFamNum equ   4
0410 9E1E              oRomStyle equ   oRomFamNum+2
0411 9E1E              oRomSize equ   oRomStyle+2
0412 9E1E              oIDCount equ   oRomSize+2
0413 9E1E              oFamCount equ   oIDCount+2
0414 9E1E              oIDListSize equ   oFamCount+2
0415 9E1E              oFamListSize equ   oIDListSize+2
0416 9E1E              oNameListSize equ   oFamListSize+2
0417 9E1E              oFileListSize equ   oNameListSize+2
0418 9E1E              oTimeListSize equ   oFileListSize+2
0419 9E1E              ;
0420 9E1E              FLFileHeadLen equ   oTimeListSize+2
0421 9E1E              ;
0422 9E1E              ;and some other constants:
0423 9E1E              ;
0424 9E1E              GDENameBufSize equ   20                 ;for the name buffer
0425 9E1E              FileNotFound equ   $46
0426 9E1E              EndOfDir equ   $61
0427 9E1E              BinFile  equ   $06
0428 9E1E              ;
0429 9E1E              ;
0430 9E1E              *---------------------------------------------------------------
0431 9E1E              * Font Manager Zero Page
0432 9E1E              *---------------------------------------------------------------
0433 9E1E
0434 9E1E              FMZBase  equ   0
0435 9E1E
0436 9E1E              TempHandle equ   FMZBase                ;the following handles must be in
0437 9E1E              FileHandle equ   TempHandle+4           ;this order
0438 9E1E              IDHandle equ   FileHandle+4
0439 9E1E              FamHandle equ   IDHandle+4
0440 9E1E              NameHandle equ   FamHandle+4
0441 9E1E              FontHandle equ   NameHandle+4
0442 9E1E              BlockHandle equ   FontHandle+4
0443 9E1E              MDHandle equ   BlockHandle+4
0444 9E1E              ItemHandle equ   MDHandle+4
0445 9E1E              FMParamHandle equ   ItemHandle+4        ;added 11/10/87 - BHM x6245
0446 9E1E
0447 9E1E              TempPtr  equ   FMParamHandle+4          ;the following pointers must be in
0448 9E1E              FilePtr  equ   TempPtr+4                ;this order
0449 9E1E              IDPtr    equ   FilePtr+4
0450 9E1E              FamPtr   equ   IDPtr+4
0451 9E1E              NamePtr  equ   FamPtr+4
0452 9E1E              FontPtr  equ   NamePtr+4
0453 9E1E              BlockPtr equ   FontPtr+4
0454 9E1E              MDPtr    equ   BlockPtr+4
0455 9E1E              ItemPtr  equ   MDPtr+4
0456 9E1E              FMParamPtr equ   ItemPtr+4              ;added 11/10/87 - BHM x6245
0457 9E1E
0458 9E1E              SavedFilePtr equ   FMParamPtr+4         ;the following pointers must be in
0459 9E1E              SavedIDPtr equ   SavedFilePtr+4         ;this order
0460 9E1E              SavedFamPtr equ   SavedIDPtr+4
0461 9E1E              SavedNamePtr equ   SavedFamPtr+4
0462 9E1E
0463 9E1E              IDListSize equ   SavedNamePtr+4
0464 9E1E              FamListSize equ   IDListSize+2
0465 9E1E              NameListSize equ   FamListSize+2
0466 9E1E              ItemListSize equ   NameListSize+2       ;** added 2-25-87 CAE **
0467 9E1E
0468 9E1E              IDCount  equ   ItemListSize+2
0469 9E1E              FamCount equ   IDCount+2
0470 9E1E              ;
0471 9E1E              ****  CHANGED 11/4/87:
0472 9E1E              ;all the Font Manager's ProDOS calls (except GetDirEntry) now share a common
0473 9E1E              ;block of 0-page for their parameter blocks.  Note that the reference numbers
0474 9E1E              ;(OpenRef, ReadRef, etc.) are actually the same 0-page location.  In partic-
0475 9E1E              ;ular, after an OpenFile call is done, the new ref number is in the right
0476 9E1E              ;position for a subsequent ReadFile call. - BHM  x6245  11/4/87
0477 9E1E              ;
0478 9E1E              ProDOSParams equ   FamCount+2
0479 9E1E              ;
0480 9E1E              ;Open call:
0481 9E1E              OpenRef  equ   ProDOSParams             ;reference number
0482 9E1E              OpenPtr  equ   OpenRef+2                ;ptr to pathname
0483 9E1E              OpenBuf  equ   OpenPtr+4                ;unused by Font Manager
0484 9E1E
0485 9E1E              ;Read call:
0486 9E1E              ReadRef  equ   ProDOSParams             ;reference number
0487 9E1E              ReadPtr  equ   ReadRef+2                ;ptr to data buffer
0488 9E1E              ReadSize equ   ReadPtr+4                ;number of bytes to read
0489 9E1E              ReadActual equ   ReadSize+4             ;number of bytes actually read
0490 9E1E
0491 9E1E              ;Close call (whew!):
0492 9E1E              CloseRef equ   ProDOSParams             ;reference number
0493 9E1E
0494 9E1E              ;GetEOF and SetEOF calls:
0495 9E1E              EOFRef   equ   ProDOSParams             ;reference number
0496 9E1E              EOFSize  equ   EOFRef+2                 ;EOF (new or returned result)
0497 9E1E
0498 9E1E              ;GetMark and SetMark calls:
0499 9E1E              MarkRef  equ   ProDOSParams             ;refernce number
0500 9E1E              MarkLoc  equ   MarkRef+2                ;mark (new or returned result)
0501 9E1E
0502 9E1E              ;Write call:
0503 9E1E              WriteRef equ   ProDOSParams
0504 9E1E              WriteBuf equ   WriteRef+2
0505 9E1E              WriteReq equ   WriteBuf+4
0506 9E1E              WriteTrans equ   WriteReq+4
0507 9E1E
0508 9E1E              ;Create call:
0509 9E1E              CRNamePtr equ   ProDOSParams
0510 9E1E              CRAccess equ   CRNamePtr+4
0511 9E1E              CRFileType equ   CRAccess+2
0512 9E1E              CRAuxType equ   CRFileType+2
0513 9E1E              CRStore  equ   CRAuxType+4
0514 9E1E              CRDate   equ   CRStore+2
0515 9E1E              CRTime   equ   CRDate+2
0516 9E1E
0517 9E1E              ;Destroy call:
0518 9E1E              KillNamePtr equ   ProDOSParams
0519 9E1E
0520 9E1E              ;
0521 9E1E              ****  end of changes to ProDOS parameter blocks - BHM  x6245  11/4/87
0522 9E1E              ;
0523 9E1E              ;note that the parameter blocks above all use less than 20 bytes
0524 9E1E              ;
0525 9E1E              MenuMade equ   ProDOSParams+20          ;so this is safe
0526 9E1E              StartingID equ   MenuMade+2
0527 9E1E              ProgID   equ   StartingID+2
0528 9E1E              SysFontID equ   ProgID+2
0529 9E1E              RomFbrExtent equ   SysFontID+4
0530 9E1E              OldStats equ   RomFBRExtent+2           ;added 12/16/87 - BHM  x6245
0531 9E1E              ;(for use by InstallWithStats)
0532 9E1E              ;added 1/11/88 - BHM  x6245
0533 9E1E              temp1Ptr equ   OldStats+2
0534 9E1E              temp2Ptr equ   temp1Ptr+4
0535 9E1E              ;the following locations are used to hold information that, in the RAM
0536 9E1E              ;of this tool, were kept in the data segment.  Some also subsume 0-page
0537 9E1E              ;locations that used to be private to ChooseFont - BHM  x6245  1/25/88
0538 9E1E              ScreenMode equ   temp2Ptr+4
0539 9E1E              WindPtr  equ   ScreenMode+2
0540 9E1E              LineHndl equ   WindPtr+4
0541 9E1E
0542 9E1E              Temp     equ   LineHndl+4
0543 9E1E
0544 9E1E              ;
0545 9E1E              ; Equates for ChooseFont item ID's
0546 9E1E              MDListID equ   1
0547 9E1E              SizeListID equ   2
0548 9E1E              SizeEditID equ   3
0549 9E1E              OKID     equ   4
0550 9E1E              CancelID equ   5
0551 9E1E              ; these next style ID's must be in order...
0552 9E1E              PlainSID equ   6
0553 9E1E              BoldSID  equ   7
0554 9E1E              ItalicSID equ   8
0555 9E1E              UnderSID equ   9
0556 9E1E              OutlineSID equ   10
0557 9E1E              ShadowSID equ   11
0558 9E1E              LastSID  equ   12
0559 9E1E              ;
0560 9E1E              stat1ID  equ   12
0561 9E1E              stat2ID  equ   13
0562 9E1E              stat3ID  equ   14
0563 9E1E              ;
0564 9E1E              ; RefCon Equates for ChooseFont controls
0565 9E1E              useNILHit equ   0
0566 9E1E              useFontHit equ   1
0567 9E1E              useSizeHit equ   2
0568 9E1E              useOtherHit equ   3
0569 9E1E              useOKHit equ   4
0570 9E1E              useCancelHit equ   5
0571 9E1E              usePlainHit equ   6
0572 9E1E              useStyleHit equ   7
0573 9E1E
0574 9E1E
0575 9E1E              ****************************************************************
0576 9E1E              *
0577 9E1E              * FONT MANAGER CALL TABLE
0578 9E1E              *
0579 9E1E              ****************************************************************
0580 9E1E
0581 9E1E                       EXPORT FMCallTable 
0582 9E1E              FMCallTable PROC 
0583 9E1E
0584 9E1E              TheStart  
0585 9E1E 1D 00 00 00           DC L:(TheEnd-TheStart)/4       ;num calls + 1
0586 9E22 90 A0 FC 00           DC L:FMBootInit-1
0587 9E26 93 A0 FC 00           DC L:FMStartUp-1
0588 9E2A 23 AA FC 00           DC L:FMShutDown-1
0589 9E2E E1 AA FC 00           DC L:FMVersion-1
0590 9E32 E9 AA FC 00           DC L:FMReset-1
0591 9E36 FB AA FC 00           DC L:FMStatus-1
0592 9E3A 81 C1 FC 00           DC L:oStdEnd0-1
0593 9E3E 81 C1 FC 00           DC L:oStdEnd0-1
0594 9E42 00 AB FC 00           DC L:CountFamilies-1
0595 9E46 37 AB FC 00           DC L:FindFamily-1
0596 9E4A C7 AB FC 00           DC L:GetFamInfo-1
0597 9E4E 37 AC FC 00           DC L:GetFamNum-1
0598 9E52 A5 AC FC 00           DC L:AddFamily-1
0599 9E56 6E AD FC 00           DC L:InstallFont-1
0600 9E5A BE AF FC 00           DC L:SetPurgeStat-1
0601 9E5E 44 B0 FC 00           DC L:CountFonts-1
0602 9E62 64 B1 FC 00           DC L:FindFontStats-1
0603 9E66 C8 B1 FC 00           DC L:LoadFont-1
0604 9E6A D0 B1 FC 00           DC L:LoadSysFont-1
0605 9E6E EF B1 FC 00           DC L:AddFontVar-1
0606 9E72 40 B5 FC 00           DC L:FixFontMenu-1
0607 9E76 6B B6 FC 00           DC L:ChooseFont-1
0608 9E7A FC B5 FC 00           DC L:ItemID2FamNum-1
0609 9E7E CC B2 FC 00           DC L:FMSetSysFont-1
0610 9E82 2A B3 FC 00           DC L:FMGetSysFID-1
0611 9E86 3B B3 FC 00           DC L:FMGetCurFID-1
0612 9E8A 30 B6 FC 00           DC L:FamNum2ItemID-1           ;** added 2-25-87 CAE **
0613 9E8E D4 B4 FC 00           DC L:InstallWithStats-1
0614 9E92              TheEnd    
0615 9E92
0616 9E92                       ENDP 
0617 9E92
0618 9E92
0619 9E92                       ENTRY FMData
0620 9E92              FMData   PROC 
0621 9E92
0622 9E92                       Import StyleHit 
0623 9E92                       Import CancelHit 
0624 9E92                       Import OKHit 
0625 9E92                       Import PlainHit 
0626 9E92
0627 9E92              *---------------------------------------------------------------
0628 9E92              * Font Manager Data
0629 9E92              *---------------------------------------------------------------
0630 9E92              *
0631 9E92              *  The following are templates, so they'll get copied over into
0632 9E92              *  RAM for later use:
0633 9E92              *
0634 9E92              *
0635 9E92                       ENTRY FMParams
0636 9E92              FMParams  
0637 9E92
0638 9E92              *-------------- GetDirEntry Parameter Block --------------------
0639 9E92
0640 9E92                       ENTRY GDERef
0641 9E92 00 00        GDERef   DC W:0
0642 9E94                       ENTRY GDEReserved
0643 9E94 00 00        GDEReserved DC W:0
0644 9E96                       ENTRY GDEBase
0645 9E96 01 00        GDEBase  DC W:1
0646 9E98                       ENTRY GDEDisplace
0647 9E98 01 00        GDEDisplace DC W:1
0648 9E9A                       ENTRY GDENameBufPtr
0649 9E9A C2 9E FC 00  GDENameBufPtr DC L:GDENameBuf
0650 9E9E                       ENTRY GDEEntry
0651 9E9E 00 00        GDEEntry DC W:0
0652 9EA0                       ENTRY GDEFileType
0653 9EA0 00 00        GDEFileType DC W:0
0654 9EA2                       ENTRY GDEEOF
0655 9EA2 00 00 00 00  GDEEOF   DC L:0
0656 9EA6                       ENTRY GDEBlockCount
0657 9EA6 00 00 00 00  GDEBlockCount DC L:0
0658 9EAA                       ENTRY GDECreateTime
0659 9EAA 00 00 00 00  GDECreateTime DS B:8
0660 9EB2                       ENTRY GDEModTime
0661 9EB2 00 00 00 00  GDEModTime DS B:8
0662 9EBA                       ENTRY GDEAccess
0663 9EBA 00 00        GDEAccess DC W:0
0664 9EBC                       ENTRY GDEAuxType
0665 9EBC 00 00 00 00  GDEAuxType DC L:0
0666 9EC0                       ENTRY GDEFileSysID
0667 9EC0 00 00        GDEFileSysID DC W:0
0668 9EC2
0669 9EC2              ;name buffer:
0670 9EC2                       ENTRY GDENameBuf
0671 9EC2 14 00        GDENameBuf DC W:GDENameBufSize
0672 9EC4                       ENTRY GDENameLen
0673 9EC4 00 00        GDENameLen DC W:0
0674 9EC6 00 00 00 00  GDEName  DS B:GDENameBufSize-4
0675 9ED6
0676 9ED6              *-------------- Font Filename Stuff ----------------------------
0677 9ED6
0678 9ED6                       ENTRY DirName
0679 9ED6 00           DirName  DC B:0                         ;length byte
0680 9ED7 2A 2F 53 79           DC B:'*/System/Fonts'
0681 9EE5                       ENTRY FileName
0682 9EE5 2F 20 20 20  FileName DC B:'/               '
0683 9EF5              ;
0684 9EF5                       ENTRY FLFileName
0685 9EF5 0A           FLFileName DC B:10
0686 9EF6 66 6F 6E 74           DC B:'font.lists'
0687 9F00
0688 9F00              *-------------- Dummy Menu Item for FixFontMenu ----------------
0689 9F00
0690 9F00                       ENTRY DummyItem
0691 9F00 20 20        DummyItem DC B:'  '                     ;place holder
0692 9F02 20 5C 48              DC B:' \H'                     ;dummy string
0693 9F05                       ENTRY DummyItemID
0694 9F05 00 00        DummyItemID DC W:0                      ;item ID
0695 9F07 00                    DC B:0                         ;terminator
0696 9F08
0697 9F08
0698 9F08                       ENTRY StyleItemRect
0699 9F08 00 00 00 00  StyleItemRect DS B:8
0700 9F10
0701 9F10
0702 9F10 00 00 00 00           DS B:8
0703 9F18 01 00                 DC W:1
0704 9F1A 81 81 81 81           DC B:129,129,129,129
0705 9F1E 2A 9F FC 00           DC L:H9F2A
0706 9F22 42 9F FC 00           DC L:H9F42
0707 9F26 00 00 00 00           DC L:0
0708 9F2A 01 00 1E 00  H9F2A    DC W:1,30,175,43,240,10
0709 9F36 32 A0 FC 00           DC L:OKStr
0710 9F3A 00 00 00 00           DS B:8
0711 9F42 02 00 05 00  H9F42    DC W:2,5,70,25,220
0712 9F4C 0F 80                 DC B:15,128
0713 9F4E 67 A0 FC 00           DC L:AlertStr
0714 9F52 00 00 00 00           DS B:8
0715 9F5A
0716 9F5A
0717 9F5A              *-------------- List Stuff for ChooseFont and FixFontMenu ------
0718 9F5A
0719 9F5A                       ENTRY MDListRect
0720 9F5A 00 00 00 00  MDListRect DS B:8                       ;list's enclosing rectangle
0721 9F62                       ENTRY MDListSize
0722 9F62 00 00        MDListSize DC W:0                       ;# of members in list
0723 9F64 06 00                 DC W:6                         ;view size
0724 9F66 02 00                 DC W:2                         ;type of members
0725 9F68 01 00                 DC W:1                         ;starting member
0726 9F6A 00 00 00 00           DC L:0                         ;space for list control's handle
0727 9F6E 00 00 00 00           DC L:0                         ;address of routine to draw members
0728 9F72 0A 00                 DC W:10                        ;height of member in pixels
0729 9F74 08 00                 DC W:8                         ;size of each member record
0730 9F76                       ENTRY MDListPtr
0731 9F76 00 00 00 00  MDListPtr DC L:0                        ;pointer to member list
0732 9F7A D2 B8 FC 00           DC L:FontHit                   ;refcon
0733 9F7E 00 00 00 00           DC L:0                         ;address of color table for scroll bar;
0734 9F82
0735 9F82                       ENTRY SizeListRect
0736 9F82 00 00 00 00  SizeListRect DS B:8                     ;list's enclosing rectangle
0737 9F8A                       ENTRY SizeListSize
0738 9F8A 00 00        SizeListSize DC W:0                     ;# of members in list
0739 9F8C 06 00                 DC W:6                         ;view size
0740 9F8E 02 00                 DC W:2                         ;type of members
0741 9F90 01 00                 DC W:1                         ;starting member
0742 9F92 00 00 00 00           DC L:0                         ;space for list control's handle
0743 9F96 04 BE FC 00           DC L:DrawSize                  ;address of routine to draw members
0744 9F9A 0A 00                 DC W:10                        ;height of member in pixels
0745 9F9C 05 00                 DC W:5                         ;size of each member record
0746 9F9E                       ENTRY SizeListPtr
0747 9F9E BA 9F FC 00  SizeListPtr DC L:SizeList               ;pointer to member list
0748 9FA2 07 B9 FC 00           DC L:SizeHit                   ;refcon
0749 9FA6 00 00 00 00           DC L:0                         ;address of color table for scroll bar
0750 9FAA
0751 9FAA                       ENTRY WindTemplates
0752 9FAA 01 1B FF 0F  WindTemplates DC L:$0FFF1B01            ; 320 mode choosefont window res ID
0753 9FAE 00 00 00 00           DC L:0                         ; 320 mode alert window
0754 9FB2 02 1B FF 0F           DC L:$0FFF1B02                 ; 640 mode choosefont window res ID
0755 9FB6 00 00 00 00           DC L:0                         ; 640 mode alert window
0756 9FBA
0757 9FBA                       ENTRY SizeList
0758 9FBA 00 00 00 00  SizeList DS B:60                        ;space for 12 Size list members
0759 9FF6
0760 9FF6                       ENTRY StrLen
0761 9FF6                       ENTRY TheStr
0762 9FF6 00           StrLen   DS B:1
0763 9FF7 00 00 00     TheStr   DS B:3
0764 9FFA
0765 9FFA                       ENTRY EndOfFMParams
0766 9FFA              EndOfFMParams  
0767 9FFA              ;
0768 9FFA              ; ROM only data follows
0769 9FFA
0770 9FFA                       entry OtherRect 
0771 9FFA 63 00 CD 00  OtherRect DC W:99,205,112,241
0772 A002 63 00 CD 00           DC W:99,205,112,241
0773 A00A
0774 A00A                       entry AlertRect 
0775 A00A 23 00 23 00  AlertRect DC W:35,35,85,285
0776 A012 23 00 C3 00           DC W:35,195,85,445
0777 A01A
0778 A01A                       ENTRY StrData
0779 A01A              StrData   
0780 A01A                       ENTRY StylePtrs
0781 A01A 3C A0 FC 00  StylePtrs DC L:Style1Str
0782 A01E 42 A0 FC 00           DC L:Style2Str
0783 A022 47 A0 FC 00           DC L:Style3Str
0784 A026 4E A0 FC 00           DC L:Style4Str
0785 A02A 58 A0 FC 00           DC L:Style5Str
0786 A02E 60 A0 FC 00           DC L:Style6Str
0787 A032
0788 A032                       ENTRY OKStr
0789 A032 02 4F 4B     OKStr    DC C:'OK'
0790 A035
0791 A035                       ENTRY CancelStr
0792 A035 06 43 61 6E  CancelStr DC C:'Cancel'
0793 A03C
0794 A03C                       ENTRY Style1Str
0795 A03C                       ENTRY Style2Str
0796 A03C                       ENTRY Style3Str
0797 A03C                       ENTRY Style4Str
0798 A03C                       ENTRY Style5Str
0799 A03C                       ENTRY Style6Str
0800 A03C 05 50 6C 61  Style1Str DC C:'Plain'
0801 A042 04 42 6F 6C  Style2Str DC C:'Bold'
0802 A047 06 49 74 61  Style3Str DC C:'Italic'
0803 A04E 09 55 6E 64  Style4Str DC C:'Underline'
0804 A058 07 4F 75 74  Style5Str DC C:'Outline'
0805 A060 06 53 68 61  Style6Str DC C:'Shadow'
0806 A067
0807 A067
0808 A067                       ENTRY AlertStr
0809 A067              TempStart  
0810 A067 29           AlertStr DC B:TempEnd-TempStart-1       ; $29                        ;EndAlertStr-AlertStr-1
0811 A068 46 6F 6E 74           DC B:'Font size must be a'
0812 A07B 0D                    DC B:$0D
0813 A07C 6E 75 6D 62           DC B:'number from 1 to 255.'
0814 A091                       ENTRY EndAlertStr
0815 A091              EndAlertStr  
0816 A091              TempEnd   
0817 A091
0818 A091                       ENDP 
0819 A091
0820 A091
0821 A091
0822 A091              ;                COPY init
0823 A091
0824 A091              ****************************************************************
0825 A091              *
0826 A091              * FMBootInit
0827 A091              *
0828 A091              ****************************************************************
0829 A091
0830 A091                       ENTRY FMBootInit
0831 A091              FMBootInit PROC 
0832 A091 4C 82 C1              jmp   oStdEnd0
0833 A094                       ENDP 
0834 A094
0835 A094
0836 A094
0837 A094              ****************************************************************
0838 A094              *
0839 A094              * FMStartUp
0840 A094              *
0841 A094              ****************************************************************
0842 A094
0843 A094                       ENTRY FMStartUp
0844 A094              FMStartUp PROC 
0845 A094
0846 A094              EntryLength equ   Temp
0847 A094              EntriesInBlock equ   EntryLength+2
0848 A094              EntryCount equ   EntriesInBlock+2
0849 A094              NumFiles equ   EntryCount+2
0850 A094              NumFonts equ   NumFiles+2
0851 A094              FileCount equ   NumFonts+2
0852 A094              Mult2    equ   FileCount+2
0853 A094              Mult8    equ   Mult2+2
0854 A094              Mult16   equ   Mult8+2
0855 A094
0856 A094              RomInfoRec equ   Mult16+2               ;the following items MUST appear
0857 A094              RomFamNum equ   RomInfoRec              ;in this order
0858 A094              RomStyle equ   RomFamNum+2
0859 A094              RomSize  equ   RomStyle+2
0860 A094              RomFontHndl equ   RomSize+2
0861 A094              RomNamePtr equ   RomFontHndl+4
0862 A094              RomExtent equ   RomNamePtr+4
0863 A094              ;
0864 A094              ;added 8/31/87
0865 A094              fNamePtr equ   RomExtent+2
0866 A094              currFNamePtr equ   fNamePtr+4
0867 A094              ;
0868 A094              fNameLen equ   currFNamePtr+4
0869 A094              currFNameLen equ   fNameLen+2
0870 A094              errCode  equ   currFNameLen+2
0871 A094              FLFileRef equ   errCode+2
0872 A094              FONTSDirRef equ   FLFileRef+2
0873 A094              FileListSize equ   FONTSDirRef+2
0874 A094              NumFontFiles equ   FileListSize+2
0875 A094              ;added 9/24/87
0876 A094              TimeListSize equ   NumFontFiles+2
0877 A094              TimeHandle equ   TimeListSize+2
0878 A094              TimePtr  equ   TimeHandle+4
0879 A094              SavedTimePtr equ   TimePtr+4
0880 A094              fTimePtr equ   SavedTimePtr+4
0881 A094              ;end of additions - BHM  x6245
0882 A094              ;
0883 A094
0884 A094 C9 00 00              cmp   #0                       ;already initialized?
0885 A097 F0 0A                 beq   @Doit                    ;no
0886 A099 A2 01 1B              ldx   #InitErr                 ;yes - so return error
0887 A09C A0 04 00     @stupidErr ldy   #4                     ;param size
0888 A09F 5C B4 FC FE           jml   oerrout
0889 A0A3
0890 A0A3              @Doit     
0891 A0A3 0B                    phd   
0892 A0A4 A3 09                 lda   9,s                      ;get zero page address
0893 A0A6 5B                    tcd   
0894 A0A7
0895 A0A7 A2 FE 00              ldx   #$FE
0896 A0AA 74 00        ZPLoop   stz   <FMZBase,x               ;clear zero page
0897 A0AC CA                    dex   
0898 A0AD CA                    dex   
0899 A0AE 10 FA                 bpl   ZPLoop
0900 A0B0
0901 A0B0 A3 0B                 lda   11,s                     ;get program ID
0902 A0B2 85 84                 sta   <ProgID                  ;and save
0903 A0B4              ;
0904 A0B4              ;get RAM space for some mutable FM data, and move them in:
0905 A0B4 20 E3 A7              jsr   SetUpFMParams
0906 A0B7 90 04                 bcc   GotFMParams
0907 A0B9 AA                    tax                            ;error code
0908 A0BA 4C 90 C1              jmp   StdErr4
0909 A0BD              GotFMParams  
0910 A0BD              ;
0911 A0BD              ;get a buffer for block reads:
0912 A0BD A9 00 02              lda   #BlockSize               ;512 bytes
0913 A0C0 20 49 BF              jsr   GetHandle                ;get space to do block reads into
0914 A0C3 90 05                 bcc   GotMem
0915 A0C5 85 CE                 sta   <errCode
0916 A0C7 82 CD 00              brl   Error1                   ;return the error
0917 A0CA              ;
0918 A0CA 85 18        GotMem   sta   <BlockHandle             ;get handle to block
0919 A0CC 86 1A                 stx   <BlockHandle+2
0920 A0CE              ;
0921 A0CE 20 21 C1              jsr   LockBlock
0922 A0D1              ;
0923 A0D1 20 27 A5              jsr   GetListHandles
0924 A0D4 90 05                 bcc   GotListHandles
0925 A0D6 85 CE                 sta   <errCode
0926 A0D8 82 B1 00              brl   Error1a
0927 A0DB              GotListHandles  
0928 A0DB
0929 A0DB              *****************************************************************************
0930 A0DB              *
0931 A0DB              *  Error-handling changed here and below so that ProDOS errors in handling
0932 A0DB              *  FONT.LISTS do not abort the start-up.  (In particular, trying to create
0933 A0DB              *  and/or update FONT.LISTS when the system disk is write-protected does not
0934 A0DB              *  generate an error; FONT.LISTS is just forgotten about is those cases.)
0935 A0DB              *
0936 A0DB              *  Bennet Marks  x6245  1/7/88
0937 A0DB              *
0938 A0DB              *****************************************************************************
0939 A0DB
0940 A0DB 20 41 A8              jsr   OpenFLFile               ;will also create it, if need be
0941 A0DE 90 0A                 bcc   GotFLFile
0942 A0E0              ;some error condition - treat FONT.LISTS as invalid (i.e., useless)
0943 A0E0              ;
0944 A0E0 20 21 A4              jsr   OpenFONTSDir
0945 A0E3 90 14                 bcc   FLFileNotValid           ;because it's empty
0946 A0E5 85 CE                 sta   <errCode
0947 A0E7 82 68 00              brl   Error2a
0948 A0EA
0949 A0EA              GotFLFile                               ;and it's open, too
0950 A0EA 20 21 A4              jsr   OpenFONTSDir
0951 A0ED 90 05                 bcc   GotFONTSDir
0952 A0EF 85 CE                 sta   <errCode
0953 A0F1 82 5E 00              brl   Error3
0954 A0F4
0955 A0F4              GotFONTSDir  
0956 A0F4 20 20 A6              jsr   CheckFLFile
0957 A0F7 90 17                 bcc   FLFileGood
0958 A0F9              ;some error condition - FONT.LISTS useless
0959 A0F9              ;
0960 A0F9              FLFileNotValid  
0961 A0F9              ;FONTS open, marked at beginning & FONT.LISTS open, empty
0962 A0F9              ;
0963 A0F9              ;FONT.LISTS didn't pass its validity test, so we have to make
0964 A0F9              ;the lists "the old-fashioned way"
0965 A0F9              ;
0966 A0F9 20 48 A4              jsr   GetFileNames
0967 A0FC 90 03                 bcc   GotFileNames
0968 A0FE 82 4E 00              brl   Error5
0969 A101              ;
0970 A101              GotFileNames  
0971 A101 20 A7 A1              jsr   SetUpFontInfo
0972 A104 90 05                 bcc   FontListsOK
0973 A106 85 CE                 sta   <errCode
0974 A108 82 44 00              brl   Error6
0975 A10B              ;
0976 A10B              FontListsOK  
0977 A10B 20 60 A9              jsr   UpdateFLFile
0978 A10E              ;ignore any errors - just because we can't
0979 A10E              ;update FONT.LISTS doesn't mean we should quit
0980 A10E 80 0A                 bra   WeAreDone
0981 A110              ;
0982 A110              ;
0983 A110              FLFileGood  
0984 A110              ;FONT.LISTS passed the validity tests, so we trust the rest of its info
0985 A110 20 C1 A8              jsr   ReadFontLists
0986 A113 90 05                 bcc   GotFontLists
0987 A115 85 CE                 sta   <errCode
0988 A117 82 35 00              brl   Error8
0989 A11A              ;
0990 A11A              GotFontLists  
0991 A11A              ;all done, so:
0992 A11A              ;
0993 A11A              WeAreDone  
0994 A11A              ;
0995 A11A 20 58 A9              jsr   CloseFLFile
0996 A11D 20 A6 A5              jsr   CloseFONTSDir
0997 A120              ;
0998 A120 20 4B C1              jsr   UnlockFMParams
0999 A123              ;
1000 A123 D4 1A D4 18           PushZLong <BlockHandle 
1001 A127 A2 02 10 22           _DisposeHandle 
1002 A12E              ;(NOTE:  later, we may actually want to keep the param block around until
1003 A12E              ;FMShutDown.  For this we need another permanent handle - but we'll get back
1004 A12E              ;0-page space now used for ProDOS call parameters.)
1005 A12E              ;
1006 A12E D4 DC D4 DA           PushZLong <TimeHandle 
1007 A132 A2 02 10 22           _DisposeHandle 
1008 A139              ;
1009 A139 A3 09                 lda   9,s                      ;get zero page address
1010 A13B F4 00 00              PushWord #0 
1011 A13E F4 1B 00              PushWord #FMTSNum 
1012 A141 F4 00 00              PushWord #0 
1013 A144 48                    pha   
1014 A145 A2 01 0D 22           _SetWAP                        ;set work area pointer
1015 A14C
1016 A14C 4C 89 C1              jmp   StdEnd4
1017 A14F              ;
1018 A14F              ;
1019 A14F              Error8    
1020 A14F              Error7    
1021 A14F              Error6    
1022 A14F              Error5    
1023 A14F              Error4    
1024 A14F 20 A6 A5              jsr   CloseFONTSDir
1025 A152              ;
1026 A152              Error3    
1027 A152              Error2a   
1028 A152 20 58 A9              jsr   CloseFLFile
1029 A155              ;
1030 A155              Error2    
1031 A155 D4 06 D4 04           PushZLong <FileHandle 
1032 A159 A2 02 10 22           _DisposeHandle 
1033 A160 D4 0A D4 08           PushZLong <IDHandle 
1034 A164 A2 02 10 22           _DisposeHandle 
1035 A16B D4 0E D4 0C           PushZLong <FamHandle 
1036 A16F A2 02 10 22           _DisposeHandle 
1037 A176 D4 12 D4 10           PushZLong <NameHandle 
1038 A17A A2 02 10 22           _DisposeHandle 
1039 A181 D4 DC D4 DA           PushZLong <TimeHandle 
1040 A185 A2 02 10 22           _DisposeHandle 
1041 A18C              ;
1042 A18C              Error1a   
1043 A18C D4 1A D4 18           PushZLong <BlockHandle 
1044 A190 A2 02 10 22           _DisposeHandle 
1045 A197              ;
1046 A197              Error1    
1047 A197 D4 26 D4 24           PushZLong <FMParamHandle 
1048 A19B A2 02 10 22           _DisposeHandle 
1049 A1A2              ;
1050 A1A2 A6 CE                 ldx   <errCode
1051 A1A4 4C 90 C1              jmp   StdErr4
1052 A1A7              ***************************************
1053 A1A7              *                                     *
1054 A1A7              *  end FMStartUp                      *
1055 A1A7              *                                     *
1056 A1A7              ***************************************
1057 A1A7              ;
1058 A1A7              *****************************************************************************
1059 A1A7              *                                                                           *
1060 A1A7              *  subroutine SetupFontInfo                                                 *
1061 A1A7              *                                                                           *
1062 A1A7              *****************************************************************************
1063 A1A7              ;
1064 A1A7              ***************************************
1065 A1A7              *                                     *
1066 A1A7              *  9/8/87  5:40 pm                    *
1067 A1A7              *  BHM  x6245                         *
1068 A1A7              *                                     *
1069 A1A7              ***************************************
1070 A1A7              ;
1071 A1A7              SetupFontInfo  
1072 A1A7              ;
1073 A1A7 20 EC C0              jsr   LockIDList
1074 A1AA 20 F8 C0              jsr   LockFamList
1075 A1AD 20 04 C1              jsr   LockNameList
1076 A1B0 20 E0 C0              jsr   LockFileList
1077 A1B3 20 15 A4              jsr   SaveListPtrs             ;save ptrs to all 4 lists
1078 A1B6
1079 A1B6              ;Set up first entry in each list for ROM font.  At FMStartUp time,
1080 A1B6              ;QuickDraw system font must be the ROM font so set SysFontID to ID of ROM font.
1081 A1B6
1082 A1B6 F4 00 00 7B           PushZPtr <RomInfoRec 
1083 A1BF A2 04 D8 22           _GetRomFont 
1084 A1C6
1085 A1C6 A5 C0                 lda   <RomExtent
1086 A1C8 85 8A                 sta   <RomFbrExtent            ;save for GrowTextBuf routine
1087 A1CA
1088 A1CA A5 B2                 lda   <RomFamNum               ;get ROM font's fam #
1089 A1CC 87 34                 sta   [<FamPtr]                ;store in fam entry
1090 A1CE 87 30                 sta   [<IDPtr]                 ;and ID entry
1091 A1D0 85 86                 sta   <SysFontID               ;and Sys font info
1092 A1D2
1093 A1D2 A5 B6                 lda   <RomSize                 ;get ROM font's size
1094 A1D4 EB                    xba   
1095 A1D5 05 B4                 ora   <RomStyle                ;OR with ROM font's style
1096 A1D7 A0 02 00              ldy   #2
1097 A1DA 97 30                 sta   [<IDPtr],y               ;store style/size word in ID entry
1098 A1DC 85 88                 sta   <SysFontID+2             ;and Sys font info
1099 A1DE
1100 A1DE A9 00 00              lda   #0                       ;zero out fields in ID and fam entries
1101 A1E1 97 34                 sta   [<FamPtr],y              ;offset to famname entry
1102 A1E3 C8                    iny   
1103 A1E4 C8                    iny   
1104 A1E5 97 34                 sta   [<FamPtr],y              ;info word
1105 A1E7 97 30                 sta   [<IDPtr],y               ;offset to famname entry
1106 A1E9 C8                    iny   
1107 A1EA C8                    iny   
1108 A1EB 97 30                 sta   [<IDPtr],y               ;offset to filename entry
1109 A1ED C8                    iny   
1110 A1EE C8                    iny   
1111 A1EF A9 01 00              lda   #MemBit
1112 A1F2 97 30                 sta   [<IDPtr],y               ;info word (MemBit set)
1113 A1F4
1114 A1F4 A5 B4                 lda   <RomStyle                ;get ROM font's style
1115 A1F6 F0 08                 beq   RomPlain                 ;it's plain
1116 A1F8 A9 20 00              lda   #NotBaseBit
1117 A1FB A0 04 00              ldy   #4
1118 A1FE 97 34                 sta   [<FamPtr],y              ;it's not plain so set 'NotBaseBit'
1119 A200              RomPlain                                ;
1120 A200
1121 A200 A0 0A 00              ldy   #10
1122 A203 A5 B8                 lda   <RomFontHndl             ;get handle to ROM font
1123 A205 97 30                 sta   [<IDPtr],y               ;store in ID entry
1124 A207 C8                    iny   
1125 A208 C8                    iny   
1126 A209 A5 BA                 lda   <RomFontHndl+2
1127 A20B 97 30                 sta   [<IDPtr],y
1128 A20D
1129 A20D A5 BC                 lda   <RomNamePtr              ;get ptr to ROM font name
1130 A20F 85 28                 sta   <TempPtr
1131 A211 A5 BE                 lda   <RomNamePtr+2
1132 A213 85 2A                 sta   <TempPtr+2
1133 A215
1134 A215 20 B4 BF     GotName  jsr   CopyFamName              ;copy ROM font name into famname list
1135 A218
1136 A218 20 8D C0              jsr   IncIDPtr
1137 A21B 20 9D C0              jsr   IncFamPtr
1138 A21E 20 AD C0              jsr   IncNamePtr
1139 A221 20 7A C0              jsr   IncFilePtr
1140 A224
1141 A224              ;Read in the first block of each font file.  Create an ID entry for each font
1142 A224              ;and Family and Name entries for each distinct family.
1143 A224
1144 A224 64 AA                 stz   <FileCount               ;# font files processed
1145 A226 A9 01 00              lda   #1
1146 A229 85 6A                 sta   <FamCount                ;# of font families (count ROM font)
1147 A22B 85 68                 sta   <IDCount                 ;# of fonts (count ROM font)
1148 A22D
1149 A22D A5 A8                 lda   <NumFonts
1150 A22F D0 03                 bne   FileLoop
1151 A231 82 F8 00              brl   Done2                    ;quit if no font files to process
1152 A234
1153 A234 20 D9 BF     FileLoop jsr   CopyFileName             ;copy file name into pathname string
1154 A237              **** changed to use FMParams block - BHM  x6245  11/12/87
1155 A237 A5 4C                 lda   <FMParamPtr
1156 A239 18                    clc   
1157 A23A 69 44 00              adc   #(DirName-FMParams)      ;store ptr to pathname of
1158 A23D 85 6E                 sta   <OpenPtr                 ;font file in OPEN param
1159 A23F A5 4E                 lda   <FMParamPtr+2
1160 A241 69 00 00              adc   #0
1161 A244 85 70                 sta   <OpenPtr+2
1162 A246 20 BF BE              jsr   OpenFile                 ;open the font file
1163 A249 90 01                 bcc   ReadBlock
1164 A24B 60                    rts   
1165 A24C              ;
1166 A24C              ReadBlock  
1167 A24C              ;the Open was just done, so the ref number is in place for reading
1168 A24C A9 00 02              lda   #BlockSize
1169 A24F 85 72                 sta   <ReadSize
1170 A251 A9 00 00              lda   #0
1171 A254 85 74                 sta   <ReadSize+2
1172 A256 A5 40                 lda   <BlockPtr
1173 A258 85 6E                 sta   <ReadPtr
1174 A25A A5 42                 lda   <BlockPtr+2
1175 A25C 85 70                 sta   <ReadPtr+2
1176 A25E              ;(actually, you don't have to do all that, at least not every time -
1177 A25E              ;but I'm just getting used to this stuff - BHM  9/4/87)
1178 A25E              ;
1179 A25E 20 D1 BE              jsr   ReadFile                 ;read first block of font file
1180 A261 90 01                 bcc   NewID
1181 A263              ;
1182 A263 60                    rts                            ;return the error
1183 A264
1184 A264              ;create a new entry in the ID list for this font
1185 A264
1186 A264 38           NewID    sec   
1187 A265 A5 2C                 lda   <FilePtr                 ;calc offset to filename entry in list
1188 A267 E5 50                 sbc   <SavedFilePtr
1189 A269 A0 06 00              ldy   #6
1190 A26C 97 30                 sta   [<IDPtr],y               ;store in ID entry
1191 A26E
1192 A26E A7 40                 lda   [<BlockPtr]              ;get font's famname length
1193 A270 29 FF 00              and   #$00FF
1194 A273 1A                    inc   a                        ;add 1 for the length byte itself
1195 A274 1A                    inc   a                        ;add 2 to skip 'offset to MF' field
1196 A275 1A                    inc   a
1197 A276 A8                    tay                            ;offset to ID in the font file
1198 A277 B7 40                 lda   [<BlockPtr],y            ;get font's family # from file
1199 A279 87 30                 sta   [<IDPtr]                 ;store in ID entry
1200 A27B C8                    iny   
1201 A27C C8                    iny   
1202 A27D B7 40                 lda   [<BlockPtr],y            ;get font's style word from file
1203 A27F 29 FF 00              and   #$00FF                   ;mask off hi byte
1204 A282 48                    pha                            ;save on stack
1205 A283 C8                    iny   
1206 A284 C8                    iny   
1207 A285 B7 40                 lda   [<BlockPtr],y            ;get font's size word from file
1208 A287 29 FF 00              and   #$00FF                   ;mask off hi byte
1209 A28A EB                    xba                            ;swap bytes
1210 A28B 03 01                 ora   1,s                      ;OR with style word
1211 A28D A0 02 00              ldy   #2
1212 A290 97 30                 sta   [<IDPtr],y               ;store style/size word in ID entry
1213 A292 68                    pla                            ;clean up stack
1214 A293
1215 A293 A9 00 00              lda   #0
1216 A296 A0 08 00              ldy   #8
1217 A299 97 30                 sta   [<IDPtr],y               ;zero out info word in ID entry
1218 A29B C8                    iny   
1219 A29C C8                    iny   
1220 A29D 97 30                 sta   [<IDPtr],y               ;zero out font handle in ID entry
1221 A29F C8                    iny   
1222 A2A0 C8                    iny   
1223 A2A1 97 30                 sta   [<IDPtr],y
1224 A2A3
1225 A2A3              ;check if this font's family already has an entry in the Fam list
1226 A2A3
1227 A2A3 A2 00 00              ldx   #0                       ;# of fam entries checked
1228 A2A6 A0 00 00              ldy   #0
1229 A2A9 B7 58        FamLoop  lda   [<SavedFamPtr],y         ;get fam #
1230 A2AB C7 30                 cmp   [<IDPtr]                 ;match?
1231 A2AD F0 0D                 beq   GotFam                   ;yes - so already entry for this fam #
1232 A2AF 98                    tya   
1233 A2B0 18                    clc   
1234 A2B1 69 06 00              adc   #6
1235 A2B4 A8                    tay                            ;create offset to next fam entry
1236 A2B5 E8                    inx   
1237 A2B6 E4 6A                 cpx   <FamCount                ;have we checked all fam entries?
1238 A2B8 D0 EF                 bne   FamLoop                  ;no
1239 A2BA 80 1F                 bra   NewFam                   ;yes - so it's a new fam #
1240 A2BC
1241 A2BC C8           GotFam   iny   
1242 A2BD C8                    iny   
1243 A2BE 5A                    phy                            ;save Y on stack
1244 A2BF B7 58                 lda   [<SavedFamPtr],y         ;get offset to famname
1245 A2C1 A0 04 00              ldy   #4
1246 A2C4 97 30                 sta   [<IDPtr],y               ;store famname offset in ID entry
1247 A2C6 A0 02 00              ldy   #2
1248 A2C9 B7 30                 lda   [<IDPtr],y               ;get style/size of font
1249 A2CB 7A                    ply                            ;retrieve previous value of Y
1250 A2CC 29 FF 00              and   #$00FF                   ;mask off size byte
1251 A2CF D0 07                 bne   NotPlain                 ;branch if font is not plain
1252 A2D1 C8                    iny                            ;font is plain
1253 A2D2 C8                    iny   
1254 A2D3 A9 00 00              lda   #0
1255 A2D6 97 58                 sta   [<SavedFamPtr],y         ;clear info word for fam entry
1256 A2D8 82 38 00     NotPlain brl   NextFile
1257 A2DB
1258 A2DB              ;create new entries in the Fam list and the Name list for this font's family
1259 A2DB
1260 A2DB 38           NewFam   sec   
1261 A2DC A5 38                 lda   <NamePtr
1262 A2DE E5 5C                 sbc   <SavedNamePtr            ;calculate offset to famname in list
1263 A2E0 A0 02 00              ldy   #2
1264 A2E3 97 34                 sta   [<FamPtr],y              ;store in fam entry
1265 A2E5 A0 04 00              ldy   #4
1266 A2E8 97 30                 sta   [<IDPtr],y               ;and ID entry
1267 A2EA
1268 A2EA A5 40                 lda   <BlockPtr
1269 A2EC 85 28                 sta   <TempPtr
1270 A2EE A5 42                 lda   <BlockPtr+2
1271 A2F0 85 2A                 sta   <TempPtr+2
1272 A2F2 20 B4 BF              jsr   CopyFamName              ;copy famname into famname list
1273 A2F5
1274 A2F5 A7 30                 lda   [<IDPtr]                 ;get family #
1275 A2F7 87 34                 sta   [<FamPtr]                ;and save in fam list
1276 A2F9
1277 A2F9 A0 02 00              ldy   #2
1278 A2FC B7 30                 lda   [<IDPtr],y               ;get style/size of font
1279 A2FE 29 FF 00              and   #$00FF                   ;mask off size byte
1280 A301 F0 03                 beq   Plain                    ;branch if font is plain
1281 A303 A9 20 00              lda   #NotBaseBit
1282 A306 A0 04 00     Plain    ldy   #4
1283 A309 97 34                 sta   [<FamPtr],y              ;set info word in fam entry
1284 A30B
1285 A30B E6 6A                 inc   <FamCount                ;# of font families
1286 A30D 20 AD C0              jsr   IncNamePtr
1287 A310 20 9D C0              jsr   IncFamPtr
1288 A313
1289 A313 20 F5 BE     NextFile jsr   CloseFile                ;close the font file
1290 A316              ;(there's been no ProDOS action since Opening and Reading, so
1291 A316              ;the ref number is still right.)
1292 A316 90 01                 bcc   CloseOK
1293 A318 60                    rts   
1294 A319
1295 A319 20 7A C0     CloseOK  jsr   IncFilePtr
1296 A31C 20 8D C0              jsr   IncIDPtr
1297 A31F
1298 A31F E6 68                 inc   <IDCount
1299 A321 E6 AA                 inc   <FileCount
1300 A323 A5 AA                 lda   <FileCount               ;get # font files processed
1301 A325 C5 A8                 cmp   <NumFonts                ;done with all font files?
1302 A327 F0 03                 beq   Done2                    ;yes
1303 A329 82 08 FF              brl   FileLoop                 ;no - so continue
1304 A32C
1305 A32C 20 F2 C0     Done2    jsr   UnLockIDList
1306 A32F 20 FE C0              jsr   UnLockFamList
1307 A332 20 0A C1              jsr   UnLockNameList
1308 A335 20 E6 C0              jsr   UnLockFileList
1309 A338
1310 A338 20 BC A3              jsr   ShrinkLists              ;shrink all lists to correct size
1311 A33B 60                    rts   
1312 A33C              ***************************************
1313 A33C              *                                     *
1314 A33C              *  end SetupFontInfo                  *
1315 A33C              *                                     *
1316 A33C              ***************************************
1317 A33C              ;
1318 A33C              *****************************************************************************
1319 A33C              *                                                                           *
1320 A33C              *  subroutine SizeLists                                                     *
1321 A33C              *                                                                           *
1322 A33C              *    started 8/27/86                                                        *
1323 A33C              *    Bennet Marks  x6245                                                    *
1324 A33C              *                                                                           *
1325 A33C              *  This subroutine re-sizes the Font Manager's lists to the maximum size    *
1326 A33C              *  needed to accept the information read in from all the font files in      *
1327 A33C              *  FONTS.  This is done after FONT.LISTS has failed the validity test (if   *
1328 A33C              *  FONT.LISTS was valid, we would read the lists and their exact sizes in   *
1329 A33C              *  from there).                                                             *
1330 A33C              *                                                                           *
1331 A33C              *  The sizing is based on the number of font files, and the maximum allowed *
1332 A33C              *  lengths for font family names and file names.  The lists will be shrunk  *
1333 A33C              *  after the actual space needed is known.                                  *
1334 A33C              *                                                                           *
1335 A33C              *  If the SizeLists succeeds, it returns with carry clear; otherwise it     *
1336 A33C              *  returns with carry set and the error code in the acc.  SizeLists returns *
1337 A33C              *  by an RTS, and does not have a separate entry point; it's part of        *
1338 A33C              *  FMStartUp.                                                               *
1339 A33C              *                                                                           *
1340 A33C              *****************************************************************************
1341 A33C              ;
1342 A33C              ***************************************
1343 A33C              *                                     *
1344 A33C              *  9/24/87  12:45 pm                  *
1345 A33C              *  BHM  x6245                         *
1346 A33C              *                                     *
1347 A33C              ***************************************
1348 A33C              ;
1349 A33C F4 00 00     SizeLists PushWord #0                   ;for high word of size
1350 A33F
1351 A33F A5 A6                 lda   <NumFiles                ;get # of files in FONTS
1352 A341 1A                    inc   a                        ;add 1 for ROM font
1353 A342 0A                    asl   a
1354 A343 85 AC                 sta   <Mult2                   ;multiply by 2 and save result
1355 A345 0A                    asl   a
1356 A346 0A                    asl   a
1357 A347 85 AE                 sta   <Mult8                   ;multiply by 8 and save result
1358 A349 0A                    asl   a
1359 A34A 85 B0                 sta   <Mult16                  ;multiply by 16 and save result
1360 A34C
1361 A34C 18                    clc   
1362 A34D A5 B0                 lda   <Mult16
1363 A34F 65 AE                 adc   <Mult8
1364 A351 65 AC                 adc   <Mult2
1365 A353 48                    pha                            ;low word of size
1366 A354 D4 12 D4 10           PushZLong <NameHandle 
1367 A358 A2 02 19 22           _SetHandleSize 
1368 A35F 90 01                 bcc   SizedNameHndl
1369 A361 60                    rts   
1370 A362              SizedNameHndl  
1371 A362 20 E6 C0              jsr   UnlockFileList
1372 A365 20 C4 A5              jsr   UnlockTimeList
1373 A368
1374 A368 F4 00 00              PushWord #0                    ;high word of size
1375 A36B A5 B0                 lda   <Mult16                  ;low word of size
1376 A36D 48                    pha   
1377 A36E D4 06 D4 04           PushZLong <FileHandle 
1378 A372 A2 02 19 22           _SetHandleSize 
1379 A379 90 01                 bcc   SizedFileHndl
1380 A37B 60                    rts   
1381 A37C              SizedFileHndl  
1382 A37C F4 00 00              PushWord #0                    ;high word of size
1383 A37F 38                    sec   
1384 A380 A5 B0                 lda   <Mult16
1385 A382 E5 AC                 sbc   <Mult2                   ;low word of size
1386 A384 48                    pha   
1387 A385 D4 0A D4 08           PushZLong <IDHandle 
1388 A389 A2 02 19 22           _SetHandleSize 
1389 A390 90 01                 bcc   SizedIDHndl
1390 A392 60                    rts   
1391 A393              SizedIDHndl  
1392 A393 F4 00 00              PushWord #0                    ;hi
1393 A396 38                    sec   
1394 A397 A5 AE                 lda   <Mult8
1395 A399 E5 AC                 sbc   <Mult2                   ;low
1396 A39B 48                    pha   
1397 A39C D4 0E D4 0C           PushZLong <FamHandle 
1398 A3A0 A2 02 19 22           _SetHandleSize 
1399 A3A7 90 01                 bcc   SizedFamHandle
1400 A3A9 60                    rts   
1401 A3AA              SizedFamHandle  
1402 A3AA F4 00 00              PushWord #0 
1403 A3AD A5 B0 48              PushWord <Mult16 
1404 A3B0 D4 DC D4 DA           PushZLong <TimeHandle 
1405 A3B4 A2 02 19 22           _SetHandleSize 
1406 A3BB 60                    rts   
1407 A3BC
1408 A3BC              ***************************************
1409 A3BC              *                                     *
1410 A3BC              *  end SizeLists                      *
1411 A3BC              *                                     *
1412 A3BC              ***************************************
1413 A3BC              ;
1414 A3BC              ****************************************************************************
1415 A3BC              *                                                                          *
1416 A3BC              *  subroutine ShrinkLists                                                  *
1417 A3BC              *                                                                          *
1418 A3BC              ****************************************************************************
1419 A3BC              ;
1420 A3BC              ***************************************
1421 A3BC              *                                     *
1422 A3BC              *  9/28/87  2:20 pm                   *
1423 A3BC              *  BHM  x6245                         *
1424 A3BC              *                                     *
1425 A3BC              ***************************************
1426 A3BC              ;
1427 A3BC              ShrinkLists  
1428 A3BC              ;
1429 A3BC 38                    sec   
1430 A3BD A5 2C                 lda   <FilePtr
1431 A3BF E5 50                 sbc   <SavedFilePtr            ;calculate final size of filename list
1432 A3C1 85 D4                 sta   <FileListSize
1433 A3C3 F4 00 00              PushWord #0                    ;hi word of size
1434 A3C6 48                    pha                            ;lo word of size
1435 A3C7 D4 06 D4 04           PushZLong <FileHandle          ;handle to list
1436 A3CB A2 02 19 22           _SetHandleSize                 ;shrink list to correct size
1437 A3D2
1438 A3D2 38                    sec   
1439 A3D3 A5 38                 lda   <NamePtr
1440 A3D5 E5 5C                 sbc   <SavedNamePtr            ;calculate final size of famname list
1441 A3D7 85 64                 sta   <NameListSize            ;and save
1442 A3D9 F4 00 00              Pushword #0                    ;hi word of size
1443 A3DC 48                    pha                            ;lo word of size
1444 A3DD D4 12 D4 10           PushZLong <NameHandle          ;handle to list
1445 A3E1 A2 02 19 22           _SetHandleSize                 ;shrink list to correct size
1446 A3E8
1447 A3E8 38                    sec   
1448 A3E9 A5 34                 lda   <FamPtr
1449 A3EB E5 58                 sbc   <SavedFamPtr             ;calculate final size of family list
1450 A3ED 85 62                 sta   <FamListSize             ;and save
1451 A3EF F4 00 00              PushWord #0                    ;hi word of size
1452 A3F2 48                    pha                            ;lo word of size
1453 A3F3 D4 0E D4 0C           PushZLong <FamHandle           ;handle to list
1454 A3F7 A2 02 19 22           _SetHandleSize                 ;shrink list to correct size
1455 A3FE
1456 A3FE 38                    sec   
1457 A3FF A5 30                 lda   <IDPtr
1458 A401 E5 54                 sbc   <SavedIDPtr              ;calculate final size of ID list
1459 A403 85 60                 sta   <IDListSize              ;and save
1460 A405 F4 00 00              PushWord #0                    ;hi word of size
1461 A408 48                    pha                            ;lo word of size
1462 A409 D4 0A D4 08           PushZLong <IDHandle            ;handle to list
1463 A40D A2 02 19 22           _SetHandleSize                 ;shrink list to correct size
1464 A414              ;
1465 A414              ;time list is handled in GetFileNames
1466 A414 60                    rts   
1467 A415
1468 A415              ;-----------------------------------------------------------------------------
1469 A415
1470 A415 A2 0E 00     SaveListPtrs ldx   #14
1471 A418 B5 2C        Loop     lda   <FilePtr,x
1472 A41A 95 50                 sta   <SavedFilePtr,x
1473 A41C CA                    dex   
1474 A41D CA                    dex   
1475 A41E 10 F8                 bpl   Loop
1476 A420              ;
1477 A420              ;time list is handles in GetFileNames
1478 A420 60                    rts   
1479 A421              ;
1480 A421              *****************************************************************************
1481 A421              *                                                                           *
1482 A421              *  subroutine OpenFONTSDir                                                  *
1483 A421              *                                                                           *
1484 A421              *    started 8/27/87                                                        *
1485 A421              *    Bennet Marks  x6245                                                    *
1486 A421              *                                                                           *
1487 A421              *  This subroutine opens the subdirectory *:SYSTEM:FONTS, which is supposed *
1488 A421              *  to contain all font files (that the Font Manager is to handle) and the   *
1489 A421              *  file FONT.LISTS.  If it succeeds, it saves the subdirectory's reference  *
1490 A421              *  number in FONTSDirRef, and returns with the carry clear; otherwise it    *
1491 A421              *  returns with the carry set and the error number in the acc.              *
1492 A421              *                                                                           *
1493 A421              *  Currently, OpenFONTSDir returns with an RTS, and does not have a         *
1494 A421              *  separate entry point; it's just part of FMStartUp.                       *
1495 A421              *                                                                           *
1496 A421              *****************************************************************************
1497 A421              ;
1498 A421              ***************************************
1499 A421              *                                     *
1500 A421              *  2/9/88 (Happy Birthday, Steve!     *
1501 A421              *  BHM  x6245                         *
1502 A421              *                                     *
1503 A421              ***************************************
1504 A421              ;
1505 A421              OpenFONTSDir                            ;
1506 A421              ;
1507 A421              ****  changed to use FMParams block - BHM  x6245  11/12/87
1508 A421              ;
1509 A421 A0 44 00              ldy   #(DirName-FMParams)
1510 A424 B7 4C                 lda   [<FMParamPtr],y          ;get first word of font subdir-
1511 A426 29 00 FF              and   #$FF00                   ;ectory name and clear lenght byte
1512 A429 09 0E 00              ora   #DirNameLen              ;set length to proper value
1513 A42C 97 4C                 sta   [<FMParamPtr],y          ;and save
1514 A42E
1515 A42E A5 4C                 lda   <FMParamPtr
1516 A430 18                    clc   
1517 A431 69 44 00              adc   #(DirName-FMParams)      ;store ptr to name of font subdirectory
1518 A434 85 6E                 sta   <OpenPtr                 ;in OPEN params
1519 A436              ;correction added 2/9/88               
1520 A436 A5 4E                 lda   <FMParamPtr+2
1521 A438 69 00 00              adc   #0
1522 A43B 85 70                 sta   <OpenPtr+2
1523 A43D              ;end of correction - BHM  x6245  2/9/88
1524 A43D 20 BF BE              jsr   OpenFile                 ;open the font subdirectory file
1525 A440 90 01                 bcc   OpenOK
1526 A442 60                    rts                            ;back with error
1527 A443              ;
1528 A443              OpenOK                                  ;
1529 A443 A5 6C                 lda   <OpenRef
1530 A445 85 D2                 sta   <FONTSDirRef
1531 A447 60                    rts   
1532 A448              ***************************************
1533 A448              *                                     *
1534 A448              *  end OpenFONTSDir                   *
1535 A448              *                                     *
1536 A448              ***************************************
1537 A448              ;
1538 A448              *****************************************************************************
1539 A448              *                                                                           *
1540 A448              *  subroutine GetFileNames                                                  *
1541 A448              *                                                                           *
1542 A448              *    started 8/27/87                                                        *
1543 A448              *    Bennet Marks  x6245                                                    *
1544 A448              *                                                                           *
1545 A448              *  This subroutine is called when FONT.LISTS doesn't pass the validity      *
1546 A448              *  test.  It goes out to the disk and constructs a list of all font file    *
1547 A448              *  names, so that a later subroutine (SetUpFontInfo) can open them all,     *
1548 A448              *  one at a time, and construct the other lists the Font Manager needs.     *
1549 A448              *                                                                           *
1550 A448              *  GetFontNames assumes the FONTS subdirectory has already been opened.     *
1551 A448              *  It returns with an RTS, and does not have a separate entry point; it's   *
1552 A448              *  just part of FMStartUp.                                                  *
1553 A448              *                                                                           *
1554 A448              *****************************************************************************
1555 A448              ;
1556 A448              ***************************************
1557 A448              *                                     *
1558 A448              *  11/10/87  3:10 pm                  *
1559 A448              *  BHM  x6245                         *
1560 A448              *                                     *
1561 A448              ***************************************
1562 A448              ;
1563 A448              ***************************************
1564 A448              *                                     *
1565 A448              *  Changed to use GetDirEntry         *
1566 A448              *  - BHM  9/15/87                     *
1567 A448              *                                     *
1568 A448              *  Now gets create & mod times &      *
1569 A448              *  dates (maybe we should rename it)  *
1570 A448              *  - BHM 9/24/87                      *
1571 A448              *                                     *
1572 A448              ***************************************
1573 A448              ;
1574 A448              GetFileNames                            ;
1575 A448              ;
1576 A448              ;use GetDirEntry to get the number of active files in FONTS
1577 A448              ;
1578 A448 A5 D2                 lda   <FONTSDirRef
1579 A44A 87 4C                 sta   [<FMParamPtr]            ;trust me
1580 A44C              ;
1581 A44C A9 00 00              lda   #0
1582 A44F A0 04 00              ldy   #(GDEBase-FMParams)
1583 A452 97 4C                 sta   [<FMParamPtr],y
1584 A454 C8                    iny   
1585 A455 C8                    iny   
1586 A456 97 4C                 sta   [<FMParamPtr],y
1587 A458              ;
1588 A458 20 3D BF              jsr   GetDirEntry
1589 A45B              ;
1590 A45B              ;quick like rabbit set GDE default params back, just in case
1591 A45B              ;
1592 A45B A9 01 00              lda   #1
1593 A45E A0 04 00              ldy   #(GDEBase-FMParams)
1594 A461 97 4C                 sta   [<FMParamPtr],y
1595 A463 C8                    iny   
1596 A464 C8                    iny   
1597 A465 97 4C                 sta   [<FMParamPtr],y
1598 A467              ;
1599 A467 90 08                 bcc   GotNumFiles
1600 A469 A9 00 00              lda   #0                       ; if an error occured, zero out the number of files
1601 A46C A0 0C 00              ldy   #(GDEEntry-FMParams)
1602 A46F 97 4C                 sta   [<FMParamPtr],y
1603 A471              ; and drop right thru to the rest of the routine now ...
1604 A471              ;
1605 A471              GotNumFiles                             ;
1606 A471 A0 0C 00              ldy   #(GDEEntry-FMParams)
1607 A474 B7 4C                 lda   [<FMParamPtr],y
1608 A476 85 A6                 sta   <NumFiles                ;number of active files in FONTS
1609 A478              ;
1610 A478 20 3C A3              jsr   SizeLists
1611 A47B 90 01                 bcc   GotLists
1612 A47D 60                    rts   
1613 A47E              ;
1614 A47E              GotLists                                ;
1615 A47E 20 E0 C0              jsr   LockFileList
1616 A481 20 AE A5              jsr   LockTimeList
1617 A484              ;this seems to be a good place to save TimePtr
1618 A484 A5 DE                 lda   <TimePtr
1619 A486 85 E2                 sta   <SavedTimePtr
1620 A488 A5 E0                 lda   <TimePtr+2
1621 A48A 85 E4                 sta   <SavedTimePtr+2
1622 A48C              ;
1623 A48C 64 A8                 stz   <NumFonts                ;# of font files (not ROM font)
1624 A48E              ;
1625 A48E              ;create "dummy" file entry for ROM font and
1626 A48E              ;application fonts to point to
1627 A48E              ;
1628 A48E A9 01 00              lda   #1
1629 A491 87 2C                 sta   [<filePtr]
1630 A493 A9 00 00              lda   #0
1631 A496 A0 02 00              ldy   #2
1632 A499 97 2C                 sta   [<filePtr],y
1633 A49B              ;
1634 A49B 20 7A C0              jsr   IncFilePtr
1635 A49E              ;
1636 A49E              ;create dummy entry in TimeList (just for consistency)
1637 A49E A0 0E 00              ldy   #14
1638 A4A1 A9 00 00              lda   #0
1639 A4A4              NextTimeWord  
1640 A4A4 97 DE                 sta   [<TimePtr],y
1641 A4A6 88                    dey   
1642 A4A7 88                    dey   
1643 A4A8 10 FA                 bpl   NextTimeWord
1644 A4AA              ;
1645 A4AA 20 CF A5              jsr   IncTimePtr
1646 A4AD
1647 A4AD              ;
1648 A4AD              *****  NOTE:  the following code is very similar to some code in
1649 A4AD              *****  CheckFLFile, and can probably be boiled down into a subroutine
1650 A4AD              *****  usable by both - BHM  9/15/87
1651 A4AD              ;
1652 A4AD              NextEntry                               ;
1653 A4AD 20 3D BF              jsr   GetDirEntry
1654 A4B0 90 0C                 bcc   GotEntry
1655 A4B2              ;some error:
1656 A4B2 C9 61 00              cmp   #EndOfDir
1657 A4B5 F0 50                 beq   NoMoreEntries            ;if you call that an error
1658 A4B7 C9 01 00              cmp   #1                       ; was it an invalid call number???
1659 A4BA F0 4B                 beq   NoMoreEntries            ; if so, just continue...
1660 A4BC 38                    sec                            ;for a real error . . .
1661 A4BD 60                    rts   
1662 A4BE              ;
1663 A4BE              GotEntry                                ;
1664 A4BE              ;the following flip is to account for the fact that GetDirEntry uses a length
1665 A4BE              ;word, while we need it to be a byte (we know the upper byte is 0, anyway)
1666 A4BE              ;
1667 A4BE A0 32 00              ldy   #(GDENameLen-FMParams)
1668 A4C1 B7 4C                 lda   [<FMParamPtr],y
1669 A4C3 29 FF 00              and   #$00FF
1670 A4C6 85 CA                 sta   <fNameLen                ;useful later
1671 A4C8 EB                    xba   
1672 A4C9 97 4C                 sta   [<FMParamPtr],y
1673 A4CB              ;now check out that file
1674 A4CB              ;
1675 A4CB A0 0E 00              ldy   #(GDEFileType-FMParams)
1676 A4CE B7 4C                 lda   [<FMParamPtr],y          ;file type
1677 A4D0 29 FF 00              and   #$00FF                   ;only low byte significant [?]
1678 A4D3 C9 C8 00              cmp   #FontType                ;same as font?
1679 A4D6 D0 D5                 bne   NextEntry                ;no
1680 A4D8              ;yes:
1681 A4D8 A0 2A 00              ldy   #(GDEAuxType-FMParams)
1682 A4DB B7 4C                 lda   [<FMParamPtr],y
1683 A4DD D0 CE                 bne   NextEntry                ;aux type must be 0
1684 A4DF C8                    iny   
1685 A4E0 C8                    iny   
1686 A4E1 B7 4C                 lda   [<FMParamPtr],y
1687 A4E3 D0 C8                 bne   NextEntry                ;all of it
1688 A4E5              ;it's a font file!
1689 A4E5              ;
1690 A4E5 E6 A8                 inc   <NumFonts
1691 A4E7              ;
1692 A4E7              ;copy name into file name list
1693 A4E7 A4 CA                 ldy   <fNameLen
1694 A4E9              CopyLoop                                ;
1695 A4E9 B7 C2                 lda   [<fNamePtr],y
1696 A4EB 97 2C                 sta   [<filePtr],y
1697 A4ED 88                    dey   
1698 A4EE F0 F9                 beq   CopyLoop
1699 A4F0 88                    dey   
1700 A4F1 10 F6                 bpl   CopyLoop
1701 A4F3              ;
1702 A4F3 20 7A C0              jsr   IncFilePtr
1703 A4F6              ;
1704 A4F6              ;move in the times & dates
1705 A4F6              ;
1706 A4F6 A0 0E 00              ldy   #14
1707 A4F9              NextTimeWord2                           ;
1708 A4F9 B7 E6                 lda   [<fTimePtr],y
1709 A4FB 97 DE                 sta   [<TimePtr],y
1710 A4FD 88                    dey   
1711 A4FE 88                    dey   
1712 A4FF 10 F8                 bpl   NextTimeWord2
1713 A501              ;
1714 A501 20 CF A5              jsr   IncTimePtr
1715 A504
1716 A504 82 A6 FF              brl   NextEntry
1717 A507              ;
1718 A507              NoMoreEntries                           ;
1719 A507              ;
1720 A507              ;and this is a good place to calculate the size of the time list
1721 A507 A5 DE                 lda   <TimePtr
1722 A509 38                    sec   
1723 A50A E5 E2                 sbc   <SavedTimePtr
1724 A50C 85 D8                 sta   <TimeListSize
1725 A50E              ;
1726 A50E 20 E6 C0              jsr   UnLockFileList           ;unlock filename list
1727 A511 20 C4 A5              jsr   UnlockTimeList           ;and time list
1728 A514              ;and now that it's unlocked, let's shrink the time list
1729 A514 F4 00 00              PushWord #0                    ;high word
1730 A517 A5 D8                 lda   <TimeListSize
1731 A519 48                    pha                            ;low
1732 A51A D4 DC D4 DA           PushZLong <TimeHandle 
1733 A51E A2 02 19 22           _SetHandleSize 
1734 A525              ;
1735 A525 18                    clc   
1736 A526 60                    rts   
1737 A527              ***************************************
1738 A527              *                                     *
1739 A527              *  end GetFileNames                   *
1740 A527              *                                     *
1741 A527              ***************************************
1742 A527              ;
1743 A527              *****************************************************************************
1744 A527              *                                                                           *
1745 A527              *  subroutine GetListHandles                                                *
1746 A527              *                                                                           *
1747 A527              *    started 8/27/87                                                        *
1748 A527              *    Bennet Marks  x6245                                                    *
1749 A527              *                                                                           *
1750 A527              *  This subroutine gets handles for NameList, FamList, IDList, and          *
1751 A527              *  FileList.  Each list is allocated a token amount of space (10 bytes).    *
1752 A527              *  If the subroutine is successful, it returns with carry clear; otherwise  *
1753 A527              *  it returns with carry set, the error code in the acc., and none of the   *
1754 A527              *  handles allocated.  Nice, huh?                                           *
1755 A527              *                                                                           *
1756 A527              *  GetListHandles returns with an RTS and does not have a separate entry    *
1757 A527              *  point; it's part of FMStartUp.                                           *
1758 A527              *                                                                           *
1759 A527              *****************************************************************************
1760 A527              ;
1761 A527              ***************************************
1762 A527              *                                     *
1763 A527              *  9/24/87  1:15 pm                   *
1764 A527              *  BHM  x6245                         *
1765 A527              *                                     *
1766 A527              ***************************************
1767 A527              ;
1768 A527              GetListHandles                          ;
1769 A527              ;
1770 A527 A9 0A 00              lda   #10                      ;a token amount
1771 A52A 20 49 BF              jsr   GetHandle
1772 A52D 90 01                 bcc   GotNameHandle
1773 A52F 60                    rts   
1774 A530              GotNameHandle                           ;
1775 A530 85 10                 sta   <NameHandle
1776 A532 86 12                 stx   <NameHandle+2
1777 A534              ;
1778 A534 A9 0A 00              lda   #10
1779 A537 20 49 BF              jsr   GetHandle
1780 A53A 90 04                 bcc   GotFamHandle
1781 A53C 85 CE                 sta   errCode
1782 A53E 80 57                 bra   HandError1
1783 A540              GotFamHandle                            ;
1784 A540 85 0C                 sta   <FamHandle
1785 A542 86 0E                 stx   <FamHandle+2
1786 A544              ;
1787 A544 A9 0A 00              lda   #10
1788 A547 20 49 BF              jsr   GetHandle
1789 A54A 90 04                 bcc   GotIDHandle
1790 A54C 85 CE                 sta   errCode
1791 A54E 80 3C                 bra   HandError2
1792 A550              GotIDHandle                             ;
1793 A550 85 08                 sta   <IDHandle
1794 A552 86 0A                 stx   <IDHandle+2
1795 A554              ;
1796 A554 A9 0A 00              lda   #10
1797 A557 20 49 BF              jsr   GetHandle
1798 A55A 90 04                 bcc   GotFileHandle
1799 A55C 85 CE                 sta   errCode
1800 A55E 80 21                 bra   HandError3
1801 A560              GotFileHandle                           ;
1802 A560 85 04                 sta   <FileHandle
1803 A562 86 06                 stx   <FileHandle+2
1804 A564              ;
1805 A564 A9 0A 00              lda   #10
1806 A567 20 49 BF              jsr   GetHandle
1807 A56A 90 04                 bcc   GotTimeHandle
1808 A56C 85 CE                 sta   errCode
1809 A56E 80 06                 bra   HandError4
1810 A570              GotTimeHandle                           ;
1811 A570 85 DA                 sta   <TimeHandle
1812 A572 86 DC                 stx   <TimeHandle+2
1813 A574              ;
1814 A574 18                    clc   
1815 A575 60                    rts   
1816 A576              ;
1817 A576              HandError4                              ;
1818 A576 D4 06 D4 04           PushZLong <FileHandle 
1819 A57A A2 02 10 22           _DisposeHandle 
1820 A581              HandError3                              ;
1821 A581 D4 0A D4 08           PushZLong <IDHandle 
1822 A585 A2 02 10 22           _DisposeHandle 
1823 A58C              HandError2                              ;
1824 A58C D4 0E D4 0C           PushZLong <FamHandle 
1825 A590 A2 02 10 22           _DisposeHandle 
1826 A597              HandError1                              ;
1827 A597 D4 12 D4 10           PushZLong <NameHandle 
1828 A59B A2 02 10 22           _DisposeHandle 
1829 A5A2              ;
1830 A5A2 A5 CE                 lda   errCode
1831 A5A4 38                    sec   
1832 A5A5 60                    rts   
1833 A5A6              ***************************************
1834 A5A6              *                                     *
1835 A5A6              *  end GetListHandles                 *
1836 A5A6              *                                     *
1837 A5A6              ***************************************
1838 A5A6              ;
1839 A5A6              ;
1840 A5A6              *****************************************************************************
1841 A5A6              *                                                                           *
1842 A5A6              *  subroutine CloseFONTSDir                                                 *
1843 A5A6              *                                                                           *
1844 A5A6              *    started 8/31/87                                                        *
1845 A5A6              *    Bennet Marks  x6245                                                    *
1846 A5A6              *                                                                           *
1847 A5A6              *  This subroutine closes the subdirectory *:SYSTEM:FONTS.  If it succeeds, *
1848 A5A6              *  it returns with carry clear; otherwise with carry set and the error code *
1849 A5A6              *  in the acc.                                                              *
1850 A5A6              *                                                                           *
1851 A5A6              *  Currently, CloseFONTSDir returns with an RTS, and does not have a        *
1852 A5A6              *  separate entry point; it's just part of FMStartUp.                       *
1853 A5A6              *                                                                           *
1854 A5A6              *****************************************************************************
1855 A5A6              ;
1856 A5A6              ***************************************
1857 A5A6              *                                     *
1858 A5A6              *  9/2/87  1:20 pm                    *
1859 A5A6              *  BHM  x6245                         *
1860 A5A6              *                                     *
1861 A5A6              ***************************************
1862 A5A6              ;
1863 A5A6              CloseFONTSDir                           ;
1864 A5A6              ;
1865 A5A6 A5 D2                 lda   <FONTSDirRef
1866 A5A8 85 6C                 sta   <CloseRef
1867 A5AA              ;
1868 A5AA 20 F5 BE              jsr   CloseFile
1869 A5AD 60                    rts   
1870 A5AE              ***************************************
1871 A5AE              *                                     *
1872 A5AE              *  end CloseFONTSDir                  *
1873 A5AE              *                                     *
1874 A5AE              ***************************************
1875 A5AE
1876 A5AE              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1877 A5AE              ;
1878 A5AE              ;and some other stuff (here instead of in STDSTUFF
1879 A5AE              ;because the time list is local to FMStartUp):
1880 A5AE              ;
1881 A5AE              LockTimeList                            ;
1882 A5AE              ;
1883 A5AE A0 04 00              ldy   #4
1884 A5B1 B7 DA                 lda   [<TimeHandle],y
1885 A5B3 09 00 80              ora   #$8000
1886 A5B6 97 DA                 sta   [<TimeHandle],y
1887 A5B8              ;
1888 A5B8 A7 DA                 lda   [<TimeHandle]
1889 A5BA 85 DE                 sta   <TimePtr
1890 A5BC A0 02 00              ldy   #2
1891 A5BF B7 DA                 lda   [<TimeHandle],y
1892 A5C1 85 E0                 sta   <TimePtr+2
1893 A5C3              ;
1894 A5C3 60                    rts   
1895 A5C4              ;
1896 A5C4              ****************
1897 A5C4              ;
1898 A5C4              UnlockTimeList                          ;
1899 A5C4              ;
1900 A5C4 A0 04 00              ldy   #4
1901 A5C7 B7 DA                 lda   [<TimeHandle],y
1902 A5C9 29 FF 7F              and   #$7FFF
1903 A5CC 97 DA                 sta   [<TimeHandle],y
1904 A5CE 60                    rts   
1905 A5CF              ;
1906 A5CF              ******************
1907 A5CF              ;
1908 A5CF              IncTimePtr                              ;
1909 A5CF              ;
1910 A5CF A5 DE                 lda   <TimePtr
1911 A5D1 18                    clc   
1912 A5D2 69 10 00              adc   #16
1913 A5D5 85 DE                 sta   <TimePtr
1914 A5D7 A5 E0                 lda   <TimePtr+2
1915 A5D9 69 00 00              adc   #0
1916 A5DC 85 E0                 sta   <TimePtr+2
1917 A5DE 60                    rts   
1918 A5DF
1919 A5DF
1920 A5DF              ;                COPY SpeedStuff
1921 A5DF              ;
1922 A5DF              *****************************************************************************
1923 A5DF              *                                                                           *
1924 A5DF              *  file SpeedStuff                                                          *
1925 A5DF              *                                                                           *
1926 A5DF              *    started 8/24/87                                                        *
1927 A5DF              *    Bennet Marks  x6245                                                    *
1928 A5DF              *                                                                           *
1929 A5DF              *  This file contains code which will be integrated into FMStartUp (and     *
1930 A5DF              *  possibly other Font Manager calls) to help speed up the Font Manager     *
1931 A5DF              *  start-up procedure.  Currently the Font Manager opens every font file    *
1932 A5DF              *  in the FONTS subdirectory in order to make lists of available fonts,     *
1933 A5DF              *  distinct family names, file names of font files, etc.  This is very      *
1934 A5DF              *  slow.  Our plan is to create a file, font.lists, that has all that       *
1935 A5DF              *  information in it, so that the Font Manager only has to open and read    *
1936 A5DF              *  in from that one file.  The only problem is validation - how do we know  *
1937 A5DF              *  the information in font.lists is still good some time after it was       *
1938 A5DF              *  created?  This way:  by remembering the create dates & times and the     *
1939 A5DF              *  last-mod dates & time for every file, we can run a check on every font   *
1940 A5DF              *  file in FONTS to see if font files with the same names (one as an actual *
1941 A5DF              *  file in FONTS, the other as a remembered name & dates & time in          *
1942 A5DF              *  font.lists) match.  You would have to go out of your way to break that   *
1943 A5DF              *  validation check.  Also, we will check to see if new font files have     *
1944 A5DF              *  shown up, or old ones disappear.  If font.lists is good, we will use the *
1945 A5DF              *  info in it.  Otherwise we will go through the long font-reading process, *
1946 A5DF              *  and update font.lists while we're at it.                                 *
1947 A5DF              *                                                                           *
1948 A5DF              *  In our first pass, we'll treat font.lists as either completely valid or  *
1949 A5DF              *  utterly useless.  Later revisions will attempt to integrate new info     *
1950 A5DF              *  and discard outdated info, but still make efficient use of the parts of  *
1951 A5DF              *  font.lists that appear to be good.  (In our VERY first pass, we may even *
1952 A5DF              *  skip the dates & times business, and validate simply on file names; but  *
1953 A5DF              *  that's just for demo purposes.)                                          *
1954 A5DF              *                                                                           *
1955 A5DF              *  Other goals:  making the code ROMable.  Using GetDirEntry instead of     *
1956 A5DF              *  reading directory blocks directly.                                       *
1957 A5DF              *                                                                           *
1958 A5DF              *****************************************************************************
1959 A5DF              ;
1960 A5DF              *****************************************************************************
1961 A5DF              *                                                                           *
1962 A5DF              *  subroutine FindFileName                                                  *
1963 A5DF              *                                                                           *
1964 A5DF              *    started 8/24/87                                                        *
1965 A5DF              *    Bennet Marks  x6245                                                    *
1966 A5DF              *                                                                           *
1967 A5DF              *  This subroutine attempts to find a name pointed to by FNamePtr in the    *
1968 A5DF              *  list of names pointed to CurrFNamePtr.  If it finds the name, it returns *
1969 A5DF              *  with the carry clear, CurrFNamePtr pointing to the matching name in the  *
1970 A5DF              *  list, and the "position number" (0-based) of the matching name in the    *
1971 A5DF              *  acc.  - 0 if it was the first name, 1 if the second, etc.  If the name   *
1972 A5DF              *  isn't found, FindFileName returns with the carry set; CurrFNamePtr and   *
1973 A5DF              *  acc. are undefined.                                                      *
1974 A5DF              *                                                                           *
1975 A5DF              *  FindFileName also uses numFonts, the number of file names in the list,   *
1976 A5DF              *  but doesn't change it.  (NOTE:  numFonts is a 1-based counter.)          *
1977 A5DF              *                                                                           *
1978 A5DF              *  All the names are Pascal-type strings (length byte followed by ASCII     *
1979 A5DF              *  character codes, 1 per byte).                                            *
1980 A5DF              *                                                                           *
1981 A5DF              *  For now at least, FindFileName returns with an RTS and is not a separate *
1982 A5DF              *  entry point; it's just part of FMStartUp.                                *
1983 A5DF              *                                                                           *
1984 A5DF              *****************************************************************************
1985 A5DF              ;
1986 A5DF              **************************************
1987 A5DF              *                                     *
1988 A5DF              *  9/24/87  2:55 pm                   *
1989 A5DF              *  BHM  x6245                         *
1990 A5DF              *                                     *
1991 A5DF              ***************************************
1992 A5DF              ;
1993 A5DF              FindFileName  
1994 A5DF              ;
1995 A5DF A5 A8                 lda   <numFonts
1996 A5E1 85 AA                 sta   <fileCount               ;count down
1997 A5E3              ;
1998 A5E3 A7 C2                 lda   [<fNamePtr]              ;length byte
1999 A5E5 29 FF 00              and   #$00FF                   ;and I do mean byte
2000 A5E8 85 CA                 sta   <FNameLen
2001 A5EA              ;
2002 A5EA              NextFileName                            ;
2003 A5EA A7 C6                 lda   [<currFNamePtr]          ;length byte
2004 A5EC 29 FF 00              and   #$00FF
2005 A5EF 85 CC                 sta   <currFNameLen
2006 A5F1              ;
2007 A5F1 C5 CA                 cmp   <fNameLen
2008 A5F3 D0 10                 bne   TryNextName              ;because the lengths don't match
2009 A5F5              ;lengths match - now we compare the names.
2010 A5F5              ;we'll go 2 bytes at a time, starting from the last 2 characters:
2011 A5F5 3A                    dec   a
2012 A5F6 A8                    tay   
2013 A5F7              ;
2014 A5F7              NextChars                               ;
2015 A5F7 B7 C2                 lda   [<FNamePtr],y
2016 A5F9 D7 C6                 cmp   [<currFNamePtr],y
2017 A5FB D0 08                 bne   TryNextName              ;mismatched characters
2018 A5FD              ;
2019 A5FD 88                    dey   
2020 A5FE 30 17                 bmi   NamesMatch               ;(and length was odd - and we
2021 A600              ;                                       ;rechecked the length byte)
2022 A600 F0 15                 beq   NamesMatch               ;(and length was even)
2023 A602              ;
2024 A602 88                    dey   
2025 A603 80 F2                 bra   NextChars
2026 A605              ;
2027 A605              TryNextName                             ;
2028 A605 C6 AA                 dec   <fileCount
2029 A607 F0 15                 beq   NoSuchName               ;no more to try
2030 A609              ;
2031 A609              ;advance currFNamePtr:
2032 A609 A5 CC                 lda   <currFNameLen
2033 A60B 1A                    inc   a
2034 A60C 18                    clc   
2035 A60D 65 C6                 adc   <currFNamePtr
2036 A60F 85 C6                 sta   <currFNamePtr
2037 A611 90 02                 bcc   NoCarry
2038 A613 E6 C8                 inc   <currFNamePtr+2
2039 A615              NoCarry                                 ;
2040 A615 80 D3                 bra   NextFileName
2041 A617              ;
2042 A617              NamesMatch                              ;
2043 A617 A5 A8                 lda   <numFonts
2044 A619 38                    sec   
2045 A61A E5 AA                 sbc   <fileCount               ;to get position in name list
2046 A61C 18                    clc   
2047 A61D 60                    rts   
2048 A61E              ;
2049 A61E              NoSuchName                              ;
2050 A61E 38                    sec   
2051 A61F 60                    rts   
2052 A620              ***************************************
2053 A620              *                                     *
2054 A620              *  end FindFileName                   *
2055 A620              *                                     *
2056 A620              ***************************************
2057 A620              ;
2058 A620              ******************************************************************************
2059 A620              *                                                                            *
2060 A620              *  subroutine CheckFLFile                                                    *
2061 A620              *                                                                            *
2062 A620              *    started 8/24/87                                                         *
2063 A620              *    Bennet Marks  x6245                                                     *
2064 A620              *                                                                            *
2065 A620              *  This subroutine checks the "validation" information in FONT.LISTS - file  *
2066 A620              *  names, create times & dates, and last-mod times & dates - against the     *
2067 A620              *  corresponding info from the FONTS subdirectory header.  We assume that    *
2068 A620              *  both the subdirectory and FONT.LISTS have been opened, with the marks     *
2069 A620              *  set at their beginnings.  If FONT.LISTS passes the validity test, then    *
2070 A620              *  CheckFLFile returns with carry clear, and leaves font.lists with the mark *
2071 A620              *  pointing to the first byte of the recorded ID list.                       *
2072 A620              *                                                                            *
2073 A620              *  If FONT.LISTS fails the validity test, CheckFLFile returns with the carry *
2074 A620              *  set; it is then the responsibility of the rest of FMStartUp to construct  *
2075 A620              *  these lists the old-fashioned (i.e., "slow") way, and update FONT.LISTS   *
2076 A620              *  accordingly.  In this case FONT.LISTS and FONTS will still be open; FONTS *
2077 A620              *  will have its mark set to the beginning, and FONT.LISTS will be empty     *
2078 A620              *  (EOF set to the begining).  Also, the acc. will be 0.  Other errors will  *
2079 A620              *  signaled by a carry set and acc. not 0.                                   *
2080 A620              *                                                                            *
2081 A620              *  In future versions we will probably get away from this "all-or-nothing"   *
2082 A620              *  view of FONT.LISTS, and try to use all valid info found in FONT.LISTS,    *
2083 A620              *  getting the rest from the font files themselves.  This will integrate     *
2084 A620              *  the validating of FONT.LISTS and the construction of the Font Manager's   *
2085 A620              *  lists.  But not now.  Stop nagging.                                       *
2086 A620              *                                                                            *
2087 A620              *  In our earliest passes, we may ignore create & last-mod times & dates,    *
2088 A620              *  and just check over names - just for demo purposes.                       *
2089 A620              *                                                                            *
2090 A620              *  CheckFLFile returns with an RTS and does not have its own entry point.    *
2091 A620              *  For now it's just part of FMStartUp.                                      *
2092 A620              *                                                                            *
2093 A620              ******************************************************************************
2094 A620              ;
2095 A620              ***************************************
2096 A620              *                                     *
2097 A620              *  11/10/87  3:35 pm                  *
2098 A620              *  BHM  x6245                         *
2099 A620              *                                     *
2100 A620              ***************************************
2101 A620              ;
2102 A620              CheckFLFile  
2103 A620 A5 D0                 lda   <FLFileRef
2104 A622 85 6C                 sta   <ReadRef
2105 A624 A9 18 00              lda   #FLFileHeadLen           ;for header info in font.lists
2106 A627 85 72                 sta   <ReadSize
2107 A629 A9 00 00              lda   #0
2108 A62C 85 74                 sta   <ReadSize+2
2109 A62E A5 40                 lda   <BlockPtr
2110 A630 85 6E                 sta   <ReadPtr
2111 A632 A5 42                 lda   <BlockPtr+2
2112 A634 85 70                 sta   <ReadPtr+2
2113 A636              ;(actually, you don't have to do all that, at least not every time -
2114 A636              ;but I'm just getting used to this stuff - BHM  9/4/87)
2115 A636
2116 A636              ;
2117 A636 20 D1 BE              jsr   ReadFile
2118 A639 90 01                 bcc   ReadIt
2119 A63B 60                    rts   
2120 A63C              ReadIt    
2121 A63C              ;
2122 A63C              ;check the FONT.LISTS format version number:
2123 A63C A7 40                 lda   [<BlockPtr]
2124 A63E C9 01 00              cmp   #FLVerLo
2125 A641 F0 03                 beq   GoodSoFar
2126 A643 82 79 01              brl   BadFLFile
2127 A646              GoodSoFar  
2128 A646 A0 02 00              ldy   #2
2129 A649 B7 40                 lda   [<BlockPtr],y
2130 A64B C9 00 00              cmp   #FLVerHi
2131 A64E F0 03                 beq   VersionGood
2132 A650 82 6C 01              brl   BadFLFile
2133 A653              VersionGood  
2134 A653              ;
2135 A653              ;compare ROM info to FONT.LISTS' version:
2136 A653 F4 00 00 7B           PushZPtr <RomInfoRec 
2137 A65C A2 04 D8 22           _GetRomFont 
2138 A663              ;
2139 A663 A5 B2                 lda   <RomFamNum
2140 A665 A0 04 00              ldy   #oRomFamNum
2141 A668 D7 40                 cmp   [<BlockPtr],y
2142 A66A F0 03                 beq   RomFamNumOK
2143 A66C 82 50 01              brl   BadFLFile
2144 A66F              ;
2145 A66F              RomFamNumOK  
2146 A66F              ;
2147 A66F A5 B4                 lda   <RomStyle
2148 A671 A0 06 00              ldy   #oRomStyle
2149 A674 D7 40                 cmp   [<BlockPtr],y
2150 A676 F0 03                 beq   RomStyleOK
2151 A678 82 44 01              brl   BadFLFile
2152 A67B              ;
2153 A67B              RomStyleOK  
2154 A67B              ;
2155 A67B A5 B6                 lda   <RomSize
2156 A67D A0 08 00              ldy   #oRomSize
2157 A680 D7 40                 cmp   [<BlockPtr],y
2158 A682 F0 03                 beq   RomSizeOK
2159 A684 82 38 01              brl   BadFLFile
2160 A687              ;
2161 A687              RomSizeOK  
2162 A687              ;
2163 A687              ;(that can actually be done with a loop, if things are kept in the right
2164 A687              ;order)
2165 A687              ;
2166 A687              ;
2167 A687              ****  added 10/27/87  (I had forgotten to set SysFontID):
2168 A687              ;
2169 A687 A5 B2                 lda   <RomFamNum
2170 A689 85 86                 sta   <SysFontID
2171 A68B A5 B6                 lda   <RomSize
2172 A68D EB                    xba   
2173 A68E 05 B4                 ora   <RomStyle
2174 A690 85 88                 sta   <SysFontID+2
2175 A692              ;
2176 A692              ****  end of addition 10/27/87 - BHM x6245
2177 A692              ;transfer values from FONT.LISTS to FM 0-page:
2178 A692              ;
2179 A692 A0 0A 00              ldy   #oIDCount
2180 A695 B7 40                 lda   [<BlockPtr],y
2181 A697 85 68                 sta   <IDCount
2182 A699 3A                    dec   a                        ;for ROM font
2183 A69A 85 A8                 sta   <numFonts
2184 A69C              ;
2185 A69C A0 0C 00              ldy   #oFamCount
2186 A69F B7 40                 lda   [<BlockPtr],y
2187 A6A1 85 6A                 sta   <FamCount
2188 A6A3              ;
2189 A6A3 A0 0E 00              ldy   #oIDListSize
2190 A6A6 B7 40                 lda   [<BlockPtr],y
2191 A6A8 85 60                 sta   <IDListSize
2192 A6AA              ;
2193 A6AA A0 10 00              ldy   #oFamListSize
2194 A6AD B7 40                 lda   [<BlockPtr],y
2195 A6AF 85 62                 sta   <FamListSize
2196 A6B1              ;
2197 A6B1 A0 12 00              ldy   #oNameListSize
2198 A6B4 B7 40                 lda   [<BlockPtr],y
2199 A6B6 85 64                 sta   <NameListSize
2200 A6B8              ;
2201 A6B8 A0 14 00              ldy   #oFileListSize
2202 A6BB B7 40                 lda   [<BlockPtr],y
2203 A6BD 85 D4                 sta   <FileListSize
2204 A6BF              ;
2205 A6BF A0 16 00              ldy   #oTimeListSize
2206 A6C2 B7 40                 lda   [<BlockPtr],y
2207 A6C4 85 D8                 sta   <TimeListSize
2208 A6C6              ;
2209 A6C6              ;
2210 A6C6              ;get space for file list and read it in
2211 A6C6              ;
2212 A6C6 F4 00 00              PushWord #0                    ;high word of size
2213 A6C9 A5 D4                 lda   <FileListSize            ;low word of size
2214 A6CB 85 72                 sta   <ReadSize
2215 A6CD 48                    pha   
2216 A6CE D4 06 D4 04           PushZLong <fileHandle 
2217 A6D2 A2 02 19 22           _SetHandleSize 
2218 A6D9 90 01                 bcc   NoSizeErr1
2219 A6DB 60                    rts   
2220 A6DC              NoSizeErr1  
2221 A6DC              ;
2222 A6DC 20 E0 C0              jsr   LockFileList
2223 A6DF A5 2C                 lda   <FilePtr
2224 A6E1 85 6E                 sta   <ReadPtr
2225 A6E3 A5 2E                 lda   <FilePtr+2
2226 A6E5 85 70                 sta   <ReadPtr+2
2227 A6E7 A5 D0                 lda   <FLFileRef
2228 A6E9 85 6C                 sta   <ReadRef
2229 A6EB A9 00 00              lda   #0
2230 A6EE 85 74                 sta   <ReadSize+2
2231 A6F0              ;(actually, you don't have to do all that, at least not every time -
2232 A6F0              ;but I'm just getting used to this stuff - BHM  9/4/87)
2233 A6F0              ;
2234 A6F0 20 D1 BE              jsr   ReadFile
2235 A6F3 90 09                 bcc   NoReadErr1
2236 A6F5 85 CE                 sta   <errCode
2237 A6F7 20 E6 C0              jsr   UnlockFileList
2238 A6FA A5 CE                 lda   <errCode
2239 A6FC 38                    sec   
2240 A6FD 60                    rts   
2241 A6FE              NoReadErr1  
2242 A6FE              ;
2243 A6FE              ;get space for time list and read it in
2244 A6FE              ;
2245 A6FE F4 00 00              PushWord #0                    ;high word of size
2246 A701 A5 D8                 lda   <TimeListSize            ;low word of size
2247 A703 85 72                 sta   <ReadSize
2248 A705 48                    pha   
2249 A706 D4 DC D4 DA           PushZLong <TimeHandle 
2250 A70A A2 02 19 22           _SetHandleSize 
2251 A711 90 01                 bcc   NoSizeErr2
2252 A713 60                    rts   
2253 A714              NoSizeErr2  
2254 A714              ;
2255 A714 20 AE A5              jsr   LockTimeList
2256 A717 A5 DE                 lda   <TimePtr
2257 A719 85 6E                 sta   <ReadPtr
2258 A71B A5 E0                 lda   <TimePtr+2
2259 A71D 85 70                 sta   <ReadPtr+2
2260 A71F A5 D0                 lda   <FLFileRef
2261 A721 85 6C                 sta   <ReadRef
2262 A723 A9 00 00              lda   #0
2263 A726 85 74                 sta   <ReadSize+2
2264 A728              ;(actually, you don't have to do all that, at least not every time -
2265 A728              ;but I'm just getting used to this stuff - BHM  9/4/87)
2266 A728              ;
2267 A728 20 D1 BE              jsr   ReadFile
2268 A72B 90 0C                 bcc   NoReadErr2
2269 A72D 85 CE                 sta   <errCode
2270 A72F 20 E6 C0              jsr   UnlockFileList
2271 A732 20 C4 A5              jsr   UnlockTimeList
2272 A735 A5 CE                 lda   <errCode
2273 A737 38                    sec   
2274 A738 60                    rts   
2275 A739              NoReadErr2                              ;
2276 A739              ;
2277 A739              ;now start checking for validity:
2278 A739              ;
2279 A739 64 D6                 stz   <numFontFiles
2280 A73B A5 D2                 lda   <FONTSDirRef
2281 A73D A0 00 00              ldy   #(GDERef-FMParams)
2282 A740 97 4C                 sta   [<FMParamPtr],y
2283 A742              ;
2284 A742              NextFilea                               ;
2285 A742              ;
2286 A742 20 3D BF              jsr   GetDirEntry
2287 A745 90 07                 bcc   NoError
2288 A747              ;some error code:
2289 A747 C9 61 00              cmp   #EndOfDir
2290 A74A F0 65                 beq   NoMoreFiles
2291 A74C 38                    sec                            ;corrected from "clc" - BHM 9/15/87
2292 A74D 60                    rts   
2293 A74E              NoError                                 ;
2294 A74E              ;
2295 A74E              *****  The following semi-kludge is included because GetDirEntry returns
2296 A74E              *****  the file name with a length word, rather than a length byte.  Since
2297 A74E              *****  we know it's <= 16, we can just flip it.
2298 A74E              ;
2299 A74E A0 32 00              ldy   #(GDENameLen-FMParams)
2300 A751 B7 4C                 lda   [<FMParamPtr],y
2301 A753 EB                    xba   
2302 A754 97 4C                 sta   [<FMParamPtr],y
2303 A756              ;
2304 A756              *****  Now it's a length byte - BHM  9/9/87
2305 A756              ;
2306 A756              ;is it a font file?
2307 A756 A0 0E 00              ldy   #(GDEFileType-FMParams)
2308 A759 B7 4C                 lda   [<FMParamPtr],y
2309 A75B 29 FF 00              and   #$00FF                   ;only low byte meaningful
2310 A75E C9 C8 00              cmp   #FontType
2311 A761 D0 DF                 bne   NextFilea                ;wrong type
2312 A763              ;
2313 A763 A0 2A 00              ldy   #(GDEAuxType-FMParams)
2314 A766 B7 4C                 lda   [<FMParamPtr],y
2315 A768 D0 D8                 bne   NextFilea                ;AuxType must be 0
2316 A76A C8                    iny   
2317 A76B C8                    iny   
2318 A76C B7 4C                 lda   [<FMParamPtr],y
2319 A76E D0 D2                 bne   NextFilea                ;all of it
2320 A770              ;
2321 A770              ;congratulations, it's a font file!
2322 A770 A5 D6                 lda   <numFontFiles            ;seen before now
2323 A772 C5 A8                 cmp   <numFonts                ;from FONT.LISTS
2324 A774 F0 49                 beq   BadFLFile                ;too many files
2325 A776              ;
2326 A776 E6 D6                 inc   <numFontFiles
2327 A778              ;now try to find this file name
2328 A778              ;(assume FNamePtr has been set up)
2329 A778              ;
2330 A778 A5 2C                 lda   <FilePtr
2331 A77A 18                    clc   
2332 A77B 69 02 00              adc   #2                       ;skip dummy entry
2333 A77E 85 C6                 sta   <currFNamePtr
2334 A780 A5 2E                 lda   <FilePtr+2
2335 A782 90 01                 bcc   NoCarrya
2336 A784 1A                    inc   a
2337 A785              NoCarrya                                ;
2338 A785 85 C8                 sta   <currFNamePtr+2
2339 A787              ;
2340 A787 20 DF A5              jsr   FindFileName
2341 A78A 90 02                 bcc   FoundIt
2342 A78C 80 31                 bra   BadFLFile                ;couldn't find the name
2343 A78E              FoundIt                                 ;
2344 A78E              ;
2345 A78E              ;check on dates & times would (will) go here
2346 A78E              ;and here it is:
2347 A78E              ;position of file name in list of files is in acc. - now
2348 A78E              ;we want to check out the corresponding time list entry
2349 A78E 1A                    inc   a                        ;to skip over ROM font "entry"
2350 A78F 0A                    asl   a                        ;times 2
2351 A790 0A                    asl   a                        ;4
2352 A791 0A                    asl   a                        ;8
2353 A792 0A                    asl   a                        ;16
2354 A793              ;
2355 A793 18                    clc   
2356 A794 65 DE                 adc   <TimePtr
2357 A796 85 28                 sta   <tempPtr
2358 A798 A5 E0                 lda   <TimePtr+2
2359 A79A 69 00 00              adc   #0
2360 A79D 85 2A                 sta   <tempPtr+2
2361 A79F              ;
2362 A79F A0 0E 00              ldy   #14
2363 A7A2              NextTimeWord3                           ;
2364 A7A2 B7 E6                 lda   [<fTimePtr],y            ;from GDE call
2365 A7A4 D7 28                 cmp   [<tempPtr],y             ;from time list
2366 A7A6 F0 03                 beq   WordMatches
2367 A7A8 82 14 00              brl   BadFLFile                ;no it doesn't
2368 A7AB              ;
2369 A7AB              WordMatches                             ;
2370 A7AB 88                    dey   
2371 A7AC 88                    dey   
2372 A7AD 10 F3                 bpl   NextTimeWord3
2373 A7AF              ;
2374 A7AF              ;all the times & dates matched
2375 A7AF              ;
2376 A7AF 80 91                 bra   NextFilea
2377 A7B1              ;
2378 A7B1              NoMoreFiles                             ;
2379 A7B1              ;
2380 A7B1 A5 D6                 lda   <numFontFiles
2381 A7B3 C5 A8                 cmp   <numFonts
2382 A7B5 D0 08                 bne   BadFLFile
2383 A7B7              ;
2384 A7B7              ;FONT.LISTS has passed the validity test
2385 A7B7              ;hurrah, hurrah!!!
2386 A7B7              ;
2387 A7B7 20 E6 C0              jsr   UnlockFileList
2388 A7BA 20 C4 A5              jsr   UnlockTimeList
2389 A7BD 18                    clc   
2390 A7BE 60                    rts   
2391 A7BF              ;
2392 A7BF              BadFLFile                               ;
2393 A7BF
2394 A7BF              ;
2395 A7BF 20 E6 C0              jsr   UnlockFileList
2396 A7C2 20 C4 A5              jsr   UnlockTimeList
2397 A7C5              ;(they may or may not be locked, but so what?)
2398 A7C5              ;set FONTS back to its just-opened state, and empty FONT.LISTS:
2399 A7C5              ;
2400 A7C5              **** changed to use 0-page parameter block - BHM  x6245  11/4/87:
2401 A7C5              ;
2402 A7C5 A5 D2                 lda   <FONTSDirRef
2403 A7C7 85 6C                 sta   <MarkRef
2404 A7C9              ;
2405 A7C9 64 70                 stz   <MarkLoc+2
2406 A7CB 64 6E                 stz   <MarkLoc
2407 A7CD              ;
2408 A7CD 20 07 BF              jsr   SetMark
2409 A7D0              ;
2410 A7D0 A5 D0                 lda   <FLFileRef
2411 A7D2 85 6C                 sta   <MarkRef
2412 A7D4              ;0 position still set
2413 A7D4              ;
2414 A7D4 20 07 BF              jsr   SetMark
2415 A7D7              ;
2416 A7D7 A5 D0                 lda   <FLFileRef
2417 A7D9 85 6C                 sta   <EOFRef
2418 A7DB              ;
2419 A7DB              ;0 position still set
2420 A7DB              ;
2421 A7DB 20 2B BF              jsr   SetEOF
2422 A7DE              ;
2423 A7DE A9 00 00              lda   #0
2424 A7E1 38                    sec   
2425 A7E2 60                    rts   
2426 A7E3              ***************************************
2427 A7E3              *                                     *
2428 A7E3              *  end CheckFLFile                    *
2429 A7E3              *                                     *
2430 A7E3              ***************************************
2431 A7E3              ;
2432 A7E3              *****************************************************************************
2433 A7E3              *                                                                           *
2434 A7E3              *  subroutine SetUpFMParams                                                 *
2435 A7E3              *                                                                           *
2436 A7E3              *    started 8/26/87                                                        *
2437 A7E3              *    Bennet Marks  x6245                                                    *
2438 A7E3              *                                                                           *
2439 A7E3              *  This subroutine obtains a block of RAM that the Font Manager can use     *
2440 A7E3              *  for parameters that it needs to alter, or may need to alter, such as     *
2441 A7E3              *  font file names (for the Open call, for example) and window parameters   *
2442 A7E3              *  (which are different in 320 and 640 mode).                               *
2443 A7E3              *                                                                           *
2444 A7E3              *  When the Font Manager lived in RAM, this information/storage was kept    *
2445 A7E3              *  in-line.  We still have the defaults in-line, but SetUpFMParams copies   *
2446 A7E3              *  them over into the RAM space it obtains.                                 *
2447 A7E3              *                                                                           *
2448 A7E3              *  SetUpFMParams has changed so much since its earlier incarnation (when    *
2449 A7E3              *  it was mainly used to get ProDOS parameter block space, which is now     *
2450 A7E3              *  mainly on 0-page) that we have changed its name from SetUpParams.  Does  *
2451 A7E3              *  this make it a born-again subroutine?                                    *
2452 A7E3              *                                                                           *
2453 A7E3              *  If the subroutine succeeds in allocating the space for the parameter     *
2454 A7E3              *  blocks, it returns with the carry clear.  Otherwise it returns with the  *
2455 A7E3              *  carry set (and the MM error code in the acc.).                           *
2456 A7E3              *                                                                           *
2457 A7E3              *  As currently written, SetUpParams returns with an RTS and does not have  *
2458 A7E3              *  a separate entry point.  It's just part of FMStartUp.                    *
2459 A7E3              *                                                                           *
2460 A7E3              *****************************************************************************
2461 A7E3              ;
2462 A7E3              ***************************************
2463 A7E3              *                                     *
2464 A7E3              *  11/10/87 3:50 pm                   *
2465 A7E3              *  BHM  x6245                         *
2466 A7E3              *                                     *
2467 A7E3              ***************************************
2468 A7E3              ;
2469 A7E3              ***********************************************************
2470 A7E3              *                                                         *
2471 A7E3              *  major re-write, subroutine renamed -                   *
2472 A7E3              *    BHM  x6245  11/10/87                                 *
2473 A7E3              *                                                         *
2474 A7E3              ***********************************************************
2475 A7E3              ;
2476 A7E3              SetUpFMParams                           ;
2477 A7E3              ;
2478 A7E3 A9 68 01              lda   #(EndOfFMParams-FMParams)
2479 A7E6 20 49 BF              jsr   GetHandle
2480 A7E9 90 01                 bcc   GotFMParamMem
2481 A7EB 60                    rts   
2482 A7EC              ;
2483 A7EC              GotFMParamMem                           ;
2484 A7EC 85 24                 sta   <FMParamHandle
2485 A7EE 86 26                 stx   <FMParamHandle+2
2486 A7F0              ;
2487 A7F0 20 45 C1              jsr   LockFMParams
2488 A7F3              ;
2489 A7F3              ;transfer default values (and a lot of needless zeros):
2490 A7F3              ;
2491 A7F3 A9 92 9E              lda   #FMParams
2492 A7F6 85 28                 sta   <tempPtr
2493 A7F8 A9 FC 00              lda   #^FMParams
2494 A7FB 85 2A                 sta   <tempPtr+2
2495 A7FD
2496 A7FD              *** the following doesn't work if EndOfFMParams-FMParms is odd!
2497 A7FD A0 66 01              ldy   #(EndOfFMParams-FMParams-2)
2498 A800              NextParamWord                           ;
2499 A800 B7 28                 lda   [<tempPtr],y
2500 A802 97 4C                 sta   [<FMParamPtr],y
2501 A804 88                    dey   
2502 A805 30 03                 bmi   ParamsMoved
2503 A807 88                    dey   
2504 A808 80 F6                 bra   NextParamWord
2505 A80A
2506 A80A              ParamsMoved                             ;
2507 A80A              ;set up a few needed pointers:
2508 A80A              ;GDE name buffer:
2509 A80A A5 4C                 lda   <FMParamPtr
2510 A80C 18                    clc   
2511 A80D 69 30 00              adc   #(GDENameBuf-FMParams)
2512 A810 85 28                 sta   <tempPtr
2513 A812 A0 08 00              ldy   #(GDENameBufPtr-FMParams)
2514 A815 97 4C                 sta   [<FMParamPtr],y
2515 A817 A5 4E                 lda   <FMParamPtr+2
2516 A819 90 01                 bcc   NoCarryb
2517 A81B 1A                    inc   a
2518 A81C 85 2A        NoCarryb sta   <tempPtr+2
2519 A81E C8                    iny   
2520 A81F C8                    iny   
2521 A820 97 4C                 sta   [<FMParamPtr],y
2522 A822              ;
2523 A822              ;we need easy access to the GDE file name string
2524 A822 A5 28                 lda   <tempPtr
2525 A824 18                    clc   
2526 A825 69 03 00              adc   #3
2527 A828              ;(that's a 3 to access the length byte we swap into place from
2528 A828              ;the length word provided by GetDirEntry)
2529 A828 85 C2                 sta   <fNamePtr
2530 A82A A5 2A                 lda   <tempPtr+2
2531 A82C 90 01                 bcc   NoCarryc
2532 A82E 1A                    inc   a
2533 A82F 85 C4        NoCarryc sta   <fNamePtr+2
2534 A831              ;
2535 A831              ;we also need a pointer to the times & dates within the GetDirEntry block:
2536 A831 A5 4C                 lda   <FMParamPtr
2537 A833 18                    clc   
2538 A834 69 18 00              adc   #(GDECreateTime-FMParams)
2539 A837 85 E6                 sta   <fTimePtr
2540 A839 A5 4E                 lda   <FMParamPtr+2
2541 A83B 90 01                 bcc   NoCarryd
2542 A83D 1A                    inc   a
2543 A83E 85 E8        NoCarryd sta   <fTimePtr+2
2544 A840              ;
2545 A840 60                    rts   
2546 A841              ***************************************
2547 A841              *                                     *
2548 A841              *  end of SetUpParams                 *
2549 A841              *                                     *
2550 A841              ***************************************
2551 A841
2552 A841
2553 A841              *****************************************************************************
2554 A841              *                                                                           *
2555 A841              *  subroutine OpenFLFile                                                    *
2556 A841              *                                                                           *
2557 A841              *    started 8/28/87                                                        *
2558 A841              *    Bennet Marks  x6245                                                    *
2559 A841              *                                                                           *
2560 A841              *  This subroutine finds and opens font.lists, if it can.  It has 3 poss-   *
2561 A841              *  ible outcomes:  (1)  carry clear:  font.lists found and opened.          *
2562 A841              *  (2)  carry set, acc. 0:  font.lists not found, so OpenFLFile created     *
2563 A841              *  and then opened it.  (3)  carry set, acc. not 0:  some other error       *
2564 A841              *  occurred during the attempted to open it.                                *
2565 A841              *                                                                           *
2566 A841              *  OpenFLFile returns with an RTS, and does not have a separate entry       *
2567 A841              *  point; it's a part of FMStartUp.                                         *
2568 A841              *                                                                           *
2569 A841              *****************************************************************************
2570 A841              ;
2571 A841              ***************************************
2572 A841              *                                     *
2573 A841              *  11/12/87  1:50 pm                  *
2574 A841              *  BHM  x6245                         *
2575 A841              *                                     *
2576 A841              ***************************************
2577 A841              ;
2578 A841              OpenFLFile  
2579 A841              ;
2580 A841              ****  changed to use FMParams block - BHM  x6245  11/12/87
2581 A841              ;
2582 A841 A5 4C                 lda   <FMParamPtr
2583 A843 18                    clc   
2584 A844 69 63 00              adc   #(FLFileName-FMParams)
2585 A847 85 2C                 sta   <FilePtr
2586 A849 A5 4E                 lda   <FMParamPtr+2
2587 A84B 69 00 00              adc   #0
2588 A84E 85 2E                 sta   <FilePtr+2
2589 A850
2590 A850              ;
2591 A850 20 D9 BF              jsr   CopyFileName
2592 A853              ;
2593 A853 A5 4C                 lda   <FMParamPtr
2594 A855 18                    clc   
2595 A856 69 44 00              adc   #(DirName-FMParams)
2596 A859 85 6E                 sta   <OpenPtr
2597 A85B A5 4E                 lda   <FMParamPtr+2
2598 A85D 69 00 00              adc   #0
2599 A860 85 70                 sta   <OpenPtr+2
2600 A862              ;
2601 A862 20 BF BE              jsr   OpenFile
2602 A865 90 07                 bcc   GotFLFilea
2603 A867              ;some error:
2604 A867 C9 46 00              cmp   #FileNotFound
2605 A86A F0 08                 beq   CreateFLFile
2606 A86C              ;real error:
2607 A86C 38                    sec   
2608 A86D 60                    rts   
2609 A86E              ;
2610 A86E              GotFLFilea  
2611 A86E A5 6C                 lda   <OpenRef
2612 A870 85 D0                 sta   <FLFileRef
2613 A872 18                    clc   
2614 A873 60                    rts   
2615 A874              ;
2616 A874 A5 4C        CreateFLFile lda   <FMParamPtr
2617 A876 18                    clc   
2618 A877 69 44 00              adc   #(DirName-FMParams)
2619 A87A              ;(still set to FONT.LISTS)
2620 A87A 85 6C                 sta   <CRNamePtr
2621 A87C A5 4E                 lda   <FMParamPtr+2
2622 A87E 69 00 00              adc   #0
2623 A881 85 6E                 sta   <CRNamePtr+2
2624 A883              ;
2625 A883 A9 C3 00              lda   #$C3                     ;access word
2626 A886 85 70                 sta   <CRAccess
2627 A888 A9 06 00              lda   #BinFile                 ;file type
2628 A88B 85 72                 sta   <CRFileType
2629 A88D A9 00 00              lda   #0
2630 A890 85 74                 sta   <CRAuxType               ;aux type
2631 A892 85 76                 sta   <CRAuxType+2             ;and more aux type
2632 A894 85 7A                 sta   <CRDate                  ;0 means ProDOS will fill in date
2633 A896 85 7C                 sta   <CRTime                  ;and time
2634 A898 A9 01 00              lda   #$01                     ;storage type
2635 A89B 85 78                 sta   <CRStore
2636 A89D
2637 A89D 20 AD BE              jsr   CreateFile
2638 A8A0 90 01                 bcc   MadeFLFile
2639 A8A2              ; some error:
2640 A8A2 60                    rts   
2641 A8A3
2642 A8A3              MadeFLFile  
2643 A8A3              ;now open it
2644 A8A3              ;(the name is still set from earlier in the routine)
2645 A8A3 A5 4C                 lda   <FMParamPtr
2646 A8A5 18                    clc   
2647 A8A6 69 44 00              adc   #(DirName-FMParams)
2648 A8A9              ;(we should probably be saving this pointer rether than recalculating
2649 A8A9              ;it every time.  Maybe.)
2650 A8A9 85 6E                 sta   <OpenPtr
2651 A8AB A5 4E                 lda   <FMParamPtr+2
2652 A8AD 69 00 00              adc   #0
2653 A8B0 85 70                 sta   <OpenPtr+2
2654 A8B2              ;
2655 A8B2 20 BF BE              jsr   OpenFile
2656 A8B5 90 01                 bcc   FLFileNowOpen
2657 A8B7              ;bad craziness:
2658 A8B7 60                    rts   
2659 A8B8              ;
2660 A8B8              FLFileNowOpen  
2661 A8B8 A5 6C                 lda   <OpenRef
2662 A8BA 85 D0                 sta   <FLFileRef
2663 A8BC A9 00 00              lda   #0
2664 A8BF 38                    sec   
2665 A8C0 60                    rts   
2666 A8C1              ***************************************
2667 A8C1              *                                     *
2668 A8C1              *  end OpenFLFile                     *
2669 A8C1              *                                     *
2670 A8C1              ***************************************
2671 A8C1              ;
2672 A8C1              *****************************************************************************
2673 A8C1              *                                                                           *
2674 A8C1              *  subroutine ReadFontLists                                                 *
2675 A8C1              *                                                                           *
2676 A8C1              *    started 8/31/87                                                        *
2677 A8C1              *    Bennet Marks  x6245                                                    *
2678 A8C1              *                                                                           *
2679 A8C1              *  This subroutine reads in the ID list, the fam list, and the name list    *
2680 A8C1              *  from FONT.LISTS into the Font Manager's internal lists.  We assume that  *
2681 A8C1              *  FONT.LISTS has passed the validity test, and its mark is now pointing at *
2682 A8C1              *  the start of its copy of the ID list.  If ReadFontLists succeeds, it     *
2683 A8C1              *  returns with the carry clear; otherwise it returns with the carry set    *
2684 A8C1              *  and the error code in the acc.  (The possible errors are in file-reading *
2685 A8C1              *  and handle-sizing.)                                                      *
2686 A8C1              *                                                                           *
2687 A8C1              *  ReadFontLists returns with an RTS and doesn't have its own entry point;  *
2688 A8C1              *  it's part of FMStartUp.                                                  *
2689 A8C1              *                                                                           *
2690 A8C1              *****************************************************************************
2691 A8C1              ;
2692 A8C1              ***************************************
2693 A8C1              *                                     *
2694 A8C1              *  9/11/87  3:00 pm                   *
2695 A8C1              *  BHM  x6245                         *
2696 A8C1              *                                     *
2697 A8C1              ***************************************
2698 A8C1              ;
2699 A8C1              ReadFontLists                           ;
2700 A8C1              ;
2701 A8C1 F4 00 00              PushWord #0                    ;high word of size
2702 A8C4 A5 60                 lda   <IDListSize              ;low word of size
2703 A8C6 48                    pha   
2704 A8C7 D4 0A D4 08           PushZLong <IDHandle 
2705 A8CB A2 02 19 22           _SetHandleSize 
2706 A8D2 90 01                 bcc   NoSizeErr1a
2707 A8D4 60                    rts   
2708 A8D5              NoSizeErr1a                             ;
2709 A8D5              ;
2710 A8D5 F4 00 00              PushWord #0                    ;high word of size
2711 A8D8 A5 62                 lda   <FamListSize             ;low word of size
2712 A8DA 48                    pha   
2713 A8DB D4 0E D4 0C           PushZLong <FamHandle 
2714 A8DF A2 02 19 22           _SetHandleSize 
2715 A8E6 90 01                 bcc   NoSizeErr2a
2716 A8E8 60                    rts   
2717 A8E9              NoSizeErr2a                             ;
2718 A8E9              ;
2719 A8E9 F4 00 00              PushWord #0                    ;high word of size
2720 A8EC A5 64                 lda   <NameListSize            ;low word of size
2721 A8EE 48                    pha   
2722 A8EF D4 12 D4 10           PushZLong <NameHandle          ;(*corrected 9/11/87 - BHM*)
2723 A8F3 A2 02 19 22           _SetHandleSize 
2724 A8FA 90 01                 bcc   NoSizeErr3
2725 A8FC 60                    rts   
2726 A8FD              NoSizeErr3                              ;
2727 A8FD              ;
2728 A8FD 20 EC C0              jsr   LockIdList
2729 A900 20 F8 C0              jsr   LockFamList
2730 A903 20 04 C1              jsr   LockNameList
2731 A906              ;
2732 A906 A5 D0                 lda   <FLFileRef
2733 A908 85 6C                 sta   <ReadRef
2734 A90A              ;
2735 A90A A5 30                 lda   <IDPtr
2736 A90C 85 6E                 sta   <ReadPtr
2737 A90E A5 32                 lda   <IDPtr+2
2738 A910 85 70                 sta   <ReadPtr+2
2739 A912 64 74                 stz   <ReadSize+2              ;high word of size
2740 A914 A5 60                 lda   <IDListSize              ;low word
2741 A916 85 72                 sta   <ReadSize
2742 A918 20 D1 BE              jsr   ReadFile
2743 A91B B0 3A                 bcs   FileReadError
2744 A91D              ;
2745 A91D A5 34                 lda   <FamPtr
2746 A91F 85 6E                 sta   <ReadPtr
2747 A921 A5 36                 lda   <FamPtr+2
2748 A923 85 70                 sta   <ReadPtr+2
2749 A925 A5 62                 lda   <FamListSize
2750 A927 85 72                 sta   <ReadSize
2751 A929              ;(high word of ReadSize is already 0)
2752 A929 20 D1 BE              jsr   ReadFile
2753 A92C B0 29                 bcs   FileReadError
2754 A92E              ;
2755 A92E A5 38                 lda   <NamePtr
2756 A930 85 6E                 sta   <ReadPtr
2757 A932              ; WHOA people, this next line was this:
2758 A932              ;	lda	<FamPtr+2
2759 A932              ; This seems to be incorrect (to say the least...) we will now change it to correctly use the
2760 A932              ; proper namePtr and this should fix a rather elusive bug that only sprung up with
2761 A932              ; stylewares stuff! imagine the shame on our faces! this should teach use a cut amnd paste lesson!
2762 A932 A5 3A                 lda   <NamePtr+2               ; 3/24/89 Mensch
2763 A934 85 70                 sta   <ReadPtr+2
2764 A936 A5 64                 lda   <NameListSize
2765 A938 85 72                 sta   <ReadSize
2766 A93A              ;(high word of ReadSize is already 0)
2767 A93A 20 D1 BE              jsr   ReadFile
2768 A93D B0 18                 bcs   FileReadError
2769 A93F              ;
2770 A93F              ;replace the ROM font handle read in from the FONT.LISTS ID list with the
2771 A93F              ;guaranteed one obtained from GetROMFont:
2772 A93F A5 B8                 lda   <ROMFontHndl
2773 A941 A0 0A 00              ldy   #10
2774 A944 97 30                 sta   [<IDPtr],y
2775 A946 A5 BA                 lda   <ROMFontHndl+2
2776 A948 C8                    iny   
2777 A949 C8                    iny   
2778 A94A 97 30                 sta   [<IDPtr],y
2779 A94C              ;
2780 A94C 20 F2 C0              jsr   UnlockIDList
2781 A94F 20 FE C0              jsr   UnlockFamList
2782 A952 20 0A C1              jsr   UnlockNameList
2783 A955
2784 A955 18                    clc   
2785 A956 60                    rts   
2786 A957              ;
2787 A957              FileReadError                           ;
2788 A957 60                    rts   
2789 A958              ***************************************
2790 A958              *                                     *
2791 A958              *  end of ReadFontLists               *
2792 A958              *                                     *
2793 A958              ***************************************
2794 A958              ;
2795 A958              *****************************************************************************
2796 A958              *                                                                           *
2797 A958              *  subroutine CloseFLFile                                                   *
2798 A958              *                                                                           *
2799 A958              *    started 8/31/87                                                        *
2800 A958              *    Bennet Marks  x6245                                                    *
2801 A958              *                                                                           *
2802 A958              *  This subroutine closes the file FONT.LISTS.  If it succeeds, it returns  *
2803 A958              *  with carry clear; otherwise with carry set and the error code in the     *
2804 A958              *  acc.                                                                     *
2805 A958              *                                                                           *
2806 A958              *  CloseFLFile returns with an RTS, and does not have its own entry point;  *
2807 A958              *  it's just part of FMStartUp.                                             *
2808 A958              *                                                                           *
2809 A958              *****************************************************************************
2810 A958              ;
2811 A958              ***************************************
2812 A958              *                                     *
2813 A958              *  8/31/87  2:30 pm                   *
2814 A958              *  BHM  x6245                         *
2815 A958              *                                     *
2816 A958              ***************************************
2817 A958              ;
2818 A958              CloseFLFile                             ;
2819 A958              ;
2820 A958 A5 D0                 lda   <FLFileRef
2821 A95A 85 6C                 sta   <CloseRef
2822 A95C 20 F5 BE              jsr   CloseFile
2823 A95F 60                    rts   
2824 A960              ***************************************
2825 A960              *                                     *
2826 A960              *  end of CloseFLFile                 *
2827 A960              *                                     *
2828 A960              ***************************************
2829 A960              ;
2830 A960              *****************************************************************************
2831 A960              *                                                                           *
2832 A960              *  subroutine UpdateFLFile                                                  *
2833 A960              *                                                                           *
2834 A960              *    started 8/31/87                                                        *
2835 A960              *    Bennet Marks                                                           *
2836 A960              *                                                                           *
2837 A960              *  This subroutine writes out to the file FONTS.LISTS the values and lists  *
2838 A960              *  that the FM has put together from all the fonts in FONTS - this is done  *
2839 A960              *  when FONT.LISTS doesn't pass the validity test.  We assume FONT.LISTS    *
2840 A960              *  exists, is open, and is empty - earlier routines have arranged this.     *
2841 A960              *                                                                           *
2842 A960              *  If UpdateFLFile is successful, it returns with carry clear; otherwise it *
2843 A960              *  returns with carry set and the error code in the acc.  The subroutine    *
2844 A960              *  returns with an RTS, and doesn't have its own entry point; it's part of  *
2845 A960              *  FMStartUp.                                                               *
2846 A960              *                                                                           *
2847 A960              *****************************************************************************
2848 A960              ;
2849 A960              ***************************************
2850 A960              *                                     *
2851 A960              *  11/7/87  2:00 pm                   *
2852 A960              *  BHM  x6245                         *
2853 A960              *                                     *
2854 A960              ***************************************
2855 A960              ;
2856 A960              UpdateFLFile                            ;
2857 A960              ;
2858 A960 A9 01 00              lda   #FLVerLo
2859 A963 87 40                 sta   [<BlockPtr]
2860 A965 A9 00 00              lda   #FLVerHi
2861 A968 A0 02 00              ldy   #2
2862 A96B 97 40                 sta   [<BlockPtr],y
2863 A96D              ;
2864 A96D A5 B2                 lda   <RomFamNum
2865 A96F A0 04 00              ldy   #oRomFamNum
2866 A972 97 40                 sta   [<BlockPtr],y
2867 A974              ;
2868 A974 A5 B4                 lda   <RomStyle
2869 A976 A0 06 00              ldy   #oRomStyle
2870 A979 97 40                 sta   [<BlockPtr],y
2871 A97B              ;
2872 A97B A5 B6                 lda   <RomSize
2873 A97D A0 08 00              ldy   #oRomSize
2874 A980 97 40                 sta   [<BlockPtr],y
2875 A982              ;
2876 A982 A5 68                 lda   <IDCount
2877 A984 A0 0A 00              ldy   #oIDCount
2878 A987 97 40                 sta   [<BlockPtr],y
2879 A989              ;
2880 A989 A5 6A                 lda   <FamCount
2881 A98B A0 0C 00              ldy   #oFamCount
2882 A98E 97 40                 sta   [<BlockPtr],y
2883 A990              ;
2884 A990 A5 60                 lda   <IDListSize
2885 A992 A0 0E 00              ldy   #oIDListSize
2886 A995 97 40                 sta   [<BlockPtr],y
2887 A997              ;
2888 A997 A5 62                 lda   <FamListSize
2889 A999 A0 10 00              ldy   #oFamListSize
2890 A99C 97 40                 sta   [<BlockPtr],y
2891 A99E              ;
2892 A99E A5 64                 lda   <NameListSize
2893 A9A0 A0 12 00              ldy   #oNameListSize
2894 A9A3 97 40                 sta   [<BlockPtr],y
2895 A9A5              ;
2896 A9A5 A5 D4                 lda   <FileListSize
2897 A9A7 A0 14 00              ldy   #oFileListSize
2898 A9AA 97 40                 sta   [<BlockPtr],y
2899 A9AC              ;
2900 A9AC A5 D8                 lda   <TimeListSize
2901 A9AE A0 16 00              ldy   #oTimeListSize
2902 A9B1 97 40                 sta   [<BlockPtr],y
2903 A9B3              ;
2904 A9B3 A5 D0                 lda   <FLFileRef
2905 A9B5 85 6C                 sta   <WriteRef
2906 A9B7 64 74                 stz   <WriteReq+2              ;high word of request
2907 A9B9 A9 18 00              lda   #FLFileHeadLen           ;low word
2908 A9BC 85 72                 sta   <WriteReq
2909 A9BE A5 40                 lda   <BlockPtr
2910 A9C0 85 6E                 sta   <WriteBuf
2911 A9C2 A5 42                 lda   <BlockPtr+2
2912 A9C4 85 70                 sta   <WriteBuf+2
2913 A9C6              ;
2914 A9C6 20 E3 BE              jsr   WriteFile
2915 A9C9 90 01                 bcc   WroteHeader
2916 A9CB 60                    rts   
2917 A9CC              WroteHeader                             ;
2918 A9CC              ;
2919 A9CC A5 D4                 lda   <FileListSize
2920 A9CE 85 72                 sta   <WriteReq
2921 A9D0              ;(high word still 0)
2922 A9D0              ;high word is 0 and stays 0
2923 A9D0 A5 50                 lda   <SavedFilePtr
2924 A9D2 85 6E                 sta   <WriteBuf
2925 A9D4 A5 52                 lda   <SavedFilePtr+2
2926 A9D6 85 70                 sta   <WriteBuf+2
2927 A9D8              ;
2928 A9D8 20 E3 BE              jsr   WriteFile
2929 A9DB 90 01                 bcc   WroteFileList
2930 A9DD 60                    rts   
2931 A9DE              WroteFileList                           ;
2932 A9DE              ;
2933 A9DE A5 D8                 lda   <TimeListSize
2934 A9E0 85 72                 sta   <WriteReq
2935 A9E2              ;(high word still 0)
2936 A9E2 A5 E2                 lda   <SavedTimePtr
2937 A9E4 85 6E                 sta   <WriteBuf
2938 A9E6 A5 E4                 lda   <SavedTimePtr+2
2939 A9E8 85 70                 sta   <WriteBuf+2
2940 A9EA              ;
2941 A9EA 20 E3 BE              jsr   WriteFile
2942 A9ED 90 01                 bcc   WroteTimeList
2943 A9EF 60                    rts   
2944 A9F0              WroteTimeList                           ;
2945 A9F0              ;
2946 A9F0 A5 60                 lda   <IDListSize
2947 A9F2 85 72                 sta   <WriteReq
2948 A9F4              ;(high word still 0)
2949 A9F4 A5 54                 lda   <SavedIDPtr
2950 A9F6 85 6E                 sta   <WriteBuf
2951 A9F8 A5 56                 lda   <SavedIDPtr+2
2952 A9FA 85 70                 sta   <WriteBuf+2
2953 A9FC              ;
2954 A9FC 20 E3 BE              jsr   WriteFile
2955 A9FF 90 01                 bcc   WroteIDList
2956 AA01 60                    rts   
2957 AA02              WroteIDList                             ;
2958 AA02              ;
2959 AA02 A5 62                 lda   <FamListSize
2960 AA04 85 72                 sta   <WriteReq
2961 AA06              ;(oh, you know!)
2962 AA06 A5 58                 lda   <SavedFamPtr
2963 AA08 85 6E                 sta   <WriteBuf
2964 AA0A A5 5A                 lda   <SavedFamPtr+2
2965 AA0C 85 70                 sta   <WriteBuf+2
2966 AA0E              ;
2967 AA0E 20 E3 BE              jsr   WriteFile
2968 AA11 90 01                 bcc   WroteFamList
2969 AA13 60                    rts   
2970 AA14              WroteFamList                            ;
2971 AA14              ;
2972 AA14 A5 64                 lda   <NameListSize
2973 AA16 85 72                 sta   <WriteReq
2974 AA18 A5 5C                 lda   <SavedNamePtr
2975 AA1A 85 6E                 sta   <WriteBuf
2976 AA1C A5 5E                 lda   <SavedNamePtr+2
2977 AA1E 85 70                 sta   <WriteBuf+2
2978 AA20              ;
2979 AA20 20 E3 BE              jsr   WriteFile
2980 AA23              ;(SURELY that can be looped!)
2981 AA23              ;(yes, it probably can - and don't call me Shirley . . .)
2982 AA23              ;
2983 AA23 60                    rts   
2984 AA24              ***************************************
2985 AA24              *                                     *
2986 AA24              *  end UpdateFLFile                   *
2987 AA24              *                                     *
2988 AA24              ***************************************
2989 AA24              ;
2990 AA24              ;
2991 AA24                       ENDP 
2992 AA24
2993 AA24
2994 AA24
2995 AA24              ****************************************************************
2996 AA24              *
2997 AA24              * FMShutDown
2998 AA24              *
2999 AA24              ****************************************************************
3000 AA24
3001 AA24                       ENTRY FMShutDown
3002 AA24              FMShutDown PROC 
3003 AA24
3004 AA24              Count    equ   Temp
3005 AA24
3006 AA24 0B                    phd   
3007 AA25 5B                    tcd   
3008 AA26 D0 0A                 bne   Doit
3009 AA28 A2 03 1B              ldx   #ActiveErr               ;return error if Font Mgr not active
3010 AA2B A0 00 00              ldy   #0                       ;param size
3011 AA2E 5C B3 FC FE           jml   errout
3012 AA32
3013 AA32              ;set QuickDraw system font to ROM font
3014 AA32
3015 AA32 20 EC C0     Doit     jsr   LockIDList               ;ROM font is first entry in list
3016 AA35 A0 0C 00              ldy   #12
3017 AA38 B7 30                 lda   [<IDPtr],y               ;push handle to ROM font
3018 AA3A 48                    pha   
3019 AA3B 88                    dey   
3020 AA3C 88                    dey   
3021 AA3D B7 30                 lda   [<IDPtr],y
3022 AA3F 48                    pha   
3023 AA40 A2 04 B2 22           _SetSysFont                    ;set QuickDraw system font to ROM font
3024 AA47
3025 AA47              ;dispose of all fonts in memory, except application-generated fonts
3026 AA47
3027 AA47 64 A0                 stz   <Count
3028 AA49 80 29                 bra   NextID                   ;skip ROM font
3029 AA4B
3030 AA4B 20 65 BF     Loop     jsr   CheckHandle
3031 AA4E F0 24                 beq   NextID                   ;branch if no handle to font
3032 AA50 F4 03 00              PushWord #3                    ;in case it's an app font
3033 AA53 A5 16 48 A5           PushLong <FontHandle           ;push handle to font on stack
3034 AA59
3035 AA59 A0 08 00              ldy   #8
3036 AA5C B7 30                 lda   [<IDPtr],y               ;get info word
3037 AA5E 29 08 00              and   #ApVarBit                ;is this an application generated font?
3038 AA61 D0 0A                 bne   AppFont                  ;yes - so don't dispose of handle
3039 AA63 A2 02 10 22           _DisposeHandle                 ;no - so dispose of font and handle
3040 AA6A 68                    pla                            ;clean up stack
3041 AA6B 80 07                 bra   NextID
3042 AA6D
3043 AA6D A2 02 24 22  AppFont  _SetPurge                      ;make font purgeable
3044 AA74
3045 AA74 20 8D C0     NextID   jsr   IncIDPtr
3046 AA77 E6 A0                 inc   <Count
3047 AA79 A5 A0                 lda   <Count
3048 AA7B C5 68                 cmp   <IDCount                 ;at end of list?
3049 AA7D D0 CC                 bne   Loop                     ;no
3050 AA7F
3051 AA7F 20 F2 C0              jsr   UnLockIDList
3052 AA82
3053 AA82              ;dispose of the data lists
3054 AA82
3055 AA82 D4 06 D4 04           PushZLong <FileHandle 
3056 AA86 A2 02 10 22           _DisposeHandle                 ;release filename list space
3057 AA8D D4 0A D4 08           PushZLong <IDHandle 
3058 AA91 A2 02 10 22           _DisposeHandle                 ;release ID list space
3059 AA98 D4 0E D4 0C           PushZLong <FamHandle 
3060 AA9C A2 02 10 22           _DisposeHandle                 ;release family list space
3061 AAA3 D4 12 D4 10           PushZLong <NameHandle 
3062 AAA7 A2 02 10 22           _DisposeHandle                 ;release famname list space
3063 AAAE D4 26 D4 24           PushZLong <FMParamHandle       ;and the paramter space
3064 AAB2 A2 02 10 22           _DisposeHandle 
3065 AAB9
3066 AAB9 A5 80                 lda   <MenuMade                ;was an Item list created?
3067 AABB F0 0B                 beq   NoItemList               ;no
3068 AABD D4 22 D4 20           PushZLong <ItemHandle          ;yes - so release the space
3069 AAC1 A2 02 10 22           _DisposeHandle 
3070 AAC8              NoItemList                              ;
3071 AAC8
3072 AAC8              ;clear work area pointer
3073 AAC8
3074 AAC8 F4 00 00              PushWord #0 
3075 AACB F4 1B 00              PushWord #FMTSNum 
3076 AACE F4 00 00              PushWord #0 
3077 AAD1 F4 00 00              PushWord #0 
3078 AAD4 A2 01 0D 22           _SetWAP                        ;clear work area pointer
3079 AADB
3080 AADB A0 00 00              ldy   #0                       ;param size
3081 AADE 5C B0 FC FE           jml   endcall
3082 AAE2                       ENDP 
3083 AAE2
3084 AAE2
3085 AAE2
3086 AAE2              ****************************************************************
3087 AAE2              *
3088 AAE2              * FMVersion
3089 AAE2              *
3090 AAE2              ****************************************************************
3091 AAE2
3092 AAE2                       ENTRY FMVersion
3093 AAE2              FMVersion PROC 
3094 AAE2 A9 00 03              lda   #FMVerNum
3095 AAE5 83 07                 sta   7,s
3096 AAE7 4C 82 C1              jmp   oStdEnd0
3097 AAEA                       ENDP 
3098 AAEA
3099 AAEA
3100 AAEA              ****************************************************************
3101 AAEA              *
3102 AAEA              * FMReset
3103 AAEA              *
3104 AAEA              ****************************************************************
3105 AAEA
3106 AAEA                       ENTRY FMReset
3107 AAEA              FMReset  PROC 
3108 AAEA C9 00 00              cmp   #0                       ;is FM active?
3109 AAED F0 0A                 beq   Done                     ;no
3110 AAEF A2 02 1B              ldx   #ResetErr                ;yes - so return error
3111 AAF2 A0 00 00              ldy   #0                       ;param size
3112 AAF5 5C B4 FC FE           jml   oerrout
3113 AAF9
3114 AAF9 4C 82 C1     Done     jmp   oStdEnd0
3115 AAFC                       ENDP 
3116 AAFC
3117 AAFC
3118 AAFC              ****************************************************************
3119 AAFC              *
3120 AAFC              * FMStatus
3121 AAFC              *
3122 AAFC              ****************************************************************
3123 AAFC
3124 AAFC                       ENTRY FMStatus
3125 AAFC              FMStatus PROC 
3126 AAFC 83 07                 sta   7,s
3127 AAFE 4C 82 C1              jmp   oStdEnd0
3128 AB01                       ENDP 
3129 AB01              ;
3130 AB01              ;
3131 AB01              ;
3132 AB01              ;
3133 AB01              ;
3134 AB01
3135 AB01
3136 AB01              ;                COPY famstuff
3137 AB01
3138 AB01
3139 AB01
3140 AB01              ****************************************************************
3141 AB01              *
3142 AB01              * CountFamilies
3143 AB01              *
3144 AB01              ****************************************************************
3145 AB01
3146 AB01                       ENTRY CountFamilies
3147 AB01              CountFamilies PROC 
3148 AB01
3149 AB01              BaseCount equ   Temp
3150 AB01
3151 AB01 0B                    phd   
3152 AB02 5B                    tcd   
3153 AB03 A3 09                 lda   9,s                      ;get spec bits
3154 AB05 29 20 00              and   #BaseOnlyBit             ;only count Base families?
3155 AB08 F0 23                 beq   CountAll                 ;no
3156 AB0A
3157 AB0A 20 F8 C0              jsr   LockFamList              ;yes
3158 AB0D A0 04 00              ldy   #4                       ;index to info word in fam entry
3159 AB10 A2 00 00              ldx   #0                       ;# of fam entries processed
3160 AB13 64 A0                 stz   <BaseCount               ;# base families found
3161 AB15
3162 AB15 B7 34        Loop     lda   [<FamPtr],y              ;get info word
3163 AB17 29 20 00              and   #NotBaseBit
3164 AB1A D0 02                 bne   NextFam                  ;branch if not a Base family
3165 AB1C E6 A0                 inc   <BaseCount
3166 AB1E 20 9D C0     NextFam  jsr   IncFamPtr
3167 AB21 E8                    inx   
3168 AB22 E4 6A                 cpx   <FamCount                ;at end of fam list?
3169 AB24 D0 EF                 bne   Loop                     ;no
3170 AB26
3171 AB26 20 FE C0              jsr   UnLockFamList
3172 AB29 A5 A0                 lda   <BaseCount               ;return # of Base families
3173 AB2B 80 02                 bra   Done
3174 AB2D
3175 AB2D A5 6A        CountAll lda   <FamCount                ;get total # of fam entries
3176 AB2F 83 0B        Done     sta   11,s
3177 AB31 A0 02 00              ldy   #2                       ;param size
3178 AB34 5C B0 FC FE           jml   endcall
3179 AB38                       ENDP 
3180 AB38
3181 AB38
3182 AB38
3183 AB38              ****************************************************************
3184 AB38              *
3185 AB38              * FindFamily
3186 AB38              *
3187 AB38              ****************************************************************
3188 AB38
3189 AB38                       ENTRY FindFamily
3190 AB38              FindFamily PROC 
3191 AB38
3192 AB38              BaseCount equ   Temp
3193 AB38              Mult2    equ   BaseCount+2
3194 AB38
3195 AB38 0B                    phd   
3196 AB39 5B                    tcd   
3197 AB3A
3198 AB3A 20 F8 C0              jsr   LockFamList
3199 AB3D
3200 AB3D A3 0F                 lda   15,s                     ;get spec bits
3201 AB3F 29 20 00              and   #BaseOnlyBit             ;Base families only?
3202 AB42 D0 1C                 bne   CheckBase                ;yes
3203 AB44
3204 AB44 A3 0D                 lda   13,s                     ;get position num
3205 AB46 3A                    dec   a
3206 AB47 C5 6A                 cmp   <FamCount                ;valid number?
3207 AB49 B0 34                 bcs   NoFam                    ;no
3208 AB4B
3209 AB4B 0A                    asl   a                        ;multiply by 6 to get offset to correct
3210 AB4C 85 A2                 sta   <Mult2                   ;fam entry
3211 AB4E 0A                    asl   a
3212 AB4F 18                    clc   
3213 AB50 65 A2                 adc   <Mult2
3214 AB52 18                    clc   
3215 AB53 65 34                 adc   <FamPtr                  ;create ptr to fam entry
3216 AB55 85 34                 sta   <FamPtr
3217 AB57 A5 36                 lda   <FamPtr+2
3218 AB59 69 00 00              adc   #0
3219 AB5C 85 36                 sta   <FamPtr+2
3220 AB5E 80 26                 bra   GotFam
3221 AB60
3222 AB60 A2 00 00     CheckBase ldx   #0                      ;# of fam entries processed
3223 AB63 64 A0                 stz   <BaseCount               ;# of Base families processed
3224 AB65 A0 04 00              ldy   #4                       ;index to info word in fam entry
3225 AB68
3226 AB68 B7 34        Loop     lda   [<FamPtr],y              ;get info word
3227 AB6A 29 20 00              and   #NotBaseBit
3228 AB6D D0 08                 bne   NextFam                  ;not a Base fam - so don't count fam
3229 AB6F E6 A0                 inc   <BaseCount
3230 AB71 A5 A0                 lda   <BaseCount
3231 AB73 C3 0D                 cmp   13,s                     ;correct fam entry?
3232 AB75 F0 0F                 beq   GotFam                   ;yes
3233 AB77
3234 AB77 20 9D C0     NextFam  jsr   IncFamPtr
3235 AB7A E8                    inx   
3236 AB7B E4 6A                 cpx   <FamCount                ;at end of fam list?
3237 AB7D D0 E9                 bne   Loop                     ;no
3238 AB7F
3239 AB7F A9 FF FF     NoFam    lda   #Illegal                 ;didn't find family
3240 AB82 83 11                 sta   17,s                     ;return illegal fam num
3241 AB84 80 38                 bra   Done
3242 AB86
3243 AB86 A7 34        GotFam   lda   [<FamPtr]                ;get fam #
3244 AB88 83 11                 sta   17,s                     ;and return it
3245 AB8A
3246 AB8A A3 09                 lda   9,s                      ;get ptr to output string
3247 AB8C 85 28                 sta   <TempPtr
3248 AB8E 03 0B                 ora   11,s                     ;is ptr all zeros?
3249 AB90 F0 2C                 beq   Done                     ;yes - so don't return name
3250 AB92 A3 0B                 lda   11,s
3251 AB94 85 2A                 sta   <TempPtr+2
3252 AB96
3253 AB96 20 04 C1              jsr   LockNameList
3254 AB99 A0 02 00              ldy   #2
3255 AB9C B7 34                 lda   [<FamPtr],y              ;get offset to famname entry
3256 AB9E 18                    clc   
3257 AB9F 65 38                 adc   <NamePtr                 ;create ptr to famname entry
3258 ABA1 85 38                 sta   <NamePtr
3259 ABA3 A5 3A                 lda   <NamePtr+2
3260 ABA5 69 00 00              adc   #0
3261 ABA8 85 3A                 sta   <NamePtr+2
3262 ABAA
3263 ABAA A7 38                 lda   [<NamePtr]               ;get name length
3264 ABAC 29 FF 00              and   #$00FF                   ;mask off hi byte
3265 ABAF A8                    tay   
3266 ABB0 88                    dey   
3267 ABB1 B7 38        CopyLoop lda   [<NamePtr],y             ;copy famname into output string
3268 ABB3 97 28                 sta   [<TempPtr],y
3269 ABB5 88                    dey   
3270 ABB6 F0 F9                 beq   CopyLoop
3271 ABB8 88                    dey   
3272 ABB9 10 F6                 bpl   CopyLoop
3273 ABBB
3274 ABBB 20 0A C1              jsr   UnLockNameList
3275 ABBE
3276 ABBE 20 FE C0     Done     jsr   UnLockFamList
3277 ABC1 A0 08 00              ldy   #8                       ;param size
3278 ABC4 5C B0 FC FE           jml   endcall
3279 ABC8                       ENDP 
3280 ABC8
3281 ABC8
3282 ABC8
3283 ABC8              ****************************************************************
3284 ABC8              *
3285 ABC8              * GetFamInfo
3286 ABC8              *
3287 ABC8              ****************************************************************
3288 ABC8
3289 ABC8                       ENTRY GetFamInfo
3290 ABC8              GetFamInfo PROC 
3291 ABC8
3292 ABC8 0B                    phd   
3293 ABC9 5B                    tcd   
3294 ABCA
3295 ABCA A3 0D                 lda   13,s                     ;get fam #
3296 ABCC A8                    tay   
3297 ABCD A9 00 01              lda   #$0100                   ;fake style/size
3298 ABD0 20 7D BF              jsr   CheckFontID
3299 ABD3 90 03                 bcc   IDOK
3300 ABD5 4C 9E C1              jmp   StdErr6                  ;return error
3301 ABD8
3302 ABD8 98           IDOK     tya   
3303 ABD9 83 0D                 sta   13,s                     ;save converted fam #
3304 ABDB
3305 ABDB 20 F8 C0              jsr   LockFamList
3306 ABDE A2 00 00              ldx   #0                       ;# of fam entries checked
3307 ABE1 A7 34        FamLoop  lda   [<FamPtr]                ;get fam #
3308 ABE3 C3 0D                 cmp   13,s                     ;match?
3309 ABE5 F0 10                 beq   GotFam                   ;yes
3310 ABE7 20 9D C0              jsr   IncFamPtr
3311 ABEA E8                    inx   
3312 ABEB E4 6A                 cpx   <FamCount                ;have we checked all fam entries?
3313 ABED D0 F2                 bne   FamLoop                  ;no
3314 ABEF
3315 ABEF A9 00 80              lda   #NotFoundBit             ;yes - so the fam doesn't exist
3316 ABF2 83 0F                 sta   15,s                     ;return 'NotFound'
3317 ABF4 82 3B 00              brl   Done
3318 ABF7
3319 ABF7 A0 04 00     GotFam   ldy   #4
3320 ABFA B7 34                 lda   [<FamPtr],y              ;get info word
3321 ABFC 83 0F                 sta   15,s                     ;and return it
3322 ABFE
3323 ABFE A3 09                 lda   9,s                      ;get ptr to output string
3324 AC00 85 28                 sta   <TempPtr
3325 AC02 03 0B                 ora   11,s                     ;is ptr 0?
3326 AC04 F0 2C                 beq   Done                     ;yes - so don't return famname
3327 AC06 A3 0B                 lda   11,s
3328 AC08 85 2A                 sta   <TempPtr+2
3329 AC0A
3330 AC0A 20 04 C1              jsr   LockNameList
3331 AC0D
3332 AC0D A0 02 00              ldy   #2
3333 AC10 18                    clc   
3334 AC11 A5 38                 lda   <NamePtr                 ;get ptr to start of famname list and
3335 AC13 77 34                 adc   [<FamPtr],y              ;add famname offset to create
3336 AC15 85 38                 sta   <NamePtr                 ;ptr to correct famname
3337 AC17 A5 3A                 lda   <NamePtr+2
3338 AC19 69 00 00              adc   #0
3339 AC1C 85 3A                 sta   <NamePtr+2
3340 AC1E
3341 AC1E A7 38                 lda   [<NamePtr]               ;get name length
3342 AC20 29 FF 00              and   #$00FF                   ;mask off hi byte
3343 AC23 A8                    tay   
3344 AC24 88                    dey   
3345 AC25 B7 38        Loop     lda   [<NamePtr],y             ;copy famname into output string
3346 AC27 97 28                 sta   [<TempPtr],y
3347 AC29 88                    dey   
3348 AC2A F0 F9                 beq   Loop
3349 AC2C 88                    dey   
3350 AC2D 10 F6                 bpl   Loop
3351 AC2F
3352 AC2F 20 0A C1              jsr   UnLockNameList
3353 AC32
3354 AC32 20 FE C0     Done     jsr   UnLockFamList
3355 AC35 4C 97 C1              jmp   StdEnd6
3356 AC38                       ENDP 
3357 AC38
3358 AC38
3359 AC38
3360 AC38              ****************************************************************
3361 AC38              *
3362 AC38              * GetFamNum
3363 AC38              *
3364 AC38              ****************************************************************
3365 AC38
3366 AC38                       ENTRY GetFamNum
3367 AC38              GetFamNum PROC 
3368 AC38
3369 AC38              Mult2    equ   Temp
3370 AC38              FirstWord equ   Mult2+2
3371 AC38
3372 AC38 0B                    phd   
3373 AC39 5B                    tcd   
3374 AC3A
3375 AC3A A3 09                 lda   9,s                      ;get ptr to famname
3376 AC3C 85 28                 sta   <TempPtr
3377 AC3E A3 0B                 lda   11,s
3378 AC40 85 2A                 sta   <TempPtr+2
3379 AC42 A7 28                 lda   [<TempPtr]               ;get first 2 bytes of name
3380 AC44 85 A2                 sta   <FirstWord               ;and save
3381 AC46 29 FF 00              and   #$00FF                   ;get name length
3382 AC49 D0 06                 bne   NotZero
3383 AC4B A2 0A 1B              ldx   #NameErr                 ;name length is 0
3384 AC4E 4C 90 C1              jmp   StdErr4                  ;return error
3385 AC51
3386 AC51 C9 1A 00     NotZero  cmp   #MaxNameLen+1            ;check length of name
3387 AC54 90 0A                 bcc   LenOK
3388 AC56 A5 A2                 lda   <FirstWord               ;too long - so truncate
3389 AC58 29 00 FF              and   #$FF00                   ;get saved first 2 bytes and set
3390 AC5B 09 19 00              ora   #MaxNameLen              ;length byte to max name length
3391 AC5E 85 A2                 sta   <FirstWord               ;and save
3392 AC60
3393 AC60 20 04 C1     LenOK    jsr   LockNameList
3394 AC63 A2 00 00              ldx   #0                       ;# of famname entries checked
3395 AC66
3396 AC66 A7 38        NameLoop lda   [<NamePtr]               ;do the first 2 bytes of this famname
3397 AC68 C5 A2                 cmp   <FirstWord               ;entry match the input name?
3398 AC6A D0 27                 bne   NextName                 ;no - so go on to next name
3399 AC6C              ;                                       ;yes - so compare the rest of the name
3400 AC6C 29 FF 00              and   #$00FF                   ;mask off hi byte to get name length
3401 AC6F A8                    tay   
3402 AC70 88                    dey   
3403 AC71 F0 0A        CmpLoop  beq   Match                    ;already compared first word so match
3404 AC73 B7 38                 lda   [<NamePtr],y             ;compare names
3405 AC75 D7 28                 cmp   [<TempPtr],y
3406 AC77 D0 1A                 bne   NextName                 ;branch if no match
3407 AC79 88                    dey   
3408 AC7A 88                    dey   
3409 AC7B 10 F4                 bpl   CmpLoop
3410 AC7D              ;                                       ;the name matches exactly
3411 AC7D DA           Match    phx                            ;save index to name
3412 AC7E
3413 AC7E 20 F8 C0              jsr   LockFamList
3414 AC81 68                    pla                            ;get index to name and multiply by 6
3415 AC82 0A                    asl   a
3416 AC83 85 A0                 sta   <Mult2
3417 AC85 0A                    asl   a
3418 AC86 18                    clc   
3419 AC87 65 A0                 adc   <Mult2
3420 AC89 A8                    tay                            ;to get offset into fam list
3421 AC8A B7 34                 lda   [<FamPtr],y              ;get fam # from fam entry
3422 AC8C 83 0D                 sta   13,s                     ;and return it
3423 AC8E 20 FE C0              jsr   UnLockFamList
3424 AC91 80 0D                 bra   Done
3425 AC93
3426 AC93 20 AD C0     NextName jsr   IncNamePtr
3427 AC96 E8                    inx   
3428 AC97 E4 6A                 cpx   <FamCount                ;done with list?
3429 AC99 D0 CB                 bne   NameLoop                 ;no - so continue
3430 AC9B
3431 AC9B A9 FF FF              lda   #Illegal                 ;yes - so no match
3432 AC9E 83 0D                 sta   13,s                     ;return illegal fam #
3433 ACA0
3434 ACA0 20 0A C1     Done     jsr   UnLockNameList
3435 ACA3 4C 89 C1              jmp   StdEnd4
3436 ACA6                       ENDP 
3437 ACA6
3438 ACA6
3439 ACA6
3440 ACA6              ****************************************************************
3441 ACA6              *
3442 ACA6              * AddFamily
3443 ACA6              *
3444 ACA6              ****************************************************************
3445 ACA6
3446 ACA6                       ENTRY AddFamily
3447 ACA6              AddFamily PROC 
3448 ACA6
3449 ACA6              NewFamSize equ   Temp
3450 ACA6              NewNameSize equ   NewFamSize+2
3451 ACA6
3452 ACA6 0B                    phd   
3453 ACA7 5B                    tcd   
3454 ACA8
3455 ACA8 A3 0D                 lda   13,s                     ;get fam #
3456 ACAA F0 05                 beq   NumErr                   ;error if 0
3457 ACAC C9 FF FF              cmp   #Illegal                 ;illegal # ?
3458 ACAF D0 06                 bne   NumOK                    ;no
3459 ACB1 A2 08 1B     NumErr   ldx   #FamNumErr
3460 ACB4 4C 9E C1              jmp   StdErr6                  ;return error
3461 ACB7
3462 ACB7 A3 09        NumOK    lda   9,s                      ;get ptr to new family name
3463 ACB9 85 28                 sta   <TempPtr
3464 ACBB A3 0B                 lda   11,s
3465 ACBD 85 2A                 sta   <TempPtr+2
3466 ACBF A7 28                 lda   [<TempPtr]
3467 ACC1 29 FF 00              and   #$00FF                   ;get name length
3468 ACC4 D0 06                 bne   NotZero
3469 ACC6 A2 0A 1B              ldx   #NameErr                 ;name length is 0
3470 ACC9 4C 9E C1              jmp   StdErr6                  ;return error
3471 ACCC
3472 ACCC 18           NotZero  clc   
3473 ACCD A5 62                 lda   <FamListSize             ;get size of family list
3474 ACCF 69 06 00              adc   #6                       ;add size of new entry
3475 ACD2 85 A0                 sta   <NewFamSize              ;and save
3476 ACD4
3477 ACD4 F4 00 00              PushWord #0                    ;hi word of size
3478 ACD7 48                    pha                            ;lo word of size
3479 ACD8 D4 0E D4 0C           PushZLong <FamHandle           ;handle to list
3480 ACDC A2 02 19 22           _SetHandleSize                 ;grow the list
3481 ACE3 90 04                 bcc   OK
3482 ACE5 AA                    tax                            ;error code
3483 ACE6 4C 9E C1              jmp   StdErr6                  ;return error
3484 ACE9
3485 ACE9 A7 28        OK       lda   [<TempPtr]               ;get length of name
3486 ACEB 29 FF 00              and   #$00FF                   ;mask off hi byte
3487 ACEE C9 1A 00              cmp   #MaxNameLen+1            ;check length of fam name
3488 ACF1 90 03                 bcc   LenOK
3489 ACF3 A9 19 00              lda   #MaxNameLen              ;too long - so truncate name
3490 ACF6 1A           LenOK    inc   a                        ;add 1 for length byte itself
3491 ACF7
3492 ACF7 18                    clc   
3493 ACF8 65 64                 adc   <NameListSize            ;add size of new entry to current size
3494 ACFA 85 A2                 sta   <NewNameSize             ;and save
3495 ACFC
3496 ACFC F4 00 00              PushWord #0                    ;hi word of size
3497 ACFF 48                    pha                            ;lo word of size
3498 AD00 D4 12 D4 10           PushZLong <NameHandle          ;handle to list
3499 AD04 A2 02 19 22           _SetHandleSize                 ;grow the list
3500 AD0B 90 15                 bcc   OK2
3501 AD0D 48                    pha                            ;save error code
3502 AD0E F4 00 00              PushWord #0                    ;hi word of size
3503 AD11 D4 62                 PushZWord <FamListSize         ;lo word of size
3504 AD13 D4 0E D4 0C           PushZLong <FamHandle           ;handle to list
3505 AD17 A2 02 19 22           _SetHandleSize                 ;shrink fam list back to previous size
3506 AD1E FA                    plx                            ;retrieve error code
3507 AD1F 4C 9E C1              jmp   StdErr6                  ;return error
3508 AD22
3509 AD22 20 F8 C0     OK2      jsr   LockFamList
3510 AD25 20 04 C1              jsr   LockNameList
3511 AD28
3512 AD28 18                    clc   
3513 AD29 A5 34                 lda   <FamPtr
3514 AD2B 65 62                 adc   <FamListSize             ;create ptr to new fam entry
3515 AD2D 85 34                 sta   <FamPtr
3516 AD2F A5 36                 lda   <FamPtr+2
3517 AD31 69 00 00              adc   #0
3518 AD34 85 36                 sta   <FamPtr+2
3519 AD36
3520 AD36 18                    clc   
3521 AD37 A5 38                 lda   <NamePtr
3522 AD39 65 64                 adc   <NameListSize            ;create ptr to new famname entry
3523 AD3B 85 38                 sta   <NamePtr
3524 AD3D A5 3A                 lda   <NamePtr+2
3525 AD3F 69 00 00              adc   #0
3526 AD42 85 3A                 sta   <NamePtr+2
3527 AD44
3528 AD44 A3 0D                 lda   13,s                     ;get fam #
3529 AD46 87 34                 sta   [<FamPtr]                ;and store in new fam entry
3530 AD48 A0 02 00              ldy   #2
3531 AD4B A5 64                 lda   <NameListSize            ;get offset to new famname entry
3532 AD4D 97 34                 sta   [<FamPtr],y              ;and store in new fam entry
3533 AD4F C8                    iny   
3534 AD50 C8                    iny   
3535 AD51 A9 04 00              lda   #ApFamBit
3536 AD54 09 20 00              ora   #NotBaseBit
3537 AD57 97 34                 sta   [<FamPtr],y              ;set info word
3538 AD59
3539 AD59 20 B4 BF              jsr   CopyFamName              ;copy famname into new famname entry
3540 AD5C
3541 AD5C 20 0A C1              jsr   UnLockNameList
3542 AD5F 20 FE C0              jsr   UnLockFamList
3543 AD62
3544 AD62 A5 A0                 lda   <NewFamSize              ;get new size of fam list
3545 AD64 85 62                 sta   <FamListSize             ;and save
3546 AD66 A5 A2                 lda   <NewNameSize             ;get new size of name list
3547 AD68 85 64                 sta   <NameListSize            ;and save
3548 AD6A E6 6A                 inc   <FamCount                ;inc family count
3549 AD6C
3550 AD6C 4C 97 C1              jmp   StdEnd6
3551 AD6F                       ENDP 
3552 AD6F
3553 AD6F
3554 AD6F              ****************************************************************
3555 AD6F              *
3556 AD6F              * InstallFont
3557 AD6F              *
3558 AD6F              ****************************************************************
3559 AD6F              ;
3560 AD6F              ***************************************
3561 AD6F              *                                     *
3562 AD6F              *  Sept. 18, 1987  10:30 am           *
3563 AD6F              *                                     *
3564 AD6F              ***************************************
3565 AD6F              ;
3566 AD6F              ***************************************************************
3567 AD6F              *
3568 AD6F              *  font scaling added
3569 AD6F              *
3570 AD6F              *    Bennet Marks  x6245  2/10/87
3571 AD6F              *
3572 AD6F              *  changes made to get the right incarnation of the system
3573 AD6F              *  font (that is, right size and style) in the no-such-family
3574 AD6F              *  case
3575 AD6F              *
3576 AD6F              *    Bennet Marks  x6245  3/31/87
3577 AD6F              *
3578 AD6F              *
3579 AD6F              *
3580 AD6F              ***************************************************************
3581 AD6F              InstallFont PROC 
3582 AD6F                       INCLUDE 'SomeFMEqus'           ;added 2/12/87 - BHM
3583 AD6F
3584 AD6F 0B                    phd   
3585 AD70 5B                    tcd   
3586 AD71
3587 AD71 64 BA                 stz   <Err                     ;clear error flag
3588 AD73
3589 AD73 A3 0B                 lda   11,s                     ;get fam #
3590 AD75 A8                    tay   
3591 AD76 A3 0D                 lda   13,s                     ;get style/size
3592 AD78 20 7D BF              jsr   CheckFontID
3593 AD7B 90 03                 bcc   IDOK
3594 AD7D 4C 9E C1              jmp   StdErr6                  ;return error
3595 AD80
3596 AD80 83 0D        IDOK     sta   13,s                     ;save converted style/size
3597 AD82              ;
3598 AD82 29 FF 00              and   #$00FF
3599 AD85 85 AC                 sta   <WantStyle
3600 AD87 A3 0D                 lda   13,s
3601 AD89 29 00 FF              and   #$FF00
3602 AD8C 85 AE                 sta   <WantSize
3603 AD8E              ;
3604 AD8E 98                    tya   
3605 AD8F 83 0B                 sta   11,s                     ;save converted fam #
3606 AD91 85 B0                 sta   <WantFam
3607 AD93              ;
3608 AD93              TryAgain  
3609 AD93              ;
3610 AD93 20 EC C0              jsr   LockIDList
3611 AD96              ;
3612 AD96              ****  temporary fix to get IDList out of a jam
3613 AD96              ;
3614 AD96              **  Drop this for now - BHM  9/17/87
3615 AD96              ;              jsr UnlockIDList
3616 AD96              ;
3617 AD96              ****  end of temporary fix - BHM  2/12/87
3618 AD96              ;
3619 AD96              ;
3620 AD96 20 81 AE              jsr   FindBestFit              ;find font which best fits request
3621 AD99 B0 71                 bcs   LoadSys                  ;system font is best fit
3622 AD9B              ;
3623 AD9B              ****  quick fix added for byte-switch problems - BHM  2/11/87
3624 AD9B              ;
3625 AD9B A5 AE                 lda   <WantSize
3626 AD9D EB                    xba   
3627 AD9E 85 AE                 sta   <WantSize
3628 ADA0              ;
3629 ADA0 A5 A6                 lda   <BestSize
3630 ADA2 EB                    xba   
3631 ADA3 85 A6                 sta   <BestSize
3632 ADA5              ;
3633 ADA5              ****  end of quick fix
3634 ADA5              ;
3635 ADA5              ********    FONT SCALING ADDITIONS:
3636 ADA5              ;
3637 ADA5 A5 A6                 lda   <BestSize
3638 ADA7 C5 AE                 cmp   <WantSize
3639 ADA9 F0 53                 beq   DontScale
3640 ADAB              ;
3641 ADAB A3 09                 lda   9,s                      ;scaleWord
3642 ADAD 29 01 00              and   #dontScaleBit
3643 ADB0 D0 4C                 bne   DontScale
3644 ADB2              ;scale:
3645 ADB2 A9 01 00              lda   #currFlag
3646 ADB5 20 6F B3              jsr   LoadTheFont              ;get the best fit font
3647 ADB8              ;
3648 ADB8              ***************************************************************
3649 ADB8              *
3650 ADB8              *  NOTE:  we count on the fact that there are no memory
3651 ADB8              *  manager calls that could get the loaded-in font purged
3652 ADB8              *  (in the case where it is purgeable) between here and
3653 ADB8              *  the call to ScaleFont.  If you make any changes -
3654 ADB8              *  watch it!
3655 ADB8              *
3656 ADB8              *  BHM 6/15/87
3657 ADB8              *
3658 ADB8              ***************************************************************
3659 ADB8              ;
3660 ADB8 90 08                 bcc   GotFont                  ;got it
3661 ADBA              ;error:
3662 ADBA A5 BA                 lda   <Err
3663 ADBC              ;if we've already got an error (which means this is not our first
3664 ADBC              ;pass), keep the old error code
3665 ADBC D0 02                 bne   GotErr1
3666 ADBE 86 BA                 stx   <Err                     ;o.w. save it
3667 ADC0              GotErr1                                 ;
3668 ADC0 80 4A                 bra   LoadSys
3669 ADC2              ;
3670 ADC2              GotFont                                 ;
3671 ADC2              ;put important values where ScaleFont expects them:
3672 ADC2 A6 A6                 ldx   <bestSize
3673 ADC4 A4 AE                 ldy   <wantSize
3674 ADC6 A5 84                 lda   <progID
3675 ADC8              ;
3676 ADC8 22 4A C2 FC           jsl   ScaleFont
3677 ADCC 90 08                 bcc   ItsScaled
3678 ADCE              ;error:
3679 ADCE A6 BA                 ldx   <Err
3680 ADD0 D0 02                 bne   GotErr2                  ;save old error code, if there is one
3681 ADD2 85 BA                 sta   <Err                     ;o.w. keep this one
3682 ADD4              GotErr2                                 ;
3683 ADD4 80 36                 bra   LoadSys
3684 ADD6              ;
3685 ADD6              ItsScaled                               ;
3686 ADD6              ** Add this for now - experimental - BHM  9/17/87
3687 ADD6
3688 ADD6 85 28                 sta   <tempPtr                 ;font handle low word from ScaleFont
3689 ADD8              ** (just trust me on that one, folks)
3690 ADD8 A0 04 00              ldy   #4
3691 ADDB B7 A0                 lda   [<BestPtr],y             ;offset to fam name
3692 ADDD 85 B2                 sta   <matchLevel              ;temp. storage
3693 ADDF A0 08 00              ldy   #8
3694 ADE2 B7 A0                 lda   [<BestPtr],y             ;font stat bits
3695 ADE4 85 B4                 sta   <newLevel                ;temp. storage
3696 ADE6              ;
3697 ADE6              ****  the following added for FontForADay call - experimental
3698 ADE6              ;
3699 ADE6              ;the font was scaled, which means it didn't exist in the first place,
3700 ADE6              ;so we return an "oldStats" value with notFoundBit = 1 - and, in
3701 ADE6              ;theory, the rest undefined.  Out of politeness, though, we'll use put
3702 ADE6              ;in some reasonable values for the other bits.
3703 ADE6              ;
3704 ADE6 09 32 80              ora   #(notFoundBit+notDiskBit+purgeBit+unrealBit)
3705 ADE9 29 FE FF              and   #(notMemBit)
3706 ADEC              ;apFamBit and apVarBit inherited from original
3707 ADEC 85 8C                 sta   <oldStats
3708 ADEE              ;
3709 ADEE              ****  end of experimental FontForADay additions - BHM  x6245  12/16/87
3710 ADEE A5 28                 lda   <tempPtr
3711 ADF0              ;
3712 ADF0 22 A5 C1 FC           jsl   AddScaledFont            ;add it to lists, make it current
3713 ADF4 90 50                 bcc   OK
3714 ADF6 A6 BA                 ldx   <Err
3715 ADF8 D0 02                 bne   GotErr3                  ;save old error code
3716 ADFA 85 BA                 sta   <Err                     ;if none, save new one
3717 ADFC 80 0E        GotErr3  bra   LoadSys
3718 ADFE              ;
3719 ADFE              DontScale  
3720 ADFE              ;just install best fit:
3721 ADFE A9 FF FF              lda   #$FFFF
3722 AE01 20 6F B3              jsr   LoadTheFont
3723 AE04
3724 AE04 90 40                 bcc   OK
3725 AE06              ;
3726 AE06              *;;; Changed from ldx 5/6/87 - BHM: 
3727 AE06 A5 BA                 lda   <Err                     ;old error?
3728 AE08 D0 02                 bne   GotErr4                  ;then save it
3729 AE0A              *;;; Changed from sta 5/6/87 - BHM: 
3730 AE0A 86 BA                 stx   <Err                     ;o.w. save new error code
3731 AE0C              ;
3732 AE0C              GotErr4                                 ;on error, fall into . . .
3733 AE0C              ;
3734 AE0C              ****  END OF ADDITIONS - BHM  2/10/87
3735 AE0C              ;
3736 AE0C              LoadSys   
3737 AE0C              ;yeah, but which one?
3738 AE0C              ;
3739 AE0C A5 B0                 lda   WantFam
3740 AE0E C5 86                 cmp   <SysFontID               ;current system font family number
3741 AE10 D0 22                 bne   TrySysFontFam
3742 AE12              ;WantFam is already system font family:
3743 AE12              ;
3744 AE12 A5 88                 lda   <SysFontID+2
3745 AE14 29 FF 00              and   #$00FF                   ;system font style
3746 AE17 49 FF FF              eor   #$FFFF
3747 AE1A 05 AC                 ora   WantStyle
3748 AE1C C9 FF FF              cmp   #$FFFF
3749 AE1F F0 21                 beq   GoodSysStyle
3750 AE21              ;but the system font style does not partially match WantStyle -
3751 AE21              ;so force it to:
3752 AE21 A5 88                 lda   <SysFontID+2
3753 AE23 29 FF 00              and   #$00FF
3754 AE26 05 AC                 ora   WantStyle
3755 AE28 85 AC                 sta   WantStyle
3756 AE2A A3 0D                 lda   13,s
3757 AE2C 29 00 FF              and   #$FF00
3758 AE2F 85 AE                 sta   <WantSize                ;restored from possible xba
3759 AE31 82 5F FF              brl   TryAgain
3760 AE34              ;
3761 AE34              TrySysFontFam  
3762 AE34              ;no good WantFam font around - shift to system font family:
3763 AE34 A5 86                 lda   <SysFontID
3764 AE36 85 B0                 sta   WantFam
3765 AE38 A3 0D                 lda   13,s
3766 AE3A 29 00 FF              and   #$FF00
3767 AE3D 85 AE                 sta   <WantSize                ;restored from possible xba
3768 AE3F 82 51 FF              brl   TryAgain
3769 AE42              ;
3770 AE42              GoodSysStyle  
3771 AE42              ;WantFam is SysFontFam, and SysFontStyle partially matches WantStyle -
3772 AE42              ;I have no idea what's the matter, so let's do the simplist thing:
3773 AE42              ;
3774 AE42 22 7B AE FC           jsl   xLoadSysFont             ;make system font current
3775 AE46
3776 AE46 A3 0D        OK       lda   13,s                     ;get the requested font ID
3777 AE48 48                    pha   
3778 AE49 A3 0D                 lda   13,s
3779 AE4B 48                    pha   
3780 AE4C A2 04 D0 22           _SetFontID                     ;set the FontID field in the GrafPort
3781 AE53
3782 AE53 A3 0D                 lda   13,s
3783 AE55 29 FF 00              and   #$00FF                   ;get the requested font style
3784 AE58 48                    pha   
3785 AE59 A2 04 9A 22           _SetTextFace                   ;set text face field in the GrafPort
3786 AE60
3787 AE60 A3 0D                 lda   13,s
3788 AE62 29 00 FF              and   #$FF00                   ;get the requested font size
3789 AE65 EB                    xba   
3790 AE66 48                    pha   
3791 AE67 A2 04 D2 22           _SetTextSize                   ;set the text size field in the GrafPort
3792 AE6E
3793 AE6E 20 F2 C0              jsr   UnLockIDList
3794 AE71 A6 BA                 ldx   <Err                     ;get error flag
3795 AE73 F0 03                 beq   NoErr
3796 AE75 4C 9E C1              jmp   StdErr6                  ;report the error
3797 AE78
3798 AE78 4C 97 C1     NoErr    jmp   StdEnd6
3799 AE7B
3800 AE7B 7B           xLoadSysFont tdc   
3801 AE7C 22 D1 B1 FC           jsl   LoadSysFont
3802 AE80 6B                    rtl   
3803 AE81
3804 AE81              ;-------------------------------------------------------------------------------
3805 AE81
3806 AE81              FindBestFit                             ;
3807 AE81              ;
3808 AE81
3809 AE81 64 B6                 stz   <Count                   ;# of ID entries processed
3810 AE83 64 B2                 stz   <MatchLevel              ;size match level
3811 AE85 64 A4                 stz   <BestStyle               ;style byte of best fit so far
3812 AE87 64 A6                 stz   <BestSize                ;size byte of best fit so far
3813 AE89 64 A0                 stz   <BestPtr                 ;ptr to ID entry of best fit so far
3814 AE8B 64 A2                 stz   <BestPtr+2
3815 AE8D
3816 AE8D A7 30        IDLoop   lda   [<IDPtr]                 ;get fam #
3817 AE8F C5 B0                 cmp   WantFam                  ;match desired fam #?
3818 AE91 F0 03                 beq   FamMatch                 ;yes
3819 AE93 82 FA 00              brl   NextID                   ;no
3820 AE96
3821 AE96 A0 02 00     FamMatch ldy   #2
3822 AE99 B7 30                 lda   [<IDPtr],y
3823 AE9B 29 FF 00              and   #$00FF                   ;get style byte
3824 AE9E 85 A8                 sta   <IDStyle                 ;and save
3825 AEA0
3826 AEA0 A5 A8                 lda   <IDStyle                 ;is this font's style a subset of
3827 AEA2 05 AC                 ora   <WantStyle               ;the desired style ?
3828 AEA4 C5 AC                 cmp   <WantStyle
3829 AEA6 F0 03                 beq   StyleMatch               ;yes
3830 AEA8 82 E5 00              brl   NextID                   ;no
3831 AEAB
3832 AEAB B7 30        StyleMatch lda   [<IDPtr],y
3833 AEAD 29 00 FF              and   #$FF00                   ;get size byte
3834 AEB0 85 AA                 sta   <IDSize                  ;and save
3835 AEB2
3836 AEB2 A5 AA                 lda   <IDSize
3837 AEB4 C5 AE                 cmp   <WantSize                ;does font's size match desired size?
3838 AEB6 D0 05                 bne   WrongSize                ;no
3839 AEB8 A2 05 00              ldx   #5                       ;yes - so new match level is 5
3840 AEBB 80 59                 bra   Cont
3841 AEBD
3842 AEBD A5 B2        WrongSize lda   <MatchLevel             ;have we found correct size yet?
3843 AEBF C9 05 00              cmp   #5
3844 AEC2 D0 03                 bne   NoSizeMatch              ;no
3845 AEC4 82 C9 00              brl   NextID                   ;yes
3846 AEC7
3847 AEC7 A0 08 00     NoSizeMatch ldy   #8
3848 AECA B7 30                 lda   [<IDPtr],y               ;get info word
3849 AECC 29 02 00              and   #UnrealBit               ;is font real?
3850 AECF F0 03                 beq   CheckTwice               ;yes - so it's OK
3851 AED1 82 BC 00              brl   NextID                   ;no - so no good
3852 AED4
3853 AED4 A5 AA        CheckTwice lda   <IDSize
3854 AED6
3855 AED6 4A                    lsr   a                        ;divide font's size by 2
3856 AED7 89 80 00              bit   #$0080
3857 AEDA D0 09                 bne   CheckHalf                ;doesn't count if not an even size
3858 AEDC C5 AE                 cmp   <WantSize                ;is font's size twice as big as desired?
3859 AEDE D0 05                 bne   CheckHalf                ;no
3860 AEE0 A2 04 00              ldx   #4                       ;yes - so new match level is 4
3861 AEE3 80 31                 bra   Cont
3862 AEE5
3863 AEE5 A5 AA        CheckHalf lda   <IDSize
3864 AEE7 0A                    asl   a                        ;multiply font's size by 2
3865 AEE8 C5 AE                 cmp   <WantSize                ;is font's size half as big as desired?
3866 AEEA D0 05                 bne   CheckBigger              ;no
3867 AEEC A2 03 00              ldx   #3                       ;yes - so new match level is 3
3868 AEEF 80 25                 bra   Cont
3869 AEF1
3870 AEF1 A5 AA        CheckBigger lda   <IDSize
3871 AEF3 C5 AE                 cmp   <WantSize                ;is font's size > desired size?
3872 AEF5 90 10                 bcc   CheckSmaller             ;no
3873 AEF7 A2 02 00              ldx   #2                       ;yes - so new match level is 2
3874 AEFA E4 B2                 cpx   <MatchLevel              ;is current match level = 2 ?
3875 AEFC D0 18                 bne   Cont                     ;no
3876 AEFE A5 AA                 lda   <IDSize                  ;yes
3877 AF00 C5 A6                 cmp   <BestSize                ;is font's size < best size so far ?
3878 AF02 90 4D                 bcc   SaveIt                   ;yes - so it's a better match
3879 AF04 82 89 00              brl   NextID                   ;no - so no good
3880 AF07
3881 AF07 A2 01 00     CheckSmaller ldx   #1                   ;new match level is 1
3882 AF0A E4 B2                 cpx   <MatchLevel              ;is current match level = 1 ?
3883 AF0C D0 08                 bne   Cont                     ;no
3884 AF0E A5 AA                 lda   <IDSize                  ;yes
3885 AF10 C5 A6                 cmp   <BestSize                ;is font's size > best size so far ?
3886 AF12 B0 3D                 bcs   SaveIt                   ;yes - so it's a better match
3887 AF14 80 7A                 bra   NextID                   ;no - so no good
3888 AF16
3889 AF16 86 B4        Cont     stx   <NewLevel                ;save new match level
3890 AF18 A0 08 00              ldy   #8
3891 AF1B B7 30                 lda   [<IDPtr],y               ;get info word
3892 AF1D 29 20 00              and   #NotDiskBit              ;is font on disk?
3893 AF20 F0 05                 beq   CmpLevels                ;yes
3894 AF22 20 65 BF              jsr   CheckHandle              ;no - so check handle
3895 AF25 F0 69                 beq   NextID                   ;handle is nil - so font was purged
3896 AF27
3897 AF27 A6 B4        CmpLevels ldx   <NewLevel               ;get new match level and
3898 AF29 E4 B2                 cpx   <MatchLevel              ;compare it to best match level so far
3899 AF2B F0 06                 beq   SizeTie                  ;same  - so compare styles
3900 AF2D 90 61                 bcc   NextID                   ;smaller so no good
3901 AF2F 86 B2                 stx   <MatchLevel              ;save new match level as best match
3902 AF31 80 1E                 bra   SaveIt                   ;save this font as best so far
3903 AF33
3904 AF33              ;this font has same size as 'best so far', so compare their styles
3905 AF33
3906 AF33 A5 A4        SizeTie  lda   <BestStyle
3907 AF35 20 B0 AF              jsr   CountStyles              ;count # of styles set in best so far
3908 AF38 85 B8                 sta   <NumStyles               ;and save
3909 AF3A A5 A8                 lda   <IDStyle
3910 AF3C 20 B0 AF              jsr   CountStyles              ;count # of styles set in this font
3911 AF3F C5 B8                 cmp   <NumStyles               ;compare with # for best so far
3912 AF41 F0 04                 beq   StyleTie                 ;both fonts have same # styles set
3913 AF43 B0 0C                 bcs   SaveIt                   ;this font has more styles set than best
3914 AF45 80 49                 bra   NextID                   ;this font has less styles set than best
3915 AF47
3916 AF47              ;this font has same # of styles as 'best so far', so see if it's in memory
3917 AF47
3918 AF47 20 65 BF     StyleTie jsr   CheckHandle              ;do we have a handle to this font?
3919 AF4A F0 44                 beq   NextID                   ;no
3920 AF4C 20 75 BF              jsr   CheckNil                 ;yes - so check handle
3921 AF4F F0 3F                 beq   NextID                   ;handle is nil - so font was purged
3922 AF51
3923 AF51              ;this font is best so far
3924 AF51
3925 AF51 A0 02 00     SaveIt   ldy   #2
3926 AF54 B7 30                 lda   [<IDPtr],y               ;get style/size word
3927 AF56 C3 0F                 cmp   15,s                     ;match desired exactly?
3928 AF58              ;
3929 AF58              ****    KLUDGE FOLLOWS:
3930 AF58              ;
3931 AF58 D0 26                 bne   AroundDone
3932 AF5A              *****
3933 AF5A              * 6 December 88     SMD
3934 AF5A              * Fix bug where font got purged and was never reinstalled.  This happened
3935 AF5A              * because the handle wasn't checked to see if it  was still valid (font not purged).
3936 AF5A              *
3937 AF5A A0 08 00              ldy   #8
3938 AF5D B7 30                 lda   [<IDPtr],y               ;get info word to see if the font is on disk
3939 AF5F 29 20 00              and   #NotDiskBit              ;is font on disk?
3940 AF62 F0 0A                 beq   SI0010                   ;yes
3941 AF64              ;
3942 AF64              ; If font is not on the disk, it was derived... lets check it out...
3943 AF64 20 65 BF              jsr   CheckHandle              ;do we have a handle to this font?
3944 AF67 F0 27                 beq   NextID                   ;no
3945 AF69 20 75 BF              jsr   CheckNil                 ;yes - so check handle
3946 AF6C F0 22                 beq   NextID                   ;handle is nil - so font was purged
3947 AF6E              * end of bug fix
3948 AF6E              *****
3949 AF6E              *
3950 AF6E              * Fixed bug 1/16/89 Mensch
3951 AF6E              * Added label SI0010 and code above that branches to it so that installfont would
3952 AF6E              * no longer ignore disk based fonts that were not loaded.
3953 AF6E              *
3954 AF6E              SI0010    
3955 AF6E A5 30                 lda   <IDPtr                   ;save ptr to font
3956 AF70 85 A0                 sta   <BestPtr
3957 AF72 A5 32                 lda   <IDPtr+2
3958 AF74 85 A2                 sta   <BestPtr+2
3959 AF76 A5 A8                 lda   <IDStyle                 ;save font's style
3960 AF78 85 A4                 sta   <BestStyle
3961 AF7A A5 AA                 lda   <IDSize                  ;save font's size
3962 AF7C 85 A6                 sta   <BestSize
3963 AF7E 80 2C                 bra   Done
3964 AF80              AroundDone                              ;
3965 AF80              ;
3966 AF80              ****    END OF THIS KLUDGE - BHM  2/13/87
3967 AF80
3968 AF80 A5 30                 lda   <IDPtr                   ;save ptr to font
3969 AF82 85 A0                 sta   <BestPtr
3970 AF84 A5 32                 lda   <IDPtr+2
3971 AF86 85 A2                 sta   <BestPtr+2
3972 AF88 A5 A8                 lda   <IDStyle                 ;save font's style
3973 AF8A 85 A4                 sta   <BestStyle
3974 AF8C A5 AA                 lda   <IDSize                  ;save font's size
3975 AF8E 85 A6                 sta   <BestSize
3976 AF90
3977 AF90 20 8D C0     NextID   jsr   IncIDPtr                 ;point to next ID entry
3978 AF93 E6 B6                 inc   <Count
3979 AF95 A5 B6                 lda   <Count
3980 AF97 C5 68                 cmp   <IDCount                 ;at end of list?
3981 AF99 F0 03                 beq   RetBest                  ;yes
3982 AF9B 82 EF FE              brl   IDLoop
3983 AF9E
3984 AF9E A5 A0        RetBest  lda   <BestPtr
3985 AFA0 05 A2                 ora   <BestPtr+2               ;did we find a best fit?
3986 AFA2 F0 0A                 beq   NoBestFound              ;no
3987 AFA4 A5 A0                 lda   <BestPtr                 ;yes-set IDPtr to point to the best fit
3988 AFA6 85 30                 sta   <IDPtr
3989 AFA8 A5 A2                 lda   <BestPtr+2
3990 AFAA 85 32                 sta   <IDPtr+2
3991 AFAC 18           Done     clc                            ;return with carry clear
3992 AFAD 60                    rts   
3993 AFAE
3994 AFAE 38           NoBestFound sec                         ;return with carry set since
3995 AFAF 60                    rts                            ;system font is best fit
3996 AFB0
3997 AFB0              ;------------------------------------------------------------------------------
3998 AFB0
3999 AFB0 A0 00 00     CountStyles ldy   #0                    ;count of # of styles set
4000 AFB3 A2 08 00              ldx   #8                       ;# bits left to check
4001 AFB6 4A           Loop     lsr   a
4002 AFB7 90 01                 bcc   NotSet
4003 AFB9 C8                    iny   
4004 AFBA CA           NotSet   dex   
4005 AFBB D0 F9                 bne   Loop
4006 AFBD 98                    tya                            ;# of styles set
4007 AFBE 60                    rts   
4008 AFBF
4009 AFBF                       ENDP 
4010 AFBF
4011 AFBF
4012 AFBF              ****************************************************************
4013 AFBF              *
4014 AFBF              * SetPurgeStat
4015 AFBF              *
4016 AFBF              ****************************************************************
4017 AFBF
4018 AFBF                       ENTRY SetPurgeStat
4019 AFBF              SetPurgeStat PROC 
4020 AFBF
4021 AFBF              PurgeState equ   Temp
4022 AFBF
4023 AFBF 0B                    phd   
4024 AFC0 5B                    tcd   
4025 AFC1
4026 AFC1 A3 0B                 lda   11,s                     ;get fam #
4027 AFC3 A8                    tay   
4028 AFC4 A3 0D                 lda   13,s                     ;get style/size
4029 AFC6 20 7D BF              jsr   CheckFontID
4030 AFC9 90 03                 bcc   IDOK
4031 AFCB 4C 9E C1              jmp   StdErr6                  ;return error
4032 AFCE
4033 AFCE 83 0D        IDOK     sta   13,s                     ;save converted style/size
4034 AFD0 98                    tya   
4035 AFD1 83 0B                 sta   11,s                     ;save converted fam #
4036 AFD3
4037 AFD3 A3 09                 lda   9,s                      ;get purge setting
4038 AFD5 29 10 00              and   #PurgeBit                ;mask off other bits
4039 AFD8 85 A0                 sta   <PurgeState              ;and save
4040 AFDA
4041 AFDA 20 EC C0              jsr   LockIDList
4042 AFDD A2 00 00              ldx   #0                       ;# of ID entries processed
4043 AFE0 A0 02 00              ldy   #2
4044 AFE3
4045 AFE3 A7 30        Loop     lda   [<IDPtr]                 ;get fam #
4046 AFE5 C3 0B                 cmp   11,s                     ;match?
4047 AFE7 D0 06                 bne   NextID                   ;no
4048 AFE9 B7 30                 lda   [<IDPtr],y               ;get style/size
4049 AFEB C3 0D                 cmp   13,s                     ;match?
4050 AFED F0 0D                 beq   GotID                    ;yes
4051 AFEF 20 8D C0     NextID   jsr   IncIDPtr
4052 AFF2 E8                    inx   
4053 AFF3 E4 68                 cpx   <IDCount                 ;at end of list?
4054 AFF5 D0 EC                 bne   Loop                     ;no
4055 AFF7
4056 AFF7 A2 05 1B              ldx   #NoFontErr               ;yes - so didn't find ID
4057 AFFA 80 41                 bra   RetErr
4058 AFFC
4059 AFFC A5 A0        GotID    lda   <PurgeState              ;check purge setting
4060 AFFE F0 0B                 beq   Cont                     ;branch if setting is 'unpurgeable'
4061 B000 20 A6 BF              jsr   CheckSysFont             ;is this font the system font?
4062 B003 D0 06                 bne   Cont                     ;no - so OK
4063 B005 A2 07 1B              ldx   #PurgeErr                ;yes - can't purge the system font
4064 B008 4C 3D B0              jmp   RetErr
4065 B00B
4066 B00B 20 65 BF     Cont     jsr   CheckHandle              ;do we have a handle to this font?
4067 B00E F0 2A                 beq   NotInMem                 ;no - so error
4068 B010 20 75 BF              jsr   CheckNil                 ;is handle nil?
4069 B013 F0 25                 beq   NotInMem                 ;yes - so error
4070 B015
4071 B015 A0 08 00              ldy   #8
4072 B018 B7 30                 lda   [<IDPtr],y               ;get font info
4073 B01A 29 EF FF              and   #UnPurgeable             ;clear PurgeBit
4074 B01D 05 A0                 ora   <PurgeState              ;set correct purge state
4075 B01F 97 30                 sta   [<IDPtr],y               ;and save
4076 B021
4077 B021 A5 A0                 lda   <PurgeState
4078 B023 F0 03                 beq   PushLevel
4079 B025 A9 02 00              lda   #2
4080 B028 48           PushLevel pha                           ;purge level
4081 B029 D4 16 D4 14           PushZLong <FontHandle 
4082 B02D A2 02 24 22           _SetPurge                      ;set purge level of font
4083 B034
4084 B034 20 F2 C0              jsr   UnLockIDList
4085 B037 4C 97 C1              jmp   StdEnd6
4086 B03A
4087 B03A A2 06 1B     NotInMem ldx   #MemErr
4088 B03D DA           RetErr   phx                            ;save error code
4089 B03E 20 F2 C0              jsr   UnLockIDList             ;clean up
4090 B041 FA                    plx                            ;retrieve error code
4091 B042 4C 9E C1              jmp   StdErr6                  ;return the error
4092 B045                       ENDP 
4093 B045
4094 B045
4095 B045
4096 B045              ****************************************************************
4097 B045              *
4098 B045              * CountFonts
4099 B045              *
4100 B045              ****************************************************************
4101 B045
4102 B045                       ENTRY CountFonts
4103 B045              CountFonts PROC 
4104 B045
4105 B045              DontUse  equ   Temp                     ;these 2 bytes used by FindFontStats
4106 B045              FindPos  equ   DontUse+2
4107 B045              Count    equ   FindPos+2
4108 B045              WantStyle equ   Count+2
4109 B045              WantSize equ   WantStyle+2
4110 B045
4111 B045 0B                    phd   
4112 B046 5B                    tcd   
4113 B047
4114 B047 48                    pha                            ;push 8 bytes of garbage on stack
4115 B048 48                    pha                            ;so that params are at same offsets
4116 B049 48                    pha                            ;as params for FindFontStats and
4117 B04A 48                    pha                            ;LoadFont
4118 B04B
4119 B04B 20 EC C0              jsr   LockIDList
4120 B04E A9 FF FF              lda   #$FFFF                   ;count all fonts
4121 B051
4122 B051                       ENTRY CFCommon
4123 B051              CFCommon  
4124 B051 85 A2                 sta   <FindPos
4125 B053
4126 B053 A3 13                 lda   19,s                     ;get fam #
4127 B055 D0 0C                 bne   NotZero
4128 B057 A5 86                 lda   <SysFontID               ;convert fam # of 0 to system fam #
4129 B059 83 13                 sta   19,s
4130 B05B A3 15                 lda   21,s                     ;get style/size
4131 B05D D0 04                 bne   NotZero
4132 B05F A5 88                 lda   <SysFontID+2
4133 B061 83 15                 sta   21,s                     ;convert to system font's style/size
4134 B063
4135 B063 A3 11        NotZero  lda   17,s
4136 B065 29 04 00              and   #AnyFamBit               ;is fam # important?
4137 B068 D0 0D                 bne   OK1                      ;no - so don't care if illegal #
4138 B06A A3 13                 lda   19,s                     ;get fam #
4139 B06C C9 FF FF              cmp   #Illegal                 ;illegal #?
4140 B06F D0 06                 bne   OK1                      ;no
4141 B071 A2 08 1B              ldx   #FamNumErr
4142 B074 82 D4 00              brl   RetErr                   ;return error
4143 B077
4144 B077 A3 11        OK1      lda   17,s
4145 B079 29 10 00              and   #AnySizeBit              ;is size important?
4146 B07C D0 0D                 bne   OK2                      ;no - so don't care if illegal value
4147 B07E A3 15                 lda   21,s
4148 B080 29 00 FF              and   #$FF00                   ;get size
4149 B083 D0 06                 bne   OK2                      ;OK if not 0
4150 B085 A2 09 1B              ldx   #SizeErr
4151 B088 82 C0 00              brl   RetErr                   ;return error
4152 B08B
4153 B08B A3 15        OK2      lda   21,s
4154 B08D 29 FF 00              and   #$00FF                   ;get desired style
4155 B090 85 A6                 sta   <WantStyle               ;and save
4156 B092 A3 15                 lda   21,s
4157 B094 29 00 FF              and   #$FF00                   ;get desired size
4158 B097 85 A8                 sta   <WantSize                ;and save
4159 B099
4160 B099 64 A4                 stz   <Count
4161 B09B A2 00 00              ldx   #0                       ;# of ID entries processed
4162 B09E
4163 B09E 20 65 BF     IDLoop   jsr   CheckHandle              ;do we have a handle to this font?
4164 B0A1 F0 0F                 beq   MemBitOK                 ;no - so font was never in mem
4165 B0A3 20 75 BF              jsr   CheckNil                 ;check for nil handle
4166 B0A6 D0 0A                 bne   MemBitOK                 ;not nil - so font is still in mem
4167 B0A8 A0 08 00              ldy   #8                       ;handle is nil - so font was purged
4168 B0AB B7 30                 lda   [<IDPtr],y               ;get info word
4169 B0AD 29 FE FF              and   #NotMemBit               ;clear MemBit since font not in mem
4170 B0B0 97 30                 sta   [<IDPtr],y               ;and save
4171 B0B2
4172 B0B2 A0 08 00     MemBitOK ldy   #8
4173 B0B5 B7 30                 lda   [<IDPtr],y               ;get info word
4174 B0B7 29 20 00              and   #NotDiskBit              ;is font on disk?
4175 B0BA F0 07                 beq   FontOK                   ;yes - so OK
4176 B0BC B7 30                 lda   [<IDPtr],y               ;no - so font exists only in mem
4177 B0BE 29 01 00              and   #MemBit                  ;is font still in mem?
4178 B0C1 F0 66                 beq   NextID                   ;no - it's been purged so no good
4179 B0C3
4180 B0C3 A3 11        FontOK   lda   17,s
4181 B0C5 29 01 00              and   #MemOnlyBit              ;count only fonts in mem?
4182 B0C8 F0 0A                 beq   MemOK                    ;no
4183 B0CA A0 08 00              ldy   #8
4184 B0CD B7 30                 lda   [<IDPtr],y               ;get info word
4185 B0CF 29 01 00              and   #MemBit                  ;is font in mem?
4186 B0D2 F0 55                 beq   NextID                   ;no
4187 B0D4
4188 B0D4 A3 11        MemOK    lda   17,s
4189 B0D6 29 02 00              and   #RealOnlyBit             ;count only real fonts?
4190 B0D9 F0 0A                 beq   RealOK                   ;no
4191 B0DB A0 08 00              ldy   #8
4192 B0DE B7 30                 lda   [<IDPtr],y               ;get info word
4193 B0E0 29 02 00              and   #UnRealBit               ;is font real?
4194 B0E3 D0 44                 bne   NextID                   ;no
4195 B0E5
4196 B0E5 A3 11        RealOK   lda   17,s
4197 B0E7 29 04 00              and   #AnyFamBit               ;count any family?
4198 B0EA D0 06                 bne   FamOK                    ;yes
4199 B0EC A7 30                 lda   [<IDPtr]                 ;get fam #
4200 B0EE C3 13                 cmp   19,s                     ;match?
4201 B0F0 D0 37                 bne   NextID                   ;no
4202 B0F2
4203 B0F2 A3 11        FamOK    lda   17,s
4204 B0F4 29 10 00              and   #AnySizeBit              ;count any size?
4205 B0F7 D0 0C                 bne   SizeOK                   ;yes
4206 B0F9 A0 02 00              ldy   #2
4207 B0FC B7 30                 lda   [<IDPtr],y
4208 B0FE 29 00 FF              and   #$FF00                   ;get size
4209 B101 C5 A8                 cmp   <WantSize                ;match?
4210 B103 D0 24                 bne   NextID                   ;no
4211 B105
4212 B105 A0 02 00     SizeOK   ldy   #2
4213 B108 B7 30                 lda   [<IDPtr],y
4214 B10A 29 FF 00              and   #$00FF                   ;get style
4215 B10D A8                    tay                            ;save temporarily
4216 B10E 05 A6                 ora   <WantStyle
4217 B110 C5 A6                 cmp   <WantStyle               ;is it a subset of the desired style?
4218 B112 D0 15                 bne   NextID                   ;no
4219 B114 A3 11                 lda   17,s
4220 B116 29 08 00              and   #AnyStyleBit             ;count any style?
4221 B119 D0 04                 bne   StyleOK                  ;yes
4222 B11B C4 A6                 cpy   <WantStyle               ;match?
4223 B11D D0 0A                 bne   NextID                   ;no
4224 B11F
4225 B11F E6 A4        StyleOK  inc   <Count                   ;count this font
4226 B121 A5 A4                 lda   <Count
4227 B123 C5 A2                 cmp   <FindPos                 ;is this the font we are looking for?
4228 B125 D0 02                 bne   NextID                   ;no
4229 B127 18                    clc                            ;yes
4230 B128 60                    rts                            ;return to FindFontStats
4231 B129
4232 B129 20 8D C0     NextID   jsr   IncIDPtr
4233 B12C E8                    inx   
4234 B12D E4 68                 cpx   <IDCount                 ;at end of list?
4235 B12F F0 03                 beq   Done                     ;yes
4236 B131 82 6A FF              brl   IDLoop
4237 B134
4238 B134 A5 A2        Done     lda   <FindPos
4239 B136 C9 FF FF              cmp   #$FFFF                   ;called by FindFontStats?
4240 B139 F0 02                 beq   CountOK                  ;no
4241 B13B 38                    sec                            ;yes - so didn't find font
4242 B13C 60                    rts                            ;return to FindFontStats with error
4243 B13D
4244 B13D 20 F2 C0     CountOK  jsr   UnLockIDList
4245 B140 68                    pla                            ;clean garbage off stack
4246 B141 68                    pla   
4247 B142 68                    pla   
4248 B143 68                    pla   
4249 B144 A5 A4                 lda   <Count
4250 B146 83 0F                 sta   15,s                     ;return count
4251 B148 4C 97 C1              jmp   StdEnd6
4252 B14B
4253 B14B DA           RetErr   phx                            ;save error code
4254 B14C 20 F2 C0              jsr   UnLockIDList
4255 B14F FA                    plx                            ;retrieve error code
4256 B150 68                    pla                            ;pull return address off stack
4257 B151 A5 A2                 lda   <FindPos
4258 B153 C9 FF FF              cmp   #$FFFF                   ;called by FindFontStats?
4259 B156 F0 07                 beq   NotFFS                   ;no
4260 B158 A0 0C 00              ldy   #12                      ;param size
4261 B15B 5C B3 FC FE           jml   errout                   ;return error
4262 B15F
4263 B15F 68           NotFFS   pla                            ;pull garbage off stack
4264 B160 68                    pla   
4265 B161 68                    pla   
4266 B162 4C 9E C1              jmp   StdErr6                  ;return error
4267 B165                       ENDP 
4268 B165
4269 B165
4270 B165
4271 B165              ****************************************************************
4272 B165              *
4273 B165              * FindFontStats
4274 B165              *
4275 B165              *
4276 B165              * Change History
4277 B165              *
4278 B165              * 15 Jul 88         Steven Glass
4279 B165              *
4280 B165              * LoadTheFont trashes the d-page value TempPtr if the font is actually 
4281 B165              * loaded (not already in memory).  So we copy the pointer back off 
4282 B165              * the stack after calling LoadTheFont.
4283 B165              *
4284 B165              ****************************************************************
4285 B165
4286 B165                       ENTRY FindFontStats
4287 B165              FindFontStats PROC 
4288 B165
4289 B165              LoadFlag equ   Temp
4290 B165
4291 B165 0B                    phd   
4292 B166 5B                    tcd   
4293 B167 A9 00 00              lda   #0                       ;don't load the font
4294 B16A
4295 B16A                       ENTRY FFSCommon
4296 B16A              FFSCommon  
4297 B16A 85 A0                 sta   <LoadFlag
4298 B16C
4299 B16C A3 09                 lda   9,s                      ;get ptr to FontStatRec for output
4300 B16E 85 28                 sta   <TempPtr
4301 B170 A3 0B                 lda   11,s
4302 B172 85 2A                 sta   <TempPtr+2
4303 B174
4304 B174 20 EC C0              jsr   LockIDList
4305 B177
4306 B177 A3 0D                 lda   13,s                     ;position num to find
4307 B179 F0 05                 beq   NoFont                   ;illegal position num
4308 B17B 20 51 B0              jsr   CFCommon
4309 B17E 90 0A                 bcc   GotIt                    ;found the font
4310 B180 A9 00 80     NoFont   lda   #NotFoundBit
4311 B183 A0 04 00              ldy   #4
4312 B186 97 28                 sta   [<TempPtr],y             ;signal font not found
4313 B188 80 29                 bra   Done
4314 B18A
4315 B18A A5 A0        GotIt    lda   <LoadFlag                ;LoadFont call?
4316 B18C F0 08                 beq   RetInfo                  ;no
4317 B18E A9 FF FF              lda   #$FFFF
4318 B191 20 6F B3              jsr   LoadTheFont              ;yes - so load the font into mem and
4319 B194 B0 27                 bcs   RetErr                   ;make it the current font
4320 B196              RetInfo   
4321 B196              ;
4322 B196              ; Copy the pointer to the fontstats record back onto d-page
4323 B196              ; (May have been trashed by LoadTheFont)
4324 B196              ;
4325 B196 A3 09                 lda   9,s                      ;get ptr to FontStatRec for output
4326 B198 85 28                 sta   <TempPtr
4327 B19A A3 0B                 lda   11,s
4328 B19C 85 2A                 sta   <TempPtr+2
4329 B19E
4330 B19E A7 30                 lda   [<IDPtr]                 ;return font ID
4331 B1A0 87 28                 sta   [<TempPtr]
4332 B1A2 A0 02 00              ldy   #2
4333 B1A5 B7 30                 lda   [<IDPtr],y
4334 B1A7 97 28                 sta   [<TempPtr],y
4335 B1A9 A0 08 00              ldy   #8
4336 B1AC B7 30                 lda   [<IDPtr],y               ;get font info word
4337 B1AE A0 04 00              ldy   #4
4338 B1B1 97 28                 sta   [<TempPtr],y             ;and return
4339 B1B3
4340 B1B3 20 F2 C0     Done     jsr   UnLockIDList
4341 B1B6 A0 0C 00              ldy   #12                      ;param size
4342 B1B9 5C B0 FC FE           jml   endcall
4343 B1BD
4344 B1BD DA           RetErr   phx                            ;save error code
4345 B1BE 20 F2 C0              jsr   UnLockIDList             ;clean up
4346 B1C1 FA                    plx                            ;retrieve error code
4347 B1C2 A0 0C 00              ldy   #12                      ;param size
4348 B1C5 5C B3 FC FE           jml   errout                   ;report the error
4349 B1C9                       ENDP 
4350 B1C9
4351 B1C9
4352 B1C9
4353 B1C9              ****************************************************************
4354 B1C9              *
4355 B1C9              * LoadFont
4356 B1C9              *
4357 B1C9              ****************************************************************
4358 B1C9
4359 B1C9                       ENTRY LoadFont
4360 B1C9              LoadFont PROC 
4361 B1C9
4362 B1C9 0B                    phd   
4363 B1CA 5B                    tcd   
4364 B1CB A9 FF FF              lda   #$FFFF                   ;load the font
4365 B1CE 4C 6A B1              jmp   FFSCommon
4366 B1D1                       ENDP 
4367 B1D1
4368 B1D1
4369 B1D1
4370 B1D1              ****************************************************************
4371 B1D1              *
4372 B1D1              * LoadSysFont
4373 B1D1              *
4374 B1D1              ****************************************************************
4375 B1D1
4376 B1D1                       ENTRY LoadSysFont
4377 B1D1              LoadSysFont PROC 
4378 B1D1
4379 B1D1 0B                    phd   
4380 B1D2 5B                    tcd   
4381 B1D3
4382 B1D3 20 EC C0              jsr   LockIDList
4383 B1D6
4384 B1D6 20 A6 BF     Loop     jsr   CheckSysFont             ;is this font the system font?
4385 B1D9 F0 05                 beq   FoundIt                  ;yes
4386 B1DB 20 8D C0              jsr   IncIDPtr                 ;no - so check next ID entry
4387 B1DE 80 F6                 bra   Loop
4388 B1E0
4389 B1E0 A9 FF FF     FoundIt  lda   #$FFFF
4390 B1E3 20 6F B3              jsr   LoadTheFont              ;make system font the current font
4391 B1E6 20 F2 C0              jsr   UnLockIDList
4392 B1E9
4393 B1E9 A0 00 00              ldy   #0                       ;param size
4394 B1EC 5C B0 FC FE           jml   endcall
4395 B1F0                       ENDP 
4396 B1F0
4397 B1F0
4398 B1F0
4399 B1F0              ****************************************************************
4400 B1F0              *
4401 B1F0              * AddFontVar
4402 B1F0              *
4403 B1F0              ****************************************************************
4404 B1F0
4405 B1F0                       ENTRY AddFontVar
4406 B1F0              AddFontVar PROC 
4407 B1F0
4408 B1F0              NewStats equ   Temp
4409 B1F0              NewIDSize equ   NewStats+2
4410 B1F0
4411 B1F0 0B                    phd   
4412 B1F1 5B                    tcd   
4413 B1F2
4414 B1F2 A3 09                 lda   9,s                      ;get new stats input for font
4415 B1F4 29 02 00              and   #UnrealBit               ;mask off all bits except UnrealBit
4416 B1F7 85 A0                 sta   <NewStats                ;and save for later
4417 B1F9
4418 B1F9 A3 0B                 lda   11,s                     ;get handle to font
4419 B1FB 85 14                 sta   <FontHandle
4420 B1FD A3 0D                 lda   13,s
4421 B1FF 85 16                 sta   <FontHandle+2
4422 B201 20 15 C1              jsr   LockFont
4423 B204
4424 B204 20 F8 C0              jsr   LockFamList
4425 B207 A2 00 00              ldx   #0                       ;# of fam entries checked
4426 B20A A0 02 00              ldy   #2
4427 B20D A7 34        FamLoop  lda   [<FamPtr]                ;get fam #
4428 B20F D7 3C                 cmp   [<FontPtr],y             ;does it match font's fam #?
4429 B211 F0 14                 beq   GotFam                   ;yes
4430 B213 20 9D C0              jsr   IncFamPtr                ;no - so check next fam entry
4431 B216 E8                    inx   
4432 B217 E4 6A                 cpx   <FamCount                ;at end of list?
4433 B219 D0 F2                 bne   FamLoop                  ;no
4434 B21B
4435 B21B 20 1B C1              jsr   UnLockFont               ;yes
4436 B21E 20 FE C0              jsr   UnLockFamList
4437 B221 A2 04 1B              ldx   #NoFamErr
4438 B224 4C 9E C1              jmp   StdErr6                  ;return the error
4439 B227
4440 B227 A5 60        GotFam   lda   <IDListSize              ;get current size of ID list
4441 B229 18                    clc   
4442 B22A 69 0E 00              adc   #14                      ;add size of new entry
4443 B22D 85 A2                 sta   <NewIDSize               ;and save
4444 B22F
4445 B22F F4 00 00              PushWord #0                    ;hi word of size
4446 B232 48                    pha                            ;lo word of size
4447 B233 D4 0A D4 08           PushZLong <IDHandle            ;handle to list
4448 B237 A2 02 19 22           _SetHandleSize                 ;grow the list
4449 B23E 90 0B                 bcc   OK
4450 B240 48                    pha                            ;save error code
4451 B241 20 1B C1              jsr   UnLockFont               ;clean up
4452 B244 20 FE C0              jsr   UnLockFamList
4453 B247 FA                    plx                            ;retrieve error code
4454 B248 4C 9E C1              jmp   StdErr6                  ;report the error
4455 B24B
4456 B24B 20 EC C0     OK       jsr   LockIDList
4457 B24E
4458 B24E 18                    clc   
4459 B24F A5 30                 lda   <IDPtr                   ;create ptr to new ID entry
4460 B251 65 60                 adc   <IDListSize
4461 B253 85 30                 sta   <IDPtr
4462 B255 A5 32                 lda   <IDPtr+2
4463 B257 69 00 00              adc   #0
4464 B25A 85 32                 sta   <IDPtr+2
4465 B25C
4466 B25C A0 04 00              ldy   #4
4467 B25F B7 3C                 lda   [<FontPtr],y             ;get font's style word
4468 B261 29 FF 00              and   #$00FF                   ;mask off hi byte
4469 B264 48                    pha                            ;save on stack
4470 B265 C8                    iny   
4471 B266 C8                    iny   
4472 B267 B7 3C                 lda   [<FontPtr],y             ;get font's size word
4473 B269 29 FF 00              and   #$00FF                   ;mask off hi byte
4474 B26C EB                    xba                            ;swap bytes
4475 B26D 03 01                 ora   1,s                      ;OR with style word
4476 B26F 7A                    ply                            ;clean up
4477 B270
4478 B270 A0 02 00              ldy   #2
4479 B273 97 30                 sta   [<IDPtr],y               ;save style/size word in new ID entry
4480 B275 A7 34                 lda   [<FamPtr]                ;get fam #
4481 B277 87 30                 sta   [<IDPtr]                 ;and save in new ID entry
4482 B279 B7 34                 lda   [<FamPtr],y              ;get offset to famname entry
4483 B27B C8                    iny   
4484 B27C C8                    iny   
4485 B27D 97 30                 sta   [<IDPtr],y               ;and save in new ID entry
4486 B27F
4487 B27F A9 00 00              lda   #0
4488 B282 C8                    iny   
4489 B283 C8                    iny   
4490 B284 97 30                 sta   [<IDPtr],y               ;set filename offset to 0
4491 B286
4492 B286 A0 04 00              ldy   #4
4493 B289 B7 34                 lda   [<FamPtr],y              ;get fam info word
4494 B28B 29 04 00              and   #ApFamBit                ;mask off all bits except ApFamBit
4495 B28E 09 08 00              ora   #ApVarBit                ;set ApVarBit
4496 B291 09 01 00              ora   #MemBit                  ;set MemBit
4497 B294 09 20 00              ora   #NotDiskBit              ;set NotDiskBit
4498 B297 05 A0                 ora   <NewStats                ;OR with NewStats
4499 B299 A0 08 00              ldy   #8
4500 B29C 97 30                 sta   [<IDPtr],y               ;and save in new ID entry
4501 B29E
4502 B29E C8                    iny   
4503 B29F C8                    iny   
4504 B2A0 A3 0B                 lda   11,s                     ;get font handle
4505 B2A2 97 30                 sta   [<IDPtr],y               ;and save in new ID entry
4506 B2A4 C8                    iny   
4507 B2A5 C8                    iny   
4508 B2A6 A3 0D                 lda   13,s
4509 B2A8 97 30                 sta   [<IDPtr],y
4510 B2AA
4511 B2AA A5 A2                 lda   <NewIDSize               ;get new size of ID list
4512 B2AC 85 60                 sta   <IDListSize              ;and save
4513 B2AE E6 68                 inc   <IDCount                 ;inc # of ID entries
4514 B2B0
4515 B2B0 F4 00 00              Pushword #0 
4516 B2B3 D4 16 D4 14           PushZLong <FontHandle 
4517 B2B7 A2 02 24 22           _SetPurge                      ;make font unpurgeable
4518 B2BE
4519 B2BE 20 17 C0              jsr   MakeCurrent              ;make new font the current font
4520 B2C1
4521 B2C1 20 1B C1              jsr   UnLockFont
4522 B2C4 20 F2 C0              jsr   UnLockIDList
4523 B2C7 20 FE C0              jsr   UnLockFamList
4524 B2CA 4C 97 C1              jmp   StdEnd6
4525 B2CD                       ENDP 
4526 B2CD
4527 B2CD
4528 B2CD
4529 B2CD              ****************************************************************
4530 B2CD              *
4531 B2CD              * FMSetSysFont
4532 B2CD              *
4533 B2CD              ****************************************************************
4534 B2CD
4535 B2CD                       ENTRY FMSetSysFont
4536 B2CD              FMSetSysFont PROC 
4537 B2CD
4538 B2CD 0B                    phd   
4539 B2CE 5B                    tcd   
4540 B2CF
4541 B2CF A3 09                 lda   9,s                      ;get fam #
4542 B2D1 A8                    tay   
4543 B2D2 A3 0B                 lda   11,s                     ;get style/size
4544 B2D4 20 7D BF              jsr   CheckFontID
4545 B2D7 90 03                 bcc   IDOK
4546 B2D9 4C 90 C1              jmp   StdErr4                  ;return error
4547 B2DC
4548 B2DC 83 0B        IDOK     sta   11,s                     ;save converted style/size
4549 B2DE 98                    tya   
4550 B2DF 83 09                 sta   9,s                      ;save converted fam #
4551 B2E1
4552 B2E1 20 EC C0              jsr   LockIDList
4553 B2E4 A2 00 00              ldx   #0
4554 B2E7 A0 02 00              ldy   #2
4555 B2EA
4556 B2EA A7 30        Loop     lda   [<IDPtr]                 ;get fam #
4557 B2EC C3 09                 cmp   9,s                      ;match?
4558 B2EE D0 06                 bne   NextID                   ;no
4559 B2F0 B7 30                 lda   [<IDPtr],y               ;get style/size
4560 B2F2 C3 0B                 cmp   11,s                     ;match?
4561 B2F4 F0 11                 beq   FoundIt                  ;yes
4562 B2F6 20 8D C0     NextID   jsr   IncIDPtr                 ;no - so check next entry
4563 B2F9 E8                    inx   
4564 B2FA E4 68                 cpx   <IDCount                 ;done with list?
4565 B2FC D0 EC                 bne   Loop                     ;no
4566 B2FE 20 F2 C0              jsr   UnLockIDList             ;yes - so didn't find font
4567 B301 A2 05 1B              ldx   #NoFontErr
4568 B304 4C 90 C1              jmp   StdErr4                  ;return the error
4569 B307
4570 B307 A9 FE FF     FoundIt  lda   #notCurrFlag
4571 B30A 20 6F B3              jsr   LoadTheFont              ;load the font, don't make current
4572 B30D 90 03                 bcc   OK
4573 B30F 4C 90 C1              jmp   StdErr4                  ;return the error
4574 B312
4575 B312 A3 09        OK       lda   9,s                      ;get fontID of new system font
4576 B314 85 86                 sta   <SysFontID               ;and save
4577 B316 A3 0B                 lda   11,s
4578 B318 85 88                 sta   <SysFontID+2
4579 B31A
4580 B31A D4 16 D4 14           PushZLong <FontHandle 
4581 B31E A2 04 B2 22           _SetSysFont                    ;tell QuickDraw about new sys font
4582 B325
4583 B325 20 F2 C0              jsr   UnLockIDList
4584 B328 4C 89 C1              jmp   StdEnd4
4585 B32B                       ENDP 
4586 B32B
4587 B32B
4588 B32B
4589 B32B              ****************************************************************
4590 B32B              *
4591 B32B              * FMGetSysFID
4592 B32B              *
4593 B32B              ****************************************************************
4594 B32B
4595 B32B                       ENTRY FMGetSysFID
4596 B32B              FMGetSysFID PROC 
4597 B32B
4598 B32B 0B                    phd   
4599 B32C 5B                    tcd   
4600 B32D
4601 B32D A5 86                 lda   <SysFontID               ;return font ID of system font
4602 B32F 83 09                 sta   9,s
4603 B331 A5 88                 lda   <SysFontID+2
4604 B333 83 0B                 sta   11,s
4605 B335 A0 00 00              ldy   #0                       ;param size
4606 B338 5C B0 FC FE           jml   endcall
4607 B33C                       ENDP 
4608 B33C
4609 B33C
4610 B33C
4611 B33C              ****************************************************************
4612 B33C              *
4613 B33C              * FMGetCurFID
4614 B33C              *
4615 B33C              ****************************************************************
4616 B33C
4617 B33C                       ENTRY FMGetCurFID
4618 B33C              FMGetCurFID PROC 
4619 B33C
4620 B33C              FontInfo equ   Temp                     ;the following items MUST appear
4621 B33C              FamNum   equ   FontInfo                 ;in this order
4622 B33C              Style    equ   FamNum+2
4623 B33C              Size     equ   Style+2
4624 B33C
4625 B33C 0B                    phd   
4626 B33D 5B                    tcd   
4627 B33E
4628 B33E 48                    pha                            ;space for result
4629 B33F F4 00 00 7B           PushZPtr <FontInfo             ;ptr to buffer for results
4630 B348 F4 06 00              PushWord #6                    ;# bytes to return
4631 B34B A2 04 D9 22           _GetFontLore                   ;get info about current font
4632 B352 68                    pla                            ;ignore result
4633 B353
4634 B353 A5 A0                 lda   <FamNum                  ;get font's fam #
4635 B355 83 09                 sta   9,s                      ;and return
4636 B357 A5 A4                 lda   <Size                    ;get font's size
4637 B359 29 FF 00              and   #$00FF                   ;mask off hi byte
4638 B35C EB                    xba                            ;swap bytes
4639 B35D 85 A4                 sta   <Size                    ;and save
4640 B35F A5 A2                 lda   <Style                   ;get font's style
4641 B361 29 FF 00              and   #$00FF                   ;mask off hi byte
4642 B364 05 A4                 ora   <Size                    ;OR with size
4643 B366 83 0B                 sta   11,s                     ;and return
4644 B368
4645 B368 A0 00 00              ldy   #0                       ;param size
4646 B36B 5C B0 FC FE           jml   endcall
4647 B36F                       ENDP 
4648 B36F
4649 B36F
4650 B36F              ****************************************************************
4651 B36F              *
4652 B36F              * LoadTheFont
4653 B36F              *
4654 B36F              ****************************************************************
4655 B36F
4656 B36F              ***************************************
4657 B36F              *                                     *
4658 B36F              *  11/12/87  2:35 pm                  *
4659 B36F              *                                     *
4660 B36F              ***************************************
4661 B36F
4662 B36F              ***************************************************************
4663 B36F              *
4664 B36F              *  MakeCurFlag renamed loadFlags, several control bits added
4665 B36F              *  for use with font scaling:
4666 B36F              *
4667 B36F              *  bit 0:  currFlag
4668 B36F              *          0:  don't make font current
4669 B36F              *          1:  make font current
4670 B36F              *  bit 1:  newMemFlag
4671 B36F              *          0:  make newly-loaded-in font purgeable
4672 B36F              *          1:  make it unpurgeable
4673 B36F              *  bit 2:  oldMemFlag
4674 B36F              *          0:  make font found in memory purgeable
4675 B36F              *          1:  leave its purge status alone
4676 B36F              *
4677 B36F              *    Bennet Marks  x6245  2/10/87
4678 B36F              *
4679 B36F              *  NOTE/WARNING:  this routine leaves the loaded font unlocked.
4680 B36F              *  In the case of scaling, it may also leave it purgeable.  Any
4681 B36F              *  calling routine should be sure it doesn't let the font get
4682 B36F              *  purged accidentally before it uses it. - BHM  x6245  6/15/87
4683 B36F              *
4684 B36F              *   Input: A
4685 B36F              *  Output: Carry flag
4686 B36F              *
4687 B36F              ***************************************************************
4688 B36F                       ENTRY LoadTheFont
4689 B36F              LoadTheFont PROC 
4690 B36F                       INCLUDE 'SomeFMEqus'           ;added 2/12/87 - BHM
4691 B36F
4692 B36F 85 C2                 sta   <loadFlags
4693 B371
4694 B371 20 65 BF              jsr   CheckHandle              ;do we have a handle to this font?
4695 B374 F0 21                 beq   NotInMem                 ;no - so load font in from disk
4696 B376 20 75 BF              jsr   CheckNil                 ;yes - so check if handle is nil
4697 B379 F0 05                 beq   ItsPurged                ;it's nil - so font was purged
4698 B37B 20 15 C1              jsr   LockFont                 ;not nil - so font is in memory
4699 B37E 80 73                 bra   InMem
4700 B380
4701 B380              ;font was in memory but has been purged
4702 B380
4703 B380 20 3C B4     ItsPurged jsr   GetSizes                ;open font file, get size info
4704 B383 90 01                 bcc   OK1
4705 B385 60                    rts                            ;return error to calling routine
4706 B386
4707 B386 D4 16 D4 14  OK1      PushZLong <FontHandle 
4708 B38A A2 02 0B 22           _RestoreHandle                 ;restore the font handle
4709 B391 90 22                 bcc   LoadIt                   ;load the font into mem
4710 B393 AA                    tax                            ;transfer error code to X
4711 B394 82 9E 00              brl   GotErr2
4712 B397
4713 B397              ;font was never in memory
4714 B397
4715 B397 20 3C B4     NotInMem jsr   GetSizes                 ;open font file, get size info
4716 B39A 90 01                 bcc   OK2
4717 B39C 60                    rts                            ;return error to calling routine
4718 B39D
4719 B39D A5 BE        OK2      lda   <FontSize                ;size of font in bytes
4720 B39F 20 49 BF              jsr   GetHandle                ;allocate space for the font in mem
4721 B3A2 90 03                 bcc   GotHandle
4722 B3A4 82 8E 00              brl   GotErr2
4723 B3A7
4724 B3A7 A0 0A 00     GotHandle ldy   #10
4725 B3AA 85 14                 sta   <FontHandle
4726 B3AC 97 30                 sta   [<IDPtr],y               ;save handle to font in ID entry
4727 B3AE C8                    iny   
4728 B3AF C8                    iny   
4729 B3B0 8A                    txa   
4730 B3B1 85 16                 sta   <FontHandle+2
4731 B3B3 97 30                 sta   [<IDPtr],y
4732 B3B5
4733 B3B5              ;load font into memory from disk
4734 B3B5
4735 B3B5 20 15 C1     LoadIt   jsr   LockFont                 ;font file is open at this point
4736 B3B8 A5 3C                 lda   <FontPtr
4737 B3BA 85 6E                 sta   <ReadPtr                 ;copy ptr to font area into READ params
4738 B3BC A5 3E                 lda   <FontPtr+2
4739 B3BE 85 70                 sta   <ReadPtr+2
4740 B3C0
4741 B3C0 A5 BE                 lda   <FontSize
4742 B3C2 85 72                 sta   <ReadSize                ;# of bytes to read
4743 B3C4 64 74                 stz   <ReadSize+2
4744 B3C6 20 D1 BE              jsr   ReadFile                 ;load the font into memory
4745 B3C9 B0 5D                 bcs   GotErr
4746 B3CB
4747 B3CB 20 F5 BE              jsr   CloseFile                ;close the font file
4748 B3CE B0 58                 bcs   GotErr
4749 B3D0              ;
4750 B3D0              ****  ALTERATIONS DONE TO HELP WITH FONT SCALING:
4751 B3D0              ;
4752 B3D0              ;font just brought into memory:
4753 B3D0 A5 C2                 lda   loadFlags
4754 B3D2 29 02 00              and   #newMemFlag
4755 B3D5 D0 23                 bne   MakeUnprgable
4756 B3D7              ;
4757 B3D7              ;make it purgeable:
4758 B3D7 A0 08 00              ldy   #8
4759 B3DA B7 30                 lda   [<IDPtr],y
4760 B3DC              ****  added for FontForADay - experimental - BHM  x6245  12/16/87
4761 B3DC 85 8C                 sta   <oldStats
4762 B3DE
4763 B3DE 09 11 00              ora   #(PurgeBit+MemBit)       ;set purge and mem bits in list
4764 B3E1 97 30                 sta   [<IDPtr],y
4765 B3E3
4766 B3E3 F4 02 00              PushWord #2 
4767 B3E6 D4 16 D4 14           PushZLong <FontHandle 
4768 B3EA A2 02 24 22           _SetPurge                      ;and make the font purgeable
4769 B3F1 80 26                 bra   PurgeStatDone
4770 B3F3
4771 B3F3              InMem     
4772 B3F3              ;font was already in memory:
4773 B3F3 A5 C2                 lda   loadFlags
4774 B3F5 29 04 00              and   #oldMemFlag
4775 B3F8 F0 1F                 beq   KeepPurgeStat            ;leave purge status alone
4776 B3FA              ;
4777 B3FA              ;otherwise, make it unpurgeable:
4778 B3FA A0 08 00     MakeUnprgable ldy   #8
4779 B3FD B7 30                 lda   [<IDPtr],y               ;set mem bit, reset purge bit
4780 B3FF              ****  added for FontForADay - experimental - BHM  x6245  12/16/87
4781 B3FF 85 8C                 sta   <oldStats
4782 B401
4783 B401 29 EF FF              and   #Unpurgeable
4784 B404 09 01 00              ora   #MemBit
4785 B407 97 30                 sta   [<IDPtr],y
4786 B409
4787 B409 F4 00 00              PushWord #0 
4788 B40C D4 16 D4 14           PushZLong <FontHandle 
4789 B410 A2 02 24 22           _SetPurge                      ;and make the font unpurgeable
4790 B417 80 00                 bra   PurgeStatDone
4791 B419
4792 B419              PurgeStatDone  
4793 B419              KeepPurgeStat  
4794 B419
4795 B419 A5 C2                 lda   <loadFlags
4796 B41B 29 01 00              and   #currFlag                ;make the font current?
4797 B41E              ****  END OF ALTERATIONS - BHM  2/10/87
4798 B41E
4799 B41E F0 03                 beq   Done                     ;no
4800 B420 20 17 C0              jsr   MakeCurrent              ;yes
4801 B423 20 1B C1     Done     jsr   UnLockFont
4802 B426 18                    clc   
4803 B427 60                    rts   
4804 B428
4805 B428 DA           GotErr   phx                            ;save error code
4806 B429 D4 16 D4 14           PushZLong <FontHandle 
4807 B42D A2 02 10 22           _DisposeHandle                 ;dispose of handle and font
4808 B434 FA                    plx                            ;retrieve error code
4809 B435
4810 B435 DA           GotErr2  phx                            ;save error code
4811 B436 20 F5 BE              jsr   CloseFile                ;clean up
4812 B439 FA                    plx                            ;retrieve error code
4813 B43A 38                    sec   
4814 B43B 60                    rts                            ;return to calling routine
4815 B43C
4816 B43C              ;-------------------------------------------------------------------------------
4817 B43C
4818 B43C              GetSizes  
4819 B43C              ****changed to use FMParams block - BHM  x6245  11/12/87
4820 B43C
4821 B43C 20 45 C1              jsr   LockFMParams
4822 B43F
4823 B43F 20 E0 C0              jsr   LockFileList
4824 B442 A0 06 00              ldy   #6
4825 B445 18                    clc   
4826 B446 B7 30                 lda   [<IDPtr],y               ;get offset to filename entry
4827 B448 65 2C                 adc   <FilePtr                 ;and create ptr to filename entry
4828 B44A 85 2C                 sta   <FilePtr
4829 B44C A5 2E                 lda   <FilePtr+2
4830 B44E 69 00 00              adc   #0
4831 B451 85 2E                 sta   <FilePtr+2
4832 B453
4833 B453 20 D9 BF              jsr   CopyFileName             ;copy file name into pathname string
4834 B456
4835 B456 A5 4C                 lda   <FMParamPtr
4836 B458 18                    clc   
4837 B459 69 44 00              adc   #(DirName-FMParams)
4838 B45C 85 6E                 sta   <OpenPtr                 ;store ptr to pathname of font file
4839 B45E A5 4E                 lda   <FMParamPtr+2            ;in OPEN params
4840 B460 69 00 00              adc   #0
4841 B463 85 70                 sta   <OpenPtr+2
4842 B465
4843 B465 20 BF BE              jsr   OpenFile                 ;open the font file
4844 B468 90 09                 bcc   OpenOK
4845 B46A DA                    phx                            ;save error code
4846 B46B 20 E6 C0              jsr   UnLockFileList           ;clean up
4847 B46E 20 4B C1              jsr   UnlockFMParams
4848 B471 FA                    plx                            ;retrieve error code
4849 B472 60                    rts                            ;return the error
4850 B473
4851 B473 20 E6 C0     OpenOK   jsr   UnLockFileList
4852 B476 20 4B C1              jsr   UnlockFMParams
4853 B479
4854 B479 20 19 BF              jsr   GetEOF                   ;get size of font file
4855 B47C
4856 B47C A5 6E                 lda   <EOFSize                 ;might get trampled by READ call
4857 B47E 85 C4                 sta   <currEOFSize             ;but not here
4858 B480 B0 4C                 bcs   RetErr
4859 B482
4860 B482 20 04 C1              jsr   LockNameList
4861 B485 A0 04 00              ldy   #4
4862 B488 B7 30                 lda   [<IDPtr],y               ;get offset to famname
4863 B48A A8                    tay   
4864 B48B B7 38                 lda   [<NamePtr],y             ;get length of famname
4865 B48D 29 FF 00              and   #$00FF                   ;mask off hi byte
4866 B490 1A                    inc   a                        ;add 1 for the length byte itself
4867 B491 85 C0                 sta   <NameSize                ;save for later
4868 B493 20 0A C1              jsr   UnLockNameList
4869 B496
4870 B496 A5 C0                 lda   <NameSize
4871 B498 C9 1A 00              cmp   #MaxNameLen+1            ;is name length = max name length?
4872 B49B D0 1D                 bne   GotNameLen               ;no - so we have the correct length
4873 B49D              ;
4874 B49D              ;we are about to read the font file's first 2 bytes into the
4875 B49D              ;0-page location NameSize  (it's weird, but what the hey?)
4876 B49D              ;(changed from an even weirder form 11/12/87 - BHM  x6245)
4877 B49D
4878 B49D 7B                    tdc   
4879 B49E 18                    clc   
4880 B49F 69 C0 00              adc   #NameSize
4881 B4A2 85 6E                 sta   <ReadPtr                 ;point to that 0-page location
4882 B4A4 64 70                 stz   <ReadPtr+2               ;high word 0, of course
4883 B4A6 A9 02 00              lda   #2                       ;# bytes to read
4884 B4A9 85 72                 sta   <ReadSize
4885 B4AB 64 74                 stz   <ReadSize+2
4886 B4AD 20 D1 BE              jsr   ReadFile                 ;read first word of font file
4887 B4B0 B0 1C                 bcs   RetErr
4888 B4B2
4889 B4B2 A5 C0                 lda   <NameSize                ;get name length
4890 B4B4 29 FF 00              and   #$00FF                   ;mask off hi byte
4891 B4B7 1A                    inc   a                        ;add 1 for length byte itself
4892 B4B8 85 C0                 sta   <NameSize                ;and save
4893 B4BA
4894 B4BA 38           GotNameLen sec   
4895 B4BB A5 C4                 lda   <currEofSize
4896 B4BD E5 C0                 sbc   <NameSize                ;calculate size of the font file not
4897 B4BF 85 BE                 sta   <FontSize                ;including the famname
4898 B4C1 A5 C0                 lda   <NameSize
4899 B4C3 85 6E                 sta   <MarkLoc
4900 B4C5 64 70                 stz   <MarkLoc+2
4901 B4C7 20 07 BF              jsr   SetMark                  ;set current position of file to start
4902 B4CA B0 02                 bcs   RetErr                   ;of font
4903 B4CC
4904 B4CC 18                    clc   
4905 B4CD 60                    rts   
4906 B4CE
4907 B4CE DA           RetErr   phx                            ;save error code
4908 B4CF 20 F5 BE              jsr   CloseFile                ;clean up
4909 B4D2 FA                    plx                            ;retrieve error code
4910 B4D3 38                    sec   
4911 B4D4 60                    rts   
4912 B4D5                       ENDP 
4913 B4D5
4914 B4D5
4915 B4D5              ****************************************************************
4916 B4D5              *
4917 B4D5              * InstallWithStats
4918 B4D5              *
4919 B4D5              *    (name changed from FontForADay 1/4/88 - BHM  x6245
4920 B4D5              *
4921 B4D5              ****************************************************************
4922 B4D5              ;
4923 B4D5              ***************************************
4924 B4D5              *                                     *
4925 B4D5              *  1/4/88 3:45 pm                     *
4926 B4D5              *                                     *
4927 B4D5              ***************************************
4928 B4D5              ;
4929 B4D5              ***************************************************************
4930 B4D5              *
4931 B4D5              *  This call combines features of InstallFont and FindFontStats.
4932 B4D5              *  It does a normal InstallFont, but it also returns a FontStatRec
4933 B4D5              *  reflecting the status that the font that is installed (the font
4934 B4D5              *  ACTUALLY installed - not necessarily the font asked for) had
4935 B4D5              *  BEFORE this call was made.  It is intended to be used for saving
4936 B4D5              *  and restoring the status of a font (particularly its purge status)
4937 B4D5              *
4938 B4D5              *  Bennet Marks  x6245
4939 B4D5              *
4940 B4D5              ***************************************************************
4941 B4D5              ;
4942 B4D5                       ENTRY InstallWithStats
4943 B4D5              InstallWithStats PROC                   ;my longest label!
4944 B4D5              ;
4945 B4D5              FontInfo equ   Temp
4946 B4D5              FamNum   equ   FontInfo
4947 B4D5              Style    equ   FamNum+2
4948 B4D5              Size     equ   Style+2
4949 B4D5              ErrCode1 equ   Size+2
4950 B4D5              ;
4951 B4D5 0B                    phd   
4952 B4D6 5B                    tcd   
4953 B4D7              ;
4954 B4D7 A3 0D                 lda   13,s                     ;scaleWord
4955 B4D9 AA                    tax   
4956 B4DA A3 0F                 lda   15,s                     ;famNum
4957 B4DC A8                    tay   
4958 B4DD A3 11                 lda   17,s                     ;style/size
4959 B4DF 48                    pha   
4960 B4E0 5A                    phy   
4961 B4E1 DA                    phx   
4962 B4E2              ;
4963 B4E2 22 3B B5 FC           jsl   xInstallFont
4964 B4E6              ;
4965 B4E6 85 A6                 sta   <ErrCode1                ;error code, if any
4966 B4E8              ;
4967 B4E8 48                    pha                            ;space for result
4968 B4E9 F4 00 00 7B           PushZPtr <FontInfo 
4969 B4F2 F4 06 00              PushWord #6                    ;number of bytes to get
4970 B4F5 A2 04 D9 22           _GetFontLore 
4971 B4FC 68                    pla                            ;result - we don't use it
4972 B4FD              ;
4973 B4FD A3 09                 lda   9,s
4974 B4FF 85 28                 sta   <tempPtr
4975 B501 A3 0B                 lda   11,s
4976 B503 85 2A                 sta   <tempPtr+2
4977 B505              ;
4978 B505 A5 A0                 lda   <FamNum
4979 B507 87 28                 sta   [<tempPtr]
4980 B509 A5 A4                 lda   <Size
4981 B50B 29 FF 00              and   #$00FF
4982 B50E EB                    xba   
4983 B50F 85 A4                 sta   <Size
4984 B511 A5 A2                 lda   <Style
4985 B513 29 FF 00              and   #$00FF
4986 B516 05 A4                 ora   <Size
4987 B518 A0 02 00              ldy   #2
4988 B51B 97 28                 sta   [<tempPtr],y
4989 B51D              ;
4990 B51D A5 8C                 lda   <oldStats
4991 B51F A0 04 00              ldy   #4
4992 B522 97 28                 sta   [<tempPtr],y
4993 B524              ;
4994 B524 A6 A6                 ldx   <ErrCode1
4995 B526 D0 0B                 bne   Err1
4996 B528              ;no error:
4997 B528 A0 0A 00              ldy   #10
4998 B52B 18                    clc   
4999 B52C A0 0A 00              ldy   #10
5000 B52F 5C B0 FC FE           jml   endcall
5001 B533              ;
5002 B533 A0 0A 00     Err1     ldy   #10
5003 B536 38                    sec   
5004 B537 5C B3 FC FE           jml   errout
5005 B53B              ;
5006 B53B 7B           xInstallFont tdc   
5007 B53C 22 6F AD FC           jsl   InstallFont
5008 B540 6B                    rtl   
5009 B541                       ENDP 
5010 B541
5011 B541              ;                COPY mdstuff
5012 B541              **************************************************************
5013 B541              *
5014 B541              * FixFontMenu
5015 B541              *
5016 B541              ****************************************************************
5017 B541
5018 B541                       ENTRY FixFontMenu
5019 B541              FixFontMenu PROC 
5020 B541              ;
5021 B541              ****  Changed for purposes of ROMmability - BHM  x6245  12/10/87
5022 B541              **** many changes noted by a "*" for ease of debugging
5023 B541              ;
5024 B541
5025 B541              MenuID   equ   Temp
5026 B541              NumNames equ   MenuID+2
5027 B541
5028 B541 0B                    phd   
5029 B542 5B                    tcd   
5030 B543
5031 B543 20 45 C1              jsr   LockFMParams             ;must be called before BuildMDList, because BuildMDList 
5032 B546                                                      ;was using the FMParamPtr stored in zero page, after 
5033 B546                                                      ;the handle was unlocked, yet it is possible that 
5034 B546                                                      ;this pointer might have been moved because of compaction
5035 B546                                                      ;or something(4/28/88, HY)
5036 B546 20 17 BD              jsr   BuildMDList              ;build list of ptrs to famnames
5037 B549 90 06                 bcc   OK
5038 B54B 20 4B C1              jsr   unLockFMParams
5039 B54E 4C 9E C1              jmp   StdErr6                  ;return the error
5040 B551
5041 B551              OK        
5042 B551 20 2D C1              jsr   LockMDList
5043 B554
5044 B554 A3 0D                 lda   13,s                     ;get menu ID
5045 B556 85 A0                 sta   <MenuID
5046 B558 A3 0B                 lda   11,s                     ;get starting item ID
5047 B55A 85 82                 sta   <StartingID
5048 B55C
5049 B55C A0 73 00              ldy   #(DummyItemID-FMParams)
5050 B55F 97 4C                 sta   [<FMParamPtr],y          ;*store starting item ID in dummy item
5051 B561
5052 B561 A0 D0 00              ldy   #(MDListSize-FMParams)
5053 B564 B7 4C                 lda   [<FMParamPtr],y          ;*get # of entries in MD list
5054 B566 85 A2                 sta   <NumNames                ;and save
5055 B568
5056 B568              Loop      
5057 B568              ;push pointer to dummy menu item:
5058 B568 A6 4E                 ldx   <FMParamPtr+2            ;*high word
5059 B56A A5 4C                 lda   <FMParamPtr
5060 B56C 18                    clc   
5061 B56D 69 6E 00              adc   #(DummyItem-FMParams)
5062 B570 90 01                 bcc   NoCarry1
5063 B572 E8                    inx   
5064 B573              NoCarry1  
5065 B573 DA                    phx   
5066 B574 48                    pha   
5067 B575
5068 B575 F4 FF FF              PushWord #$FFFF                ;append to end of menu
5069 B578 D4 A0                 PushZWord <MenuID              ;push menu ID
5070 B57A A2 0F 0F 22           _InsertMItem                   ;append dummy menu item to end of menu
5071 B581
5072 B581 A0 02 00              ldy   #2
5073 B584 B7 44                 lda   [<MDPtr],y               ;push ptr to famname
5074 B586 48                    pha   
5075 B587 A7 44                 lda   [<MDPtr]
5076 B589 48                    pha   
5077 B58A A0 73 00              ldy   #(DummyItemID-FMParams)
5078 B58D B7 4C                 lda   [<FMParamPtr],y
5079 B58F 48                    pha                            ;*push item ID of dummy item just added
5080 B590 A2 0F 3A 22           _SetMItemName                  ;replace 'Dummy' with famname
5081 B597
5082 B597 20 C0 C0              jsr   IncMDPtr                 ;point to next MD list entry
5083 B59A              *increment item ID for next famname
5084 B59A A0 73 00              ldy   #(DummyItemID-FMParams)
5085 B59D B7 4C                 lda   [<FMParamPtr],y
5086 B59F 1A                    inc   a
5087 B5A0 97 4C                 sta   [<FMParamPtr],y
5088 B5A2
5089 B5A2 C6 A2                 dec   <NumNames                ;done with all famnames?
5090 B5A4 D0 C2                 bne   Loop                     ;no
5091 B5A6
5092 B5A6              ;Convert the list of ptrs to famnames (MDList) into a list of family
5093 B5A6              ;numbers (ItemList) which are in the same order as the font famnames
5094 B5A6              ;in the menu.  ItemList is used by the ItemID2FamNum routine.
5095 B5A6
5096 B5A6 A5 80                 lda   <MenuMade                ;was an ItemList created previously?
5097 B5A8 F0 0B                 beq   Cont                     ;no
5098 B5AA D4 22 D4 20           PushZLong <ItemHandle          ;yes - so release the space
5099 B5AE A2 02 10 22           _DisposeHandle 
5100 B5B5
5101 B5B5 A5 1C        Cont     lda   <MDHandle                ;copy handle to MD list
5102 B5B7 85 20                 sta   <ItemHandle
5103 B5B9 A5 1E                 lda   <MDHandle+2
5104 B5BB 85 22                 sta   <ItemHandle+2
5105 B5BD
5106 B5BD 20 2D C1              jsr   LockMDList               ;reset MDPtr back to start of list
5107 B5C0 20 39 C1              jsr   LockItemList             ;set up ItemPtr to also point to list
5108 B5C3
5109 B5C3 A0 D0 00              ldy   #(MDListSize-FMParams)
5110 B5C6 B7 4C                 lda   [<FMParamPtr],y          ;*get # of entries in MD list
5111 B5C8 85 A2                 sta   <NumNames                ;and save
5112 B5CA
5113 B5CA A0 06 00     ItemLoop ldy   #6
5114 B5CD B7 44                 lda   [<MDPtr],y               ;get fam # corresponding to famname ptr
5115 B5CF 87 48                 sta   [<ItemPtr]               ;and move up
5116 B5D1 20 C0 C0              jsr   IncMDPtr                 ;point to next MD list entry
5117 B5D4 20 D0 C0              jsr   IncItemPtr               ;point to next Item list entry
5118 B5D7 C6 A2                 dec   <NumNames                ;done?
5119 B5D9 D0 EF                 bne   ItemLoop                 ;no
5120 B5DB
5121 B5DB 20 33 C1              jsr   UnLockMDList
5122 B5DE
5123 B5DE F4 00 00              PushWord #0                    ;hi word of new size
5124 B5E1 A0 D0 00              ldy   #(MDListSize-FMParams)
5125 B5E4 B7 4C                 lda   [<FMParamPtr],y          ;*get # of items in MD list
5126 B5E6 0A                    asl   a                        ;multiply by 2 to get size of Item list
5127 B5E7 48                    pha                            ;lo word of size
5128 B5E8                                                      ;** code added 2-25-87 CAE **
5129 B5E8 85 66                 sta   <ItemListSize            ;save size of Item list
5130 B5EA                                                      ;** end addition **
5131 B5EA D4 1E D4 1C           PushZLong <MDHandle            ;handle to list
5132 B5EE A2 02 19 22           _SetHandleSize                 ;shrink MD list to use as Item list
5133 B5F5
5134 B5F5 E6 80                 inc   <MenuMade                ;set flag so Names list will stay locked
5135 B5F7                                                      ;since menu contains ptrs to famnames
5136 B5F7
5137 B5F7 20 4B C1              jsr   UnlockFMParams
5138 B5FA
5139 B5FA 4C 97 C1              jmp   StdEnd6
5140 B5FD                       ENDP 
5141 B5FD
5142 B5FD
5143 B5FD
5144 B5FD              ****************************************************************
5145 B5FD              *
5146 B5FD              * ItemID2FamNum
5147 B5FD              *
5148 B5FD              ****************************************************************
5149 B5FD
5150 B5FD                       ENTRY ItemID2FamNum
5151 B5FD              ItemID2FamNum PROC 
5152 B5FD
5153 B5FD 0B                    phd   
5154 B5FE 5B                    tcd   
5155 B5FF
5156 B5FF A5 80                 lda   <MenuMade
5157 B601 D0 0A                 bne   OK
5158 B603 A2 0B 1B              ldx   #MenuErr                 ;FixFontMenu never called
5159 B606 A0 02 00     ErrRet   ldy   #2                       ;param size
5160 B609 5C B3 FC FE           jml   errout                   ;return the error
5161 B60D
5162 B60D 20 39 C1     OK       jsr   LockItemList
5163 B610 38                    sec   
5164 B611 A3 09                 lda   9,s                      ;get item ID
5165 B613 E5 82                 sbc   <StartingID              ;create offset into Item list
5166 B615 0A                    asl   a
5167 B616 A8                    tay   
5168 B617              ;                                       ;** code added 2-25-87 CAE **
5169 B617 C4 66                 cpy   <ItemListSize            ;past end of list?
5170 B619 90 08                 bcc   OK2                      ;no - so OK
5171 B61B 20 3F C1              jsr   UnLockItemList           ;yes - so unlock list
5172 B61E A2 04 1B              ldx   #NoFamErr                ;and return error
5173 B621 80 E3                 bra   ErrRet
5174 B623              ;                                       ;** end addition **
5175 B623
5176 B623 B7 48        OK2      lda   [<ItemPtr],y             ;get fam # corresponding to item ID
5177 B625 83 0B                 sta   11,s                     ;and return
5178 B627 20 3F C1              jsr   UnLockItemList
5179 B62A A0 02 00              ldy   #2                       ;param #
5180 B62D 5C B0 FC FE           jml   endcall
5181 B631                       ENDP 
5182 B631
5183 B631
5184 B631
5185 B631              ****************************************************************
5186 B631              *
5187 B631              * FamNum2ItemID
5188 B631              *
5189 B631              ****************************************************************
5190 B631
5191 B631                       ENTRY FamNum2ItemID
5192 B631              FamNum2ItemID PROC 
5193 B631
5194 B631 0B                    phd   
5195 B632 5B                    tcd   
5196 B633
5197 B633 A5 80                 lda   <MenuMade
5198 B635 D0 0A                 bne   OK
5199 B637 A2 0B 1B              ldx   #MenuErr                 ;FixFontMenu never called
5200 B63A A0 02 00     ErrRet   ldy   #2                       ;param size
5201 B63D 5C B3 FC FE           jml   errout                   ;return the error
5202 B641
5203 B641 20 39 C1     OK       jsr   LockItemList
5204 B644 A0 00 00              ldy   #0
5205 B647
5206 B647 B7 48        Loop     lda   [<ItemPtr],y             ;get fam #
5207 B649 C3 09                 cmp   9,s                      ;is it the one we're looking for?
5208 B64B F0 0E                 beq   GotIt                    ;yes
5209 B64D C8                    iny                            ;no - so check next entry
5210 B64E C8                    iny   
5211 B64F C4 66                 cpy   <ItemListSize            ;at end of list?
5212 B651 90 F4                 bcc   Loop                     ;no
5213 B653 20 3F C1              jsr   UnLockItemList           ;yes - so unlock list
5214 B656 A2 04 1B              ldx   #NoFamErr                ;and return error
5215 B659 80 DF                 bra   ErrRet
5216 B65B
5217 B65B 98           GotIt    tya                            ;get offset into list
5218 B65C 4A                    lsr   a                        ;and divide by 2
5219 B65D 18                    clc   
5220 B65E 65 82                 adc   <StartingID              ;and add to starting item ID
5221 B660 83 0B                 sta   11,s                     ;to create item ID for this fam #
5222 B662 20 3F C1              jsr   UnLockItemList
5223 B665 A0 02 00              ldy   #2                       ;param size
5224 B668 5C B0 FC FE           jml   endcall
5225 B66C                       ENDP 
5226 B66C
5227 B66C
5228 B66C
5229 B66C              *********************************************************************************
5230 B66C              *
5231 B66C              * ChooseFont
5232 B66C              * Version 2.5
5233 B66C              *
5234 B66C              * Copyright Apple Computer, Inc. 1986-1988              
5235 B66C              * All Rights Reserved                   
5236 B66C              *
5237 B66C              * V2.5  1/4/89      Mensch
5238 B66C              *
5239 B66C              * 
5240 B66C              *
5241 B66C              *********************************************************************************
5242 B66C
5243 B66C              ****************************************************************
5244 B66C              *
5245 B66C              * ChooseFont
5246 B66C              *
5247 B66C              ****************************************************************
5248 B66C
5249 B66C                       ENTRY ChooseFont
5250 B66C              ChooseFont PROC 
5251 B66C              ;
5252 B66C              ****  EXPERIMENTAL CHANGE:
5253 B66C              ;only CurNum, CurStyle, and CurSize need to survive the call to InstallFont.
5254 B66C              ;By moving them to the end, and letting other ChooseFont temporary 0-page
5255 B66C              ;locations overlap with InstallFont's, we can reclaim some 0-page, which
5256 B66C              ;will be put to good use.  Trust me.  BHM  x6245  11/3/87
5257 B66C              ;
5258 B66C              ****  Changed to accomodate ROMming - BHM  x6245  12/10/87
5259 B66C              ****  many changes marked with a "*" for ease of debugging
5260 B66C              ;
5261 B66C              ;
5262 B66C              ; Changed to handle updating manually 1/3/89 Mensch
5263 B66C              ;
5264 B66C              ; Changed to use NewWindow2 templates 1/5/89 Mensch
5265 B66C              ; This change will allow personalization/internationalization of this dialog box
5266 B66C              ; and its asociated alert.
5267 B66C
5268 B66C              *** TaskRec	equ	Temp	;must be first!
5269 B66C
5270 B66C              *** TempStyle	equ	TaskRec+24
5271 B66C              *** TempStyle	equ	Temp
5272 B66C
5273 B66C              TempStyle equ   Temp+24                 ;24-Feb-91 DAL (I can't use less direct-page space than before!!)
5274 B66C              CntlHndl equ   TempStyle+2
5275 B66C
5276 B66C              CntlHndls equ   CntlHndl+4              ;these 3 items must be in this order
5277 B66C              PlainHndl equ   CntlHndls
5278 B66C              StyleHndls equ   PlainHndl+4
5279 B66C
5280 B66C              LinePtr  equ   StyleHndls+20
5281 B66C              Count    equ   LinePtr+4
5282 B66C              Index    equ   Count+2
5283 B66C              CancelFlag equ   Index+2
5284 B66C              ;
5285 B66C              ; It is vital that, at this point, we're beyond the end of
5286 B66C              ; IntallFont's temporary 0-page  (which we are) - BHM  11/3/87
5287 B66C              ;
5288 B66C              CurNum   equ   CancelFlag+2
5289 B66C              CurStyle equ   CurNum+2
5290 B66C              CurSize  equ   CurStyle+2
5291 B66C              ;
5292 B66C              ; Storage for the handles of our list
5293 B66C              MDCtlHandle equ   CurSize+2
5294 B66C              SizeCtlHandle equ   MDCtlHandle+4
5295 B66C
5296 B66C 0B                    phd   
5297 B66D 5B                    tcd   
5298 B66E
5299 B66E 20 45 C1              jsr   LockFMParams
5300 B671
5301 B671 64 DE                 stz   <CancelFlag
5302 B673 20 17 BD              jsr   BuildMDList              ;build list of ptrs to famnames
5303 B676 90 03                 bcc   OK
5304 B678 4C 9E C1              jmp   StdErr6                  ;return the error
5305 B67B
5306 B67B A3 0B        OK       lda   11,s                     ;get fam #
5307 B67D A8                    tay   
5308 B67E A3 0D                 lda   13,s                     ;get style/size
5309 B680 20 7D BF              jsr   CheckFontID
5310 B683 90 03                 bcc   IDOK
5311 B685 4C 9E C1              jmp   StdErr6                  ;return error
5312 B688
5313 B688 83 0D        IDOK     sta   13,s                     ;save converted style/size
5314 B68A 98                    tya   
5315 B68B 83 0B                 sta   11,s                     ;save converted fam #
5316 B68D 85 E0                 sta   <CurNum                  ;save current fam #
5317 B68F A3 0D                 lda   13,s
5318 B691 29 FF 00              and   #$00FF                   ;get current style
5319 B694 85 E2                 sta   <CurStyle                ;and save
5320 B696 A3 0D                 lda   13,s
5321 B698 29 00 FF              and   #$FF00                   ;get current size
5322 B69B EB                    xba   
5323 B69C 85 E4                 sta   <CurSize                 ;and save
5324 B69E
5325 B69E              *
5326 B69E 8B                    phb                            ;save data bank register
5327 B69F 4B                    phk   
5328 B6A0 AB                    plb                            ;set data bank to program bank
5329 B6A1
5330 B6A1 48                    pha                            ;space for result
5331 B6A2 48                    pha   
5332 B6A3 A2 04 1C 22           _GetPort                       ;save current port on stack
5333 B6AA
5334 B6AA 64 96                 stz   <ScreenMode              ;init to 320 mode
5335 B6AC 48                    pha                            ;space for result
5336 B6AD A2 04 17 22           _GetMasterSCB 
5337 B6B4 68                    pla   
5338 B6B5 29 80 00              and   #$0080                   ;is bit 7 set?
5339 B6B8 F0 05                 beq   Its320                   ;no - so in 320 mode
5340 B6BA A9 08 00              lda   #8                       ;yes - so in 640 mode
5341 B6BD 85 96                 sta   <ScreenMode              ;set to 8 to index rects correctly
5342 B6BF              Its320                                  ;
5343 B6BF
5344 B6BF              *
5345 B6BF
5346 B6BF 20 2D C1              jsr   LockMDList
5347 B6C2              *copy the pointer to MD list into the list record for MD list
5348 B6C2 A5 44                 lda   <MDPtr
5349 B6C4 A0 E4 00              ldy   #(MDListPtr-FMParams)
5350 B6C7 97 4C                 sta   [<FMParamPtr],y
5351 B6C9 A5 46                 lda   <MDPtr+2
5352 B6CB C8                    iny   
5353 B6CC C8                    iny   
5354 B6CD 97 4C                 sta   [<FMParamPtr],y
5355 B6CF
5356 B6CF 20 CE B9              jsr   DrawDialog               ;draw the dialog box
5357 B6D2
5358 B6D2 A9 04 80              lda   #$8004
5359 B6D5 85 B4                 sta   <newLevel
5360 B6D7 64 B6                 stz   <Count2
5361 B6D9              LoopTask  
5362 B6D9 48                    pha   
5363 B6DA 48                    pha   
5364 B6DB D4 9E D4 9C           PushZLong <LineHndl 
5365 B6DF A2 10 0D 22           _GetCtlTitle 
5366 B6E6 A2 14 0C 22           _LEIdle 
5367 B6ED 48                    pha   
5368 B6EE F4 FF FF              PushWord #$FFFF 
5369 B6F1 F4 00 00              PushWord #0 
5370 B6F4 7B                    tdc   
5371 B6F5 18                    clc   
5372 B6F6 69 A0 00              adc   #Temp
5373 B6F9 48                    pha   
5374 B6FA A2 0E 1D 22           _TaskMaster 
5375 B701 68                    pla   
5376 B702 C9 03 00              cmp   #3
5377 B705 D0 03                 bne   HB70A
5378 B707 82 6B 02              brl   CheckKey
5379 B70A C9 13 00     HB70A    cmp   #$13
5380 B70D F0 4E                 beq   HB75D
5381 B70F C9 10 00              cmp   #$10
5382 B712 90 09                 bcc   HB71D
5383 B714 A2 03 2C 22           _SysBeep 
5384 B71B 80 00                 bra   HB71D
5385 B71D 48           HB71D    pha   
5386 B71E 48                    pha   
5387 B71F D4 9A D4 98           PushZLong <WindPtr 
5388 B723 A2 0E 30 22           _GetUpdateRgn 
5389 B72A FA                    plx   
5390 B72B 7A                    ply   
5391 B72C D0 05                 bne   HB733
5392 B72E E0 00 00              cpx   #0
5393 B731 F0 A6                 beq   LoopTask
5394 B733 48           HB733    pha   
5395 B734 5A                    phy   
5396 B735 DA                    phx   
5397 B736 A2 04 78 22           _EmptyRgn 
5398 B73D 68                    pla   
5399 B73E D0 99                 bne   LoopTask
5400 B740 D4 9A D4 98           PushZLong <WindPtr 
5401 B744 A2 0E 1E 22           _BeginUpdate 
5402 B74B 22 AC BD FC           jsl   DrawGuts
5403 B74F D4 9A D4 98           PushZLong <WindPtr 
5404 B753 A2 0E 1F 22           _EndUpdate 
5405 B75A 82 7C FF              brl   LoopTask
5406 B75D 48           HB75D    pha   
5407 B75E F4 00 00              pea   #0
5408 B761 7B                    tdc   
5409 B762 18                    clc   
5410 B763 69 BA 00              adc   #CntlHndl
5411 B766 48                    pha   
5412 B767 D4 AC D4 AA           PushZLong <IDSize 
5413 B76B D4 9A D4 98           PushZLong <WindPtr 
5414 B76F A2 10 13 22           _FindControl 
5415 B776 68                    pla   
5416 B777 D0 03                 bne   HB77C
5417 B779 82 D9 01              brl   OtherSizeHit
5418 B77C 48           HB77C    pha   
5419 B77D D4 AC D4 AA           PushZLong <IDSize 
5420 B781 F4 FF FF              PushWord #$FFFF 
5421 B784 48                    pha   
5422 B785 D4 BC D4 BA           PushZLong <CntlHndl 
5423 B789 A2 10 15 22           _TrackControl 
5424 B790 68                    pla   
5425 B791 F0 0A                 beq   InCont10
5426 B793
5427 B793 C9 88 00              cmp   #ListPartCode            ;was the hit on a list control?
5428 B796 F0 08                 beq   OKControl                ;yes  - so OK
5429 B798 C9 05 00              cmp   #5                       ;was the hit on a standard control?
5430 B79B 90 03                 bcc   OKControl                ;yes - so OK
5431 B79D 82 39 FF     InCont10 brl   LoopTask                 ;no - so get next event
5432 B7A0
5433 B7A0 48           OKControl pha                           ;space for result
5434 B7A1 48                    pha   
5435 B7A2 D4 BC D4 BA           PushZLong <CntlHndl            ;control handle
5436 B7A6 A2 10 23 22           _GetCtlRefCon                  ;get address of routine to handle hit
5437 B7AD 68                    pla                            ; low word...
5438 B7AE FA                    plx                            ; high word
5439 B7AF D0 0B                 bne   OKCByPtr                 ; passed refcon is a routine pointer
5440 B7B1 C9 0A 00              cmp   #10                      ; test to see if the passed routine is standard
5441 B7B4 B0 06                 bge   OKCByPtr                 ; if not, the assume by pointer
5442 B7B6 0A                    asl   a                        ; multiply the refcon by 2
5443 B7B7 AA                    tax                            ; use it as an index
5444 B7B8 BF C2 B7 FC           lda   >handlerTbl,x            ; get the address from handler table 
5445 B7BC
5446 B7BC              OKCByPtr  
5447 B7BC              ; this routine JSRs to the routine pointer to by the refcon. 
5448 B7BC 3A                    dec   a
5449 B7BD 48                    pha                            ;push address on stack
5450 B7BE 60                    rts                            ;return into routine
5451 B7BF              OKC_Dummy  
5452 B7BF
5453 B7BF 82 17 FF              brl   LoopTask
5454 B7C2              handlerTbl  
5455 B7C2              ; table of routines that handle various controls in our dialog. This table MUST have 
5456 B7C2              ; 16 entries in it!
5457 B7C2 BF B7                 DC W:OKC_Dummy                 ; 0 - Do nothing
5458 B7C4 D2 B8                 DC W:FontHit                   ; 1 - Handle a hit in the font list
5459 B7C6 07 B9                 DC W:SizeHit                   ; 2 - Handle hit in size list
5460 B7C8 55 B9                 DC W:OtherSizeHit              ; 3 - hit the other-size box
5461 B7CA E2 B7                 DC W:OKHit                     ; 4 - hit in OK button
5462 B7CC 6E B8                 DC W:CancelHit                 ; 5 - hit in cancel button
5463 B7CE 79 B8                 DC W:PlainHit                  ; 6 - hit in plain style item
5464 B7D0 A5 B8                 DC W:StyleHit                  ; 7 - hit in other style item
5465 B7D2 BF B7                 DC W:OKC_Dummy                 ; 8 - nothing
5466 B7D4 BF B7                 DC W:OKC_Dummy                 ; 9 - nothing
5467 B7D6 BF B7                 DC W:OKC_Dummy                 ; 10 - nothing
5468 B7D8 BF B7                 DC W:OKC_Dummy                 ; 11 - nothing
5469 B7DA BF B7                 DC W:OKC_Dummy                 ; 12 - nothing
5470 B7DC BF B7                 DC W:OKC_Dummy                 ; 13 - nothing
5471 B7DE BF B7                 DC W:OKC_Dummy                 ; 14 - nothing
5472 B7E0 BF B7                 DC W:OKC_Dummy                 ; 15 - nothing
5473 B7E2
5474 B7E2              ;-------------------------------------------------------------------------------
5475 B7E2              ;
5476 B7E2              ; The hit was in the OK button
5477 B7E2              ;
5478 B7E2                       Entry OKHit 
5479 B7E2 20 4C BC     OKHit    jsr   GetNewSize               ;get new font size
5480 B7E5 A5 E4                 lda   <CurSize
5481 B7E7 D0 06                 bne   SizeNotZero              ;size of zero not allowed
5482 B7E9 20 DC BC     BadSize  jsr   DoAlert                  ;put up alert box
5483 B7EC 82 EA FE              brl   LoopTask
5484 B7EF
5485 B7EF C9 00 01     SizeNotZero cmp   #256
5486 B7F2 B0 F5                 bcs   BadSize                  ;size > 255 not allowed
5487 B7F4
5488 B7F4              ; get selected font style
5489 B7F4
5490 B7F4 64 E2                 stz   <CurStyle
5491 B7F6 A2 10 00              ldx   #(5*4)-4                 ;index to last style control
5492 B7F9
5493 B7F9 06 E2        StyleLoop asl   <CurStyle
5494 B7FB DA                    phx                            ;save X
5495 B7FC 48                    pha                            ;space for result
5496 B7FD B5 C4                 lda   <StyleHndls+2,x          ;handle to control
5497 B7FF 48                    pha   
5498 B800 B5 C2                 lda   <StyleHndls,x
5499 B802 48                    pha   
5500 B803 A2 10 1A 22           _GetCtlValue                   ;get current value of control
5501 B80A 68                    pla   
5502 B80B F0 02                 beq   DoNext                   ;branch if not set
5503 B80D E6 E2                 inc   <CurStyle                ;set bit corresponding to the style
5504 B80F FA           DoNext   plx                            ;retrieve X
5505 B810 CA                    dex   
5506 B811 CA                    dex   
5507 B812 CA                    dex   
5508 B813 CA                    dex                            ;set index to next style control
5509 B814 10 E3                 bpl   StyleLoop
5510 B816
5511 B816              ; finish up
5512 B816
5513 B816 D4 9A D4 98  FinishUp PushZLong <WindPtr 
5514 B81A A2 0E 0B 22           _CloseWindow                   ;close window
5515 B821
5516 B821 D4 1E D4 1C           PushZLong <MDHandle 
5517 B825 A2 02 10 22           _DisposeHandle                 ;dispose of MD list
5518 B82C
5519 B82C 20 0A C1              jsr   UnLockNameList
5520 B82F 20 4B C1              jsr   UnlockFMParams
5521 B832
5522 B832 A2 04 1B 22           _SetPort                       ;restore port
5523 B839
5524 B839 AB                    plb                            ;restore data bank register
5525 B83A
5526 B83A A5 DE                 lda   <CancelFlag              ;was Cancel hit?
5527 B83C D0 1C                 bne   Done                     ;yes
5528 B83E
5529 B83E              ; compare selected fontID against original fontID
5530 B83E
5531 B83E A5 E4                 lda   <CurSize                 ;create style/size word
5532 B840 EB                    xba   
5533 B841 05 E2                 ora   <CurStyle
5534 B843 A8                    tay                            ;and save
5535 B844 C3 0D                 cmp   13,s                     ;compare with original style/size
5536 B846 D0 08                 bne   InstallNew               ;different so install new font
5537 B848 A5 E0                 lda   <CurNum
5538 B84A C3 0B                 cmp   11,s                     ;compare fam #
5539 B84C D0 02                 bne   InstallNew               ;different so install new font
5540 B84E 80 0A                 bra   Done                     ;new font = old font, so no change
5541 B850
5542 B850              ; new font is different from old font so install it
5543 B850
5544 B850 5A           InstallNew phy                          ;style/size
5545 B851 D4 E0                 PushZWord <CurNum              ;fam #
5546 B853 F4 00 00              PushWord #0                    ;enable scaling
5547 B856
5548 B856 22 68 B8 FC           jsl   HB868
5549 B85A
5550 B85A              ; return selected fontID
5551 B85A
5552 B85A A5 E0        Done     lda   <CurNum
5553 B85C 83 0F                 sta   15,s
5554 B85E A5 E4                 lda   <CurSize
5555 B860 EB                    xba   
5556 B861 05 E2                 ora   <CurStyle
5557 B863 83 11                 sta   17,s
5558 B865
5559 B865 4C 97 C1              jmp   StdEnd6
5560 B868
5561 B868 7B           HB868    tdc   
5562 B869 22 6F AD FC           jsl   InstallFont
5563 B86D 6B                    rtl   
5564 B86E
5565 B86E              ;-------------------------------------------------------------------------------
5566 B86E              ;
5567 B86E              ; The hit was in the Cancel button
5568 B86E              ;
5569 B86E                       Entry CancelHit 
5570 B86E 64 E0        CancelHit stz   <CurNum                 ;return 0 as selected font ID
5571 B870 64 E4                 stz   <CurSize
5572 B872 64 E2                 stz   <CurStyle
5573 B874 E6 DE                 inc   <CancelFlag
5574 B876 82 9D FF              brl   FinishUp
5575 B879
5576 B879              ;-------------------------------------------------------------------------------
5577 B879              ;
5578 B879              ; The hit was in the 'Plain' check box
5579 B879              ;
5580 B879                       Entry PlainHit 
5581 B879 F4 01 00     PlainHit PushWord #1                    ;control value
5582 B87C D4 C0 D4 BE           PushZLong <PlainHndl           ;control handle
5583 B880 A2 10 19 22           _SetCtlValue                   ;set the control
5584 B887
5585 B887 A2 10 00              ldx   #(5*4)-4                 ;index to last Style control
5586 B88A DA           ClearLoop phx   
5587 B88B F4 00 00              PushWord #0                    ;new control value
5588 B88E B5 C4                 lda   <StyleHndls+2,x
5589 B890 48                    pha                            ;control handle
5590 B891 B5 C2                 lda   <StyleHndls,x
5591 B893 48                    pha   
5592 B894 A2 10 19 22           _SetCtlValue                   ;clear out all Style check boxes
5593 B89B FA                    plx   
5594 B89C CA                    dex   
5595 B89D CA                    dex   
5596 B89E CA                    dex   
5597 B89F CA                    dex                            ;set index to next Style control
5598 B8A0 10 E8                 bpl   ClearLoop
5599 B8A2 82 34 FE              brl   LoopTask
5600 B8A5
5601 B8A5              ;-------------------------------------------------------------------------------
5602 B8A5              ;
5603 B8A5              ; The hit was in one of the Style check boxes (other than the 'Plain' check box)
5604 B8A5              ;
5605 B8A5                       Entry StyleHit 
5606 B8A5 48           StyleHit pha   
5607 B8A6 D4 BC D4 BA           PushZLong <CntlHndl 
5608 B8AA A2 10 1A 22           _GetCtlValue 
5609 B8B1 68                    pla   
5610 B8B2 49 01 00              eor   #1
5611 B8B5 48                    pha   
5612 B8B6 D4 BC D4 BA           PushZLong <CntlHndl 
5613 B8BA A2 10 19 22           _SetCtlValue 
5614 B8C1
5615 B8C1 F4 00 00              PushWord #0 
5616 B8C4 D4 C0 D4 BE           PushZLong <PlainHndl 
5617 B8C8 A2 10 19 22           _SetCtlValue                   ;clear out 'Plain' check box
5618 B8CF 82 07 FE              brl   LoopTask
5619 B8D2
5620 B8D2              ;-------------------------------------------------------------------------------
5621 B8D2              ;
5622 B8D2              ; The hit was in the list of font family names
5623 B8D2              ;
5624 B8D2                       ENTRY FontHit
5625 B8D2 20 4C BC     FontHit  jsr   GetNewSize               ;get latest font size setting
5626 B8D5
5627 B8D5 48                    pha                            ;space for result
5628 B8D6 F4 00 00              Pushword #0                    ;start at member 0
5629 B8D9 D4 E8 D4 E6           pushZLong <MDCtlHandle 
5630 B8DD A2 1C 12 22           _NextMember2 
5631 B8E4 68                    pla                            ; member number to select
5632 B8E5 F0 1D                 beq   FontHitDone              ;no member was selected
5633 B8E7              ;
5634 B8E7              ; Now that we have the item number, we must turn it into an address
5635 B8E7              ;
5636 B8E7 3A                    dec   a                        ; subtract 1 (we base list off zero)
5637 B8E8 A0 02 00              ldy   #2                       ; init our index...
5638 B8EB
5639 B8EB 0A                    asl   a                        ; multiply the member by 8
5640 B8EC 0A                    asl   a
5641 B8ED 0A                    asl   a
5642 B8EE 18                    clc                            ; and prepare to create a member pointer
5643 B8EF 67 1C                 adc   [<MDHandle]
5644 B8F1 85 44                 sta   <MDPtr                   ; and save it as our pointer
5645 B8F3 B7 1C                 lda   [<MDHandle],y
5646 B8F5 69 00 00              adc   #0
5647 B8F8 85 46                 sta   <MDPtr+2
5648 B8FA
5649 B8FA A0 06 00              ldy   #6
5650 B8FD B7 44                 lda   [<MDPtr],y               ;get fam # of selected member
5651 B8FF 85 E0                 sta   <CurNum                  ;and save
5652 B901
5653 B901 20 7B BB              jsr   BuildSizeList            ;update the list of font sizes to
5654 B904
5655 B904 82 D2 FD     FontHitDone brl   LoopTask              ;correspond to this fam #
5656 B907
5657 B907              ;-------------------------------------------------------------------------------
5658 B907              ;
5659 B907              ; The hit was in the list of font sizes
5660 B907              ;
5661 B907                       ENTRY SizeHit
5662 B907 48           SizeHit  pha                            ;space for result
5663 B908 F4 00 00              Pushword #0                    ;start at member 0
5664 B90B D4 EC D4 EA           pushZLong <SizeCtlHandle 
5665 B90F A2 1C 12 22           _NextMember2 
5666 B916 68                    pla                            ; member number to select
5667 B917 F0 39                 beq   SizeHitDone              ;no member was selected
5668 B919
5669 B919              ; Now multiply the item number by 5
5670 B919 3A                    dec   A                        ; subtract 1 to offset for 0 starting list
5671 B91A 85 8E                 sta   <temp1Ptr                ; save the item number for a sec...
5672 B91C 0A                    asl   a                        ; multiply it by 4
5673 B91D 0A                    asl   a
5674 B91E 18                    clc   
5675 B91F 65 8E                 adc   <temp1Ptr                ; we now have (ItemNo-1)*5 in <A>
5676 B921 18                    clc   
5677 B922 69 28 01              adc   #(SizeList-FMParams)     ; offset into our data area
5678 B925 18                    clc                            ; now create the actual pointer
5679 B926 65 4C                 adc   <FMParamPtr
5680 B928 85 8E                 sta   <temp1Ptr                ; after all that, this is a pointer to our item
5681 B92A A5 4E                 lda   <FMParamPtr+2
5682 B92C 69 00 00              adc   #0
5683 B92F 85 90                 sta   <temp1Ptr+2
5684 B931
5685 B931 A7 8E                 lda   [<temp1Ptr]              ;get size from selected member
5686 B933 85 E4                 sta   <CurSize                 ;and save
5687 B935
5688 B935 20 65 BE              jsr   MakeString               ;convert size into a string
5689 B938 20 95 BC              jsr   SetSizeText              ;set the 'Other Size' text to the string
5690 B93B 20 C1 BC              jsr   SelectSizeText           ;select the 'Other Size' text
5691 B93E
5692 B93E 48                    pha   
5693 B93F 48                    pha   
5694 B940 D4 9E D4 9C           PushZLong <LineHndl            ;handle to LineEdit record
5695 B944 A2 10 0D 22           _GetCtlTitle 
5696 B94B A2 14 17 22           _LEUpdate                      ;redraw the text
5697 B952
5698 B952 82 84 FD     SizeHitDone brl   LoopTask
5699 B955
5700 B955              OtherSizeHit  
5701 B955 F4 00 00              pea   0
5702 B958 7B                    tdc   
5703 B959 18                    clc   
5704 B95A 69 A0 00              adc   #$A0
5705 B95D 48                    pha   
5706 B95E 48                    pha   
5707 B95F 48                    pha   
5708 B960 D4 9E D4 9C           PushZLong <LineHndl 
5709 B964 A2 10 0D 22           _GetCtlTitle 
5710 B96B A2 14 0D 22           _LEClick 
5711 B972 82 64 FD              brl   LoopTask
5712 B975 A5 A2        CheckKey lda   KeyChar
5713 B977 29 FF 00              and   #$00FF
5714 B97A C9 0D 00              cmp   #$0D                     ;cr
5715 B97D D0 03                 bne   @notcr
5716 B97F 82 60 FE              brl   OkHit
5717 B982 C9 08 00     @notcr   cmp   #$08                     ;left arrow
5718 B985 F0 23                 beq   @okChar
5719 B987 C9 15 00              cmp   #$15                     ;right arrow
5720 B98A F0 1E                 beq   @okChar
5721 B98C C9 7F 00              cmp   #$7F                     ;delete
5722 B98F F0 19                 beq   @okChar
5723 B991 C9 18 00              cmp   #$18                     ;control-X
5724 B994 F0 14                 beq   @okChar
5725 B996 C9 06 00              cmp   #$06                     ;control-F
5726 B999 F0 0F                 beq   @okChar
5727 B99B C9 19 00              cmp   #$19                     ;control-Y
5728 B99E F0 0A                 beq   @okChar
5729 B9A0 C9 30 00              cmp   #'0'
5730 B9A3 90 1F                 bcc   @BadChar
5731 B9A5 C9 3A 00              cmp   #'9'+1
5732 B9A8 B0 1A                 bcs   @BadChar
5733 B9AA 48           @okChar  pha   
5734 B9AB D4 AE                 pei   <H0xAE
5735 B9AD 48                    pha   
5736 B9AE 48                    pha   
5737 B9AF D4 9E D4 9C           PushZLong <LineHndl 
5738 B9B3 A2 10 0D 22           _GetCtlTitle 
5739 B9BA A2 14 11 22           _LEKey 
5740 B9C1 82 15 FD              brl   LoopTask
5741 B9C4 A2 03 2C 22  @BadChar _SysBeep 
5742 B9CB 82 0B FD              brl   LoopTask
5743 B9CE
5744 B9CE              ;-------------------------------------------------------------------------------
5745 B9CE              ;
5746 B9CE              ; Create the dialog window and then draw it
5747 B9CE              ;
5748 B9CE 48           DrawDialog pha   
5749 B9CF 48                    pha                            ; room for result
5750 B9D0 F4 0E 80              PushWord #$800E                ; resource type to load
5751 B9D3 A6 96                 ldx   <ScreenMode              ; get the current screen mode
5752 B9D5 BD AC 9F              lda   WindTemplates+2,x        ; and pass the pointer to the template 
5753 B9D8 48                    pha   
5754 B9D9 BD AA 9F              lda   WindTemplates,x          ; and pass the pointer to the template 
5755 B9DC 48                    pha   
5756 B9DD A2 03 35 22           _GetRomResource 
5757 B9E4 68 85 98 68           PullLong <WindPtr 
5758 B9EA              ; lock the handle we got back...
5759 B9EA A0 04 00              ldy   #4
5760 B9ED B7 98                 lda   [<WindPtr],y             ; get the flags byte
5761 B9EF 09 00 80              ora   #$8000                   ; lock it
5762 B9F2 97 98                 sta   [<WindPtr],y             ; and put it back...
5763 B9F4
5764 B9F4 A0 02 00              ldy   #2                       ; now dereference the handle
5765 B9F7 B7 98                 lda   [<WindPtr],y
5766 B9F9 AA                    tax   
5767 B9FA A7 98                 lda   [<WindPtr]
5768 B9FC 85 98                 sta   <WindPtr
5769 B9FE 86 9A                 stx   <WindPtr+2
5770 BA00
5771 BA00 A2 00 00              ldx   #0
5772 BA03 DA                    phx   
5773 BA04 DA                    phx                            ; room for result
5774 BA05 DA                    phx   
5775 BA06 DA                    phx                            ; no title
5776 BA07 DA                    phx   
5777 BA08 DA                    phx                            ; no refcon
5778 BA09 F4 FC 00 F4           PushLong #DrawGuts             ; address of draw routine
5779 BA0F DA                    phx   
5780 BA10 DA                    phx                            ; DefProcPtr
5781 BA11 DA                    phx                            ; Reference descriptor
5782 BA12 A5 9A 48 A5           PushLong <WindPtr 
5783 BA18 F4 0E 80              pea   $800E                    ; use an rWindparam1 window
5784 BA1B A2 0E 61 22           _NewWindow2                    ; create the window and controls
5785 BA22 68                    pla                            ;get ptr to window and save
5786 BA23 85 98                 sta   <WindPtr                 ;in zero page
5787 BA25 68                    pla   
5788 BA26 85 9A                 sta   <WindPtr+2
5789 BA28
5790 BA28 F4 0E 80              PushWord #$800E                ; resource type to load
5791 BA2B A6 96                 ldx   <ScreenMode              ; get the current screen mode
5792 BA2D BD AC 9F              lda   WindTemplates+2,x        ; and pass the pointer to the template 
5793 BA30 48                    pha   
5794 BA31 BD AA 9F              lda   WindTemplates,x          ; and pass the pointer to the template 
5795 BA34 48                    pha   
5796 BA35 A2 03 36 22           _ReleaseRomResource 
5797 BA3C
5798 BA3C D4 9A D4 98           PushZLong <WindPtr 
5799 BA40 A2 04 1B 22           _SetPort 
5800 BA47
5801 BA47              ;
5802 BA47              ; Now, update the contents of the lists for later use
5803 BA47              ;
5804 BA47              ; Get the MD list's ctrl handle so we can update it
5805 BA47
5806 BA47 48                    pha                            ; room for result
5807 BA48 48                    pha   
5808 BA49 A5 9A 48 A5           PushLong <WindPtr 
5809 BA4F F4 00 00 F4           PushLong #MDListID 
5810 BA55 A2 10 30 22           _GetCtlHandleFromID 
5811 BA5C 68                    pla   
5812 BA5D 85 E6                 sta   <MDCtlHandle
5813 BA5F 68                    pla   
5814 BA60 85 E8                 sta   <MDCtlHandle+2           ; get the control handle
5815 BA62
5816 BA62 A2 00 00              ldx   #0                       ; now set MD list to use the already created data
5817 BA65 DA                    phx                            ; negative 1...
5818 BA66 DA                    phx                            ; Pointer to draw routine
5819 BA67 F4 01 00              pea   1                        ; leave same thing selected
5820 BA6A A5 1E 48 A5           PushLong <MDHandle 
5821 BA70 F4 01 00              pea   1                        ; ref verb zero means pass by ptr, 1 means by handle
5822 BA73 A0 D0 00              ldy   #(MDListSize-FMParams)
5823 BA76 B7 4C                 lda   [<FMParamPtr],y          ; get number of list members
5824 BA78 48                    pha   
5825 BA79 A5 E8 48 A5           PushLong <MDCtlHandle 
5826 BA7F A2 1C 16 22           _NewList2                      ; create the MD list
5827 BA86
5828 BA86              ;make the correct font family name selected
5829 BA86
5830 BA86 A0 D0 00              ldy   #(MDListSize-FMParams)
5831 BA89 B7 4C                 lda   [<FMParamPtr],y          ;*  # of list members
5832 BA8B 85 DA                 sta   <Count
5833 BA8D A0 06 00     SelLoop  ldy   #6
5834 BA90 B7 44                 lda   [<MDPtr],y               ;get fam #
5835 BA92 C5 E0                 cmp   <CurNum                  ;current family?
5836 BA94 F0 09                 beq   SelMember                ;yes
5837 BA96 20 C0 C0              jsr   IncMDPtr                 ;no - so check next member
5838 BA99 C6 DA                 dec   <Count                   ;done with list?
5839 BA9B D0 F0                 bne   SelLoop                  ;no
5840 BA9D 80 17                 bra   NoSel
5841 BA9F              SelMember  
5842 BA9F A0 D0 00              ldy   #(MDListSize-FMParams)
5843 BAA2 B7 4C                 lda   [<FMParamPtr],y          ;# of list members
5844 BAA4 38                    sec   
5845 BAA5 E5 DA                 sbc   <Count                   ; now select the proper member
5846 BAA7 1A                    inc   a
5847 BAA8 48                    pha   
5848 BAA9 A5 E8 48 A5           PushLong <MDCtlHandle 
5849 BAAF A2 1C 14 22           _SelectMember2                 ; and select the current font
5850 BAB6              NoSel     
5851 BAB6
5852 BAB6              ; create the list of font sizes and select the current size
5853 BAB6
5854 BAB6 48                    pha                            ; room for result
5855 BAB7 48                    pha   
5856 BAB8 A5 9A 48 A5           PushLong <WindPtr 
5857 BABE F4 00 00 F4           PushLong #SizeListID 
5858 BAC4 A2 10 30 22           _GetCtlHandleFromID 
5859 BACB 68                    pla   
5860 BACC 85 EA                 sta   <SizeCtlHandle           ; get the control handle
5861 BACE 68                    pla   
5862 BACF 85 EC                 sta   <SizeCtlHandle+2
5863 BAD1
5864 BAD1 A9 01 00              lda   #1
5865 BAD4 A0 F8 00              ldy   #(SizeListSize-FMParams)
5866 BAD7 97 4C                 sta   [<FMParamPtr],y          ;init to 1 member
5867 BAD9
5868 BAD9 20 7B BB              jsr   BuildSizeList            ;create Size list, select current size
5869 BADC
5870 BADC 48                    pha                            ; room for result
5871 BADD 48                    pha   
5872 BADE A5 9A 48 A5           PushLong <WindPtr 
5873 BAE4 F4 00 00 F4           PushLong #SizeEditID 
5874 BAEA A2 10 30 22           _GetCtlHandleFromID 
5875 BAF1 68                    pla   
5876 BAF2 85 9C                 sta   <LineHndl                ;save the handle on zero page
5877 BAF4 68                    pla   
5878 BAF5 85 9E                 sta   <LineHndl+2
5879 BAF7
5880 BAF7 A2 06 00              ldx   #PlainSID
5881 BAFA 64 DC                 stz   <Index
5882 BAFC              ; get all the style checkbox control handles
5883 BAFC              GetStylehndl  
5884 BAFC DA                    phx   
5885 BAFD
5886 BAFD 48                    pha                            ; room for result
5887 BAFE 48                    pha   
5888 BAFF A5 9A 48 A5           PushLong <WindPtr 
5889 BB05 F4 00 00              pea   0
5890 BB08 DA                    phx   
5891 BB09 A2 10 30 22           _GetCtlHandleFromID 
5892 BB10 A6 DC                 ldx   <Index                   ; load the index offset...
5893 BB12 68                    pla   
5894 BB13 95 BE                 sta   <CntlHndls,x             ;save the handle on zero page
5895 BB15 68                    pla   
5896 BB16 95 C0                 sta   <CntlHndls+2,x
5897 BB18 A5 DC                 lda   <Index
5898 BB1A 18                    clc   
5899 BB1B 69 04 00              adc   #4
5900 BB1E 85 DC                 sta   <Index
5901 BB20 FA                    plx   
5902 BB21 E8                    inx   
5903 BB22 E0 0C 00              cpx   #LastSID                 ; is it the last ID?
5904 BB25 90 D5                 blt   GetStyleHndl
5905 BB27
5906 BB27              ; convert the current font's size to a string
5907 BB27
5908 BB27 A5 E4                 lda   <CurSize                 ;get current font size
5909 BB29 20 65 BE              jsr   MakeString               ;convert into a string
5910 BB2C 20 95 BC              jsr   SetSizeText              ;set the 'Other Size' text to the string
5911 BB2F 20 C1 BC              jsr   SelectSizeText           ;select the 'Other Size' text
5912 BB32
5913 BB32              ; get the style of the current font and set the Style check boxes accordingly
5914 BB32
5915 BB32 A5 E2                 lda   <CurStyle                ;get current style
5916 BB34 F0 2B                 beq   SetPlain                 ;branch if 'Plain'
5917 BB36 85 B8                 sta   <TempStyle               ;save current style
5918 BB38 A9 05 00              lda   #5
5919 BB3B 85 DA                 sta   <Count                   ;# of 'Style' check boxes
5920 BB3D A2 00 00              ldx   #0                       ;start at first 'Style' check box
5921 BB40
5922 BB40 DA           SetStyles phx   
5923 BB41 46 B8                 lsr   <TempStyle               ;check style bit
5924 BB43 90 10                 bcc   NotSet                   ;branch if not set
5925 BB45 F4 01 00              PushWord #1                    ;new control value
5926 BB48 B5 C4                 lda   <StyleHndls+2,x          ;handle to correct check box
5927 BB4A 48                    pha   
5928 BB4B B5 C2                 lda   <StyleHndls,x
5929 BB4D 48                    pha   
5930 BB4E A2 10 19 22           _SetCtlValue                   ;set the check box
5931 BB55 FA           NotSet   plx   
5932 BB56 E8                    inx   
5933 BB57 E8                    inx   
5934 BB58 E8                    inx   
5935 BB59 E8                    inx                            ;index next check box
5936 BB5A C6 DA                 dec   <Count
5937 BB5C D0 E2                 bne   SetStyles
5938 BB5E 82 0E 00              brl   ShowIt
5939 BB61
5940 BB61 F4 01 00     SetPlain PushWord #1 
5941 BB64 D4 C0 D4 BE           PushZLong <PlainHndl 
5942 BB68 A2 10 19 22           _SetCtlValue                   ;set the 'Plain' check box
5943 BB6F
5944 BB6F D4 9A D4 98  ShowIt   PushZLong <WindPtr             ;ptr to window
5945 BB73 A2 0E 13 22           _ShowWindow                    ;draw the window
5946 BB7A 60                    rts   
5947 BB7B
5948 BB7B              ;------------------------------------------------------------------------------
5949 BB7B              ;
5950 BB7B              ; Create list of sizes available for the currently selected font family.
5951 BB7B              ; Sort the list in numerical order.
5952 BB7B              ; Select the current size if available and then draw the new list.
5953 BB7B              ;
5954 BB7B              BuildSizeList  
5955 BB7B
5956 BB7B              ; create the list of font sizes
5957 BB7B
5958 BB7B 20 EC C0              jsr   LockIDList
5959 BB7E              ;
5960 BB7E A9 00 00              lda   #0
5961 BB81 A0 F8 00              ldy   #(SizeListSize-FMParams)
5962 BB84 97 4C                 sta   [<FMParamPtr],y
5963 BB86 85 DA                 sta   <Count
5964 BB88              ;
5965 BB88 A5 4C                 lda   <FMParamPtr
5966 BB8A 18                    clc   
5967 BB8B 69 28 01              adc   #(SizeList-FMParams)
5968 BB8E 85 8E                 sta   <temp1Ptr
5969 BB90              ;
5970 BB90              *  added 1/14/88 - let's get the size list structure right - BHM  x6245
5971 BB90              ;
5972 BB90 A5 4E                 lda   <FMParamPtr+2
5973 BB92 69 00 00              adc   #0
5974 BB95 85 90                 sta   <temp1Ptr+2
5975 BB97              ;
5976 BB97              ; in this ROMmable version, we'll use y for actual indexing, but x
5977 BB97              ; for index calculations
5978 BB97              ;
5979 BB97 A2 00 00              ldx   #0
5980 BB9A
5981 BB9A A7 30        BuildLoop lda   [<IDPtr]                ;get fam #
5982 BB9C C5 E0                 cmp   <CurNum                  ;match?
5983 BB9E D0 28                 bne   NextID                   ;no
5984 BBA0              ;       ;** code added 2-25-87 CAE **
5985 BBA0 A0 08 00              ldy   #8
5986 BBA3 B7 30                 lda   [<IDPtr],y               ;get info word
5987 BBA5 29 02 00              and   #UnRealBit               ;was this font scaled from another font?
5988 BBA8 D0 1E                 bne   NextID                   ;yes - so don't list it
5989 BBAA A0 02 00              ldy   #2
5990 BBAD              ;       ;** end addition **
5991 BBAD B7 30                 lda   [<IDPtr],y
5992 BBAF 29 00 FF              and   #$FF00                   ;get size
5993 BBB2 EB                    xba   
5994 BBB3 9B                    txy   
5995 BBB4 97 8E                 sta   [<temp1Ptr],y            ;and store in list member
5996 BBB6 E8                    inx   
5997 BBB7 E8                    inx   
5998 BBB8 E8                    inx   
5999 BBB9 E8                    inx   
6000 BBBA E8                    inx                            ;set index to next Size list member
6001 BBBB
6002 BBBB A0 F8 00              ldy   #(SizeListSize-FMParams)
6003 BBBE B7 4C                 lda   [<FMParamPtr],y
6004 BBC0 1A                    inc   a                        ;increment number of members in list
6005 BBC1 97 4C                 sta   [<FMParamPtr],y
6006 BBC3 C9 0C 00              cmp   #MaxSListCount           ;is Size list full?
6007 BBC6 F0 0B                 beq   BuildDone                ;yes
6008 BBC8 20 8D C0     NextID   jsr   IncIDPtr                 ;point to next ID entry
6009 BBCB E6 DA                 inc   <Count
6010 BBCD A5 DA                 lda   <Count
6011 BBCF C5 68                 cmp   <IDCount                 ;done with ID list?
6012 BBD1 D0 C7                 bne   BuildLoop                ;no
6013 BBD3
6014 BBD3 20 F2 C0     BuildDone jsr   UnLockIDList
6015 BBD6
6016 BBD6              ; create the list in the list control now
6017 BBD6 A2 00 00     doNewList ldx   #0
6018 BBD9 F4 FC 00 F4           PushLong #DrawSize             ; pointer to drawing routine
6019 BBDF F4 01 00              pea   1                        ; no member selected
6020 BBE2 A5 4C                 lda   <FMParamPtr
6021 BBE4 18                    clc   
6022 BBE5 69 28 01              adc   #(SizeList-FMParams)
6023 BBE8 A8                    tay   
6024 BBE9 A5 4E                 lda   <FMParamPtr+2
6025 BBEB 69 00 00              adc   #0
6026 BBEE 48                    pha   
6027 BBEF 5A                    phy                            ; reference to our size list
6028 BBF0 DA                    phx                            ; reference verb (pass by ptr)
6029 BBF1 A0 F8 00              ldy   #(SizeListSize-FMParams)
6030 BBF4 B7 4C                 lda   [<FMParamPtr],y          ; get the size of the list
6031 BBF6 48                    pha   
6032 BBF7 A5 EC 48 A5           PushLong <SizeCtlHandle 
6033 BBFD A2 1C 16 22           _NewList2                      ; and create the new list
6034 BC04 F4 FC 00 F4           PushLong #Sortsizes 
6035 BC0A A5 EC 48 A5           PushLong <SizeCtlHandle 
6036 BC10 A2 1C 15 22           _SortList2 
6037 BC17
6038 BC17              ; draw the new list and select the current size if available
6039 BC17 A0 F8 00              ldy   #(SizeListSize-FMParams)
6040 BC1A B7 4C                 lda   [<FMParamPtr],y          ;# of items in list
6041 BC1C F0 1F                 beq   NoSel2                   ;branch if no items in list
6042 BC1E 85 DA                 sta   <Count
6043 BC20              ;
6044 BC20              ;temp1Ptr still points to SizeList
6045 BC20              ;
6046 BC20 A0 00 00              ldy   #0                       ;index into Size list
6047 BC23 B7 8E        SelLoop2 lda   [<temp1Ptr],y            ;get size from list member
6048 BC25 C5 E4                 cmp   <CurSize                 ;same as current size?
6049 BC27 F0 0B                 beq   NoSel3                   ;yes - so select it
6050 BC29 C8                    iny                            ;no - so set index to next list member
6051 BC2A C8                    iny   
6052 BC2B C8                    iny   
6053 BC2C C8                    iny   
6054 BC2D C8                    iny   
6055 BC2E C6 DA                 dec   <Count                   ;done with list?
6056 BC30 D0 F1                 bne   SelLoop2                 ;no
6057 BC32 80 09                 bra   NoSel2
6058 BC34 A0 F8 00     NoSel3   ldy   #(SizeListSize-FMParams)
6059 BC37 B7 4C                 lda   [<FMParamPtr],y          ;# of items in list
6060 BC39 38                    sec   
6061 BC3A E5 DA                 sbc   <Count
6062 BC3C 1A                    inc   a
6063 BC3D 48           NoSel2   pha   
6064 BC3E A5 EC 48 A5           PushLong <SizeCtlHandle 
6065 BC44 A2 1C 14 22           _SelectMember2                 ;select correct member and redraw list
6066 BC4B 60                    rts   
6067 BC4C
6068 BC4C
6069 BC4C              ;-------------------------------------------------------------------------------
6070 BC4C              ;
6071 BC4C              ; Get new font size
6072 BC4C              ;
6073 BC4C              GetNewSize  
6074 BC4C 48                    pha   
6075 BC4D 48                    pha   
6076 BC4E 48                    pha   
6077 BC4F 48                    pha   
6078 BC50 D4 9E D4 9C           PushZLong <LineHndl            ;handle to LineEdit record
6079 BC54 A2 10 0D 22           _GetCtlTitle 
6080 BC5B A2 14 22 22           _LEGetTextHand                 ; get the text handle
6081 BC62
6082 BC62 68                    pla   
6083 BC63 85 00                 sta   <TempHandle              ;record
6084 BC65 68                    pla   
6085 BC66 85 02                 sta   <TempHandle+2
6086 BC68
6087 BC68              ;convert 'Other Size' string to an integer
6088 BC68              ;if length of string is 0, the Dec2Int routine will return a result of 0
6089 BC68
6090 BC68 48                    pha                            ;space for result
6091 BC69 A0 02 00              ldy   #2
6092 BC6C B7 00                 lda   [<TempHandle],y          ;ptr to size string
6093 BC6E 48                    pha   
6094 BC6F A7 00                 lda   [<TempHandle]
6095 BC71 48                    pha   
6096 BC72              ;
6097 BC72              ; Now get the text length
6098 BC72 48                    pha   
6099 BC73 48                    pha   
6100 BC74 48                    pha   
6101 BC75 D4 9E D4 9C           PushZLong <LineHndl            ;handle to LineEdit record
6102 BC79 A2 10 0D 22           _GetCtlTitle 
6103 BC80 A2 14 23 22           _LEGetTextLen 
6104 BC87
6105 BC87 F4 00 00              PushWord #0                    ;unsigned conversion
6106 BC8A A2 0B 28 22           _Dec2Int                       ;convert size string into an integer
6107 BC91 68                    pla                            ;get new size
6108 BC92 85 E4                 sta   <CurSize                 ;and save it
6109 BC94 60                    rts   
6110 BC95
6111 BC95              ;------------------------------------------------------------------------------
6112 BC95
6113 BC95              SetSizeText  
6114 BC95              ; push pointer to string:
6115 BC95 A5 4C                 lda   <FMParamPtr
6116 BC97 18                    clc   
6117 BC98 69 65 01              adc   #(TheStr-FMParams)
6118 BC9B AA                    tax                            ;temp storage
6119 BC9C A5 4E                 lda   <FMParamPtr+2
6120 BC9E 69 00 00              adc   #0
6121 BCA1 48                    pha   
6122 BCA2 DA                    phx   
6123 BCA3
6124 BCA3 A0 64 01              ldy   #(StrLen-FMParams)
6125 BCA6 B7 4C                 lda   [<FMParamPtr],y          ;length of string
6126 BCA8 29 FF 00              and   #$00FF
6127 BCAB 48                    pha                            ;length of string
6128 BCAC
6129 BCAC              ; Now we have to get the line edit control from the lineedit control
6130 BCAC 48                    pha   
6131 BCAD 48                    pha   
6132 BCAE D4 9E D4 9C           PushZLong <LineHndl            ;handle to LineEdit record
6133 BCB2 A2 10 0D 22           _GetCtlTitle 
6134 BCB9
6135 BCB9 A2 14 0B 22           _LESetText                     ;set the 'Other Size' text
6136 BCC0 60                    rts   
6137 BCC1
6138 BCC1              ;------------------------------------------------------------------------------
6139 BCC1
6140 BCC1 F4 00 00     SelectSizeText PushWord #0              ;selstart
6141 BCC4 F4 03 00              PushWord #3                    ;selend
6142 BCC7
6143 BCC7 48                    pha   
6144 BCC8 48                    pha   
6145 BCC9 D4 9E D4 9C           PushZLong <LineHndl            ;handle to LineEdit record
6146 BCCD A2 10 0D 22           _GetCtlTitle 
6147 BCD4
6148 BCD4 A2 14 0E 22           _LESetSelect                   ;select the 'Other Size' text
6149 BCDB 60                    rts   
6150 BCDC
6151 BCDC              ;-------------------------------------------------------------------------------
6152 BCDC              ;
6153 BCDC              ; Select the 'Other Size' text, put up an alert and then return
6154 BCDC              ;
6155 BCDC 20 C1 BC     DoAlert  jsr   SelectSizeText           ;select the 'Other Size' text
6156 BCDF
6157 BCDF A5 4C                 lda   <FMParamPtr
6158 BCE1 18                    clc   
6159 BCE2 69 7E 00              adc   #$7E
6160 BCE5 85 8E                 sta   <temp1ptr
6161 BCE7 A5 4E                 lda   <FMParamPtr+2
6162 BCE9 69 00 00              adc   #0
6163 BCEC 85 90                 sta   <temp1Ptr+2
6164 BCEE A6 96                 ldx   <ScreenMode
6165 BCF0 A0 00 00              ldy   #0
6166 BCF3 BD 0A A0     HBCF3    lda   AlertRect,x
6167 BCF6 97 8E                 sta   [<temp1Ptr],y
6168 BCF8 E8                    inx   
6169 BCF9 E8                    inx   
6170 BCFA C8                    iny   
6171 BCFB C8                    iny   
6172 BCFC C0 08 00              cpy   #8
6173 BCFF D0 F2                 bne   HBCF3
6174 BD01 48                    pha   
6175 BD02 A5 90 48 A5           PushLong <temp1Ptr 
6176 BD08 F4 00 00 F4           PushLong #0 
6177 BD0E A2 15 18 22           _StopAlert 
6178 BD15 68                    pla   
6179 BD16 60                    rts   
6180 BD17
6181 BD17                       ENDP 
6182 BD17
6183 BD17
6184 BD17              ****************************************************************
6185 BD17              *
6186 BD17              * BuildMDList
6187 BD17              *
6188 BD17              ****************************************************************
6189 BD17
6190 BD17                       ENTRY BuildMDList
6191 BD17              BuildMDList PROC 
6192 BD17              ;
6193 BD17              ****  Changed for ROMming purposes - BHM  x6245  12/10/87
6194 BD17              ****  many changes marked by a "*" for ease of debugging
6195 BD17              ;
6196 BD17
6197 BD17              Count    equ   Temp
6198 BD17              Mult2    equ   Count+2
6199 BD17              BaseOnly equ   Mult2+2
6200 BD17
6201 BD17              ;Create list of pointers to font famnames. Alphabetize the list.
6202 BD17
6203 BD17 A3 0B                 lda   11,s                     ;get FamSpecBits
6204 BD19 85 A4                 sta   <BaseOnly                ;and save for later
6205 BD1B 48                    pha                            ;space for result
6206 BD1C 48                    pha                            ;FamSpecBits
6207 BD1D 22 A6 BD FC           jsl   xCountFams               ;count # of families (all or base only
6208 BD21 68                    pla                            ;depending on FamSpecBits)
6209 BD22 85 A0                 sta   <Count
6210 BD24 0A                    asl   a
6211 BD25 0A                    asl   a
6212 BD26 0A                    asl   a                        ;mult # of fams by 8
6213 BD27 20 49 BF              jsr   GetHandle                ;allocate space for MD list
6214 BD2A 90 01                 bcc   GotMem
6215 BD2C 60                    rts                            ;return the error
6216 BD2D
6217 BD2D 85 1C        GotMem   sta   <MDHandle                ;save handle to MD list
6218 BD2F 86 1E                 stx   <MDHandle+2
6219 BD31
6220 BD31              *
6221 BD31
6222 BD31 A5 A0                 lda   <Count
6223 BD33 A0 D0 00              ldy   #(MDListSize-FMParams)
6224 BD36 97 4C                 sta   [<FMParamPtr],y          ;*  # of items in list
6225 BD38
6226 BD38 20 04 C1              jsr   LockNameList
6227 BD3B 20 F8 C0              jsr   LockFamList
6228 BD3E 20 2D C1              jsr   LockMDList
6229 BD41
6230 BD41 A5 44                 lda   <MDPtr                   ;get ptr to MD list
6231 BD43 A0 E4 00              ldy   #(MDListPtr-FMParams)
6232 BD46 97 4C                 sta   [<FMParamPtr],y          ;*and store in the MD list record
6233 BD48 A5 46                 lda   <MDPtr+2
6234 BD4A C8                    iny   
6235 BD4B C8                    iny   
6236 BD4C 97 4C                 sta   [<FMParamPtr],y
6237 BD4E
6238 BD4E A0 04 00     FamLoop  ldy   #4
6239 BD51 A5 A4                 lda   <BaseOnly                ;allow only base families?
6240 BD53 F0 07                 beq   Cont                     ;no - so skip this part
6241 BD55 B7 34                 lda   [<FamPtr],y              ;get info word
6242 BD57 29 20 00              and   #NotBaseBit              ;is this a base family?
6243 BD5A D0 23                 bne   NextFam                  ;no - so skip it
6244 BD5C
6245 BD5C A9 00 00     Cont     lda   #0
6246 BD5F 97 44                 sta   [<MDPtr],y               ;clear flags in MD list entry
6247 BD61
6248 BD61 88                    dey   
6249 BD62 88                    dey   
6250 BD63 18                    clc   
6251 BD64 A5 38                 lda   <NamePtr                 ;get ptr to start of Name list
6252 BD66 77 34                 adc   [<FamPtr],y              ;add offset to Name list entry
6253 BD68 87 44                 sta   [<MDPtr]                 ;to create a ptr to the Name list entry
6254 BD6A A5 3A                 lda   <NamePtr+2
6255 BD6C 69 00 00              adc   #0
6256 BD6F 97 44                 sta   [<MDPtr],y               ;store ptr to famname in MD list entry
6257 BD71
6258 BD71 A7 34                 lda   [<FamPtr]                ;get fam #
6259 BD73 A0 06 00              ldy   #6
6260 BD76 97 44                 sta   [<MDPtr],y               ;and store in MD list entry
6261 BD78 20 C0 C0              jsr   IncMDPtr                 ;point to next MD list entry
6262 BD7B C6 A0                 dec   <Count                   ;done with all families?
6263 BD7D F0 05                 beq   Done                     ;yes
6264 BD7F
6265 BD7F 20 9D C0     NextFam  jsr   IncFamPtr                ;check next family
6266 BD82 80 CA                 bra   FamLoop
6267 BD84
6268 BD84              Done      
6269 BD84              ; Sort the MD list entries so that they point
6270 BD84              ; to the famnames in alphabetical order
6271 BD84 F4 00 00 F4           PushLong #0 
6272 BD8A              *(push pointer to MDListRect)
6273 BD8A A6 4E                 ldx   <FMParamPtr+2            ;high word
6274 BD8C A5 4C                 lda   <FMParamPtr
6275 BD8E 18                    clc   
6276 BD8F 69 C8 00              adc   #(MDListRect-FMParams)
6277 BD92 90 01                 bcc   NoCarry
6278 BD94 E8                    inx   
6279 BD95 DA           NoCarry  phx   
6280 BD96 48                    pha   
6281 BD97              ;
6282 BD97 A2 1C 0A 22           _SortList 
6283 BD9E
6284 BD9E 20 FE C0              jsr   UnLockFamList
6285 BDA1 20 33 C1              jsr   UnLockMDList
6286 BDA4              ;
6287 BDA4 18                    clc   
6288 BDA5 60                    rts   
6289 BDA6
6290 BDA6 7B           xCountFams tdc   
6291 BDA7 22 01 AB FC           jsl   CountFamilies
6292 BDAB 6B                    rtl   
6293 BDAC
6294 BDAC                       ENDP 
6295 BDAC
6296 BDAC
6297 BDAC
6298 BDAC              ****************************************************************
6299 BDAC              *
6300 BDAC              * DrawGuts
6301 BDAC              *
6302 BDAC              ****************************************************************
6303 BDAC              **  Changed for ROMming purposes - BHM  x6245  1/11/88
6304 BDAC
6305 BDAC                       ENTRY DrawGuts
6306 BDAC              DrawGuts PROC 
6307 BDAC
6308 BDAC              ;This routine is called by the Window Manager in order to draw the
6309 BDAC              ;contents of the ChooseFont window.
6310 BDAC
6311 BDAC 8B                    phb   
6312 BDAD 4B                    phk   
6313 BDAE AB                    plb   
6314 BDAF 0B                    phd                            ;save direct register
6315 BDB0              ;get FM's 0-page
6316 BDB0 48                    pha                            ; space for result
6317 BDB1 48                    pha   
6318 BDB2 F4 00 00              PushWord #0                    ; SystemTool flag
6319 BDB5 F4 1B 00              PushWord #FMTSNum              ; our tool number
6320 BDB8 A2 01 0C 22           _GetWAP 
6321 BDBF 2B                    pld                            ;low word - FM's 0-pagese it
6322 BDC0 68                    pla                            ;high word - we don't use it
6323 BDC1              ;
6324 BDC1              ;dereference but do not lock FMParams:
6325 BDC1 A7 24                 lda   [<FMParamHandle]
6326 BDC3 85 4C                 sta   <FMParamPtr
6327 BDC5 A0 02 00              ldy   #2
6328 BDC8 B7 24                 lda   [<FMParamHandle],y
6329 BDCA 85 4E                 sta   <FMParamPtr+2
6330 BDCC A5 9A 48 A5           PushLong <WindPtr 
6331 BDD2 A2 10 10 22           _DrawControls 
6332 BDD9 48                    pha   
6333 BDDA 48                    pha   
6334 BDDB D4 9E D4 9C           PushzLong <LineHndl 
6335 BDDF A2 10 0D 22           _GetCtlTitle 
6336 BDE6 A2 14 17 22           _LEUpdate 
6337 BDED 48                    pha   
6338 BDEE 48                    pha   
6339 BDEF D4 9E D4 9C           PushZlong <LineHndl 
6340 BDF3 A2 10 0D 22           _GetCtlTitle 
6341 BDFA A2 14 0F 22           _LEActivate 
6342 BE01 2B                    pld   
6343 BE02 AB                    plb   
6344 BE03 6B                    rtl   
6345 BE04
6346 BE04                       ENDP 
6347 BE04
6348 BE04
6349 BE04
6350 BE04              ****************************************************************
6351 BE04              *
6352 BE04              * DrawSize
6353 BE04              *
6354 BE04              ****************************************************************
6355 BE04              ;
6356 BE04              ** Changed for ROMming purposes - BHM  x6245  1/11/87
6357 BE04              ;
6358 BE04                       ENTRY DrawSize
6359 BE04              DrawSize PROC 
6360 BE04
6361 BE04              ;This routine is called by the List Manager whenever it needs to draw
6362 BE04              ;a member of the 'Size' list in the ChooseFont window. Upon entry to this
6363 BE04              ;routine, the stack contains the following -
6364 BE04              ;
6365 BE04              ;  Space for result     4 bytes
6366 BE04              ;  Pointer to member's enclosing rect   4 bytes
6367 BE04              ;  Pointer to member's list entry       4 bytes
6368 BE04              ;  Handle to the list control   4 bytes
6369 BE04              ;  RTL      3 bytes
6370 BE04
6371 BE04 22 09 BE FC           jsl   Doit                     ;force another return address on stack
6372 BE08 6B                    rtl                            ;return to the List Manager
6373 BE09
6374 BE09 0B           Doit     phd                            ;save direct register
6375 BE0A              ;get FM's 0-page
6376 BE0A 48                    pha                            ; space for result
6377 BE0B 48                    pha   
6378 BE0C F4 00 00              PushWord #0                    ; SystemTool flag
6379 BE0F F4 1B 00              PushWord #FMTSNum              ; our tool number
6380 BE12 A2 01 0C 22           _GetWAP 
6381 BE19 2B                    pld                            ;low word - FM's 0-pagese it
6382 BE1A 68                    pla                            ;high word - we don't use it
6383 BE1B              ;
6384 BE1B              ;dereference but do not lock FMParams:
6385 BE1B A7 24                 lda   [<FMParamHandle]
6386 BE1D 85 4C                 sta   <FMParamPtr
6387 BE1F A0 02 00              ldy   #2
6388 BE22 B7 24                 lda   [<FMParamHandle],y
6389 BE24 85 4E                 sta   <FMParamPtr+2
6390 BE26              ;
6391 BE26 A3 0D                 lda   13,s                     ;get ptr to member's list entry
6392 BE28 85 8E                 sta   <temp1Ptr
6393 BE2A A3 0F                 lda   15,s
6394 BE2C 85 90                 sta   <temp1Ptr+2
6395 BE2E A7 8E                 lda   [<temp1Ptr]
6396 BE30              ;
6397 BE30 20 65 BE              jsr   MakeString               ;convert size into a string
6398 BE33              ;return ptr to string:
6399 BE33 A5 4C                 lda   <FMParamPtr
6400 BE35 18                    clc   
6401 BE36 69 64 01              adc   #(StrLen-FMParams)
6402 BE39 83 15                 sta   21,s
6403 BE3B A5 4E                 lda   <FMParamPtr+2
6404 BE3D 69 00 00              adc   #0
6405 BE40 83 17                 sta   23,s
6406 BE42
6407 BE42 A0 0C 00              ldy   #12                      ;param size
6408 BE45 5C B0 FC FE           jml   endcall                  ;use standard end call to strip params
6409 BE49                       ENDP 
6410 BE49
6411 BE49
6412 BE49
6413 BE49              ****************************************************************
6414 BE49              *
6415 BE49              * SortSizes
6416 BE49              *
6417 BE49              ****************************************************************
6418 BE49
6419 BE49                       ENTRY SortSizes
6420 BE49              SortSizes PROC 
6421 BE49
6422 BE49              ;This routine is called by the List Manager routine SortList in order
6423 BE49              ;to sort the 'Size' list in numerical order. Upon entry to this routine,
6424 BE49              ;the stack contains the following -
6425 BE49              ;
6426 BE49              ;  Pointer to member B's list entry     4 bytes
6427 BE49              ;  Pointer to member A's list entry     4 bytes
6428 BE49              ;  RTL      3 bytes
6429 BE49
6430 BE49 22 4E BE FC           jsl   Doit                     ;force another return address on stack
6431 BE4D 6B                    rtl                            ;return to the List Manager
6432 BE4E
6433 BE4E 0B           Doit     phd                            ;save direct register
6434 BE4F 3B                    tsc   
6435 BE50 5B                    tcd                            ;set direct register to point to stack
6436 BE51 A7 09                 lda   [9]                      ;get size from member A's list entry
6437 BE53 C7 0D                 cmp   [13]                     ;compare to size in member B's entry
6438 BE55 B0 07                 bcs   ABigger                  ;branch if member A is bigger
6439 BE57 A0 08 00              ldy   #8                       ;member B is bigger so return
6440 BE5A 5C B0 FC FE           jml   endcall                  ;with carry clear
6441 BE5E
6442 BE5E              ABigger   
6443 BE5E A0 08 00              ldy   #8                       ;member A is bigger so return
6444 BE61 5C B3 FC FE           jml   errout                   ;with carry set
6445 BE65                       ENDP 
6446 BE65
6447 BE65
6448 BE65
6449 BE65              ****************************************************************
6450 BE65              *
6451 BE65              * MakeString
6452 BE65              *
6453 BE65              ****************************************************************
6454 BE65              *
6455 BE65              **  changed for ROMming purposes - BHM  x6245  1/11/88
6456 BE65              **  due to changes in DrawSize, we now have the right 0-page.
6457 BE65                       ENTRY MakeString
6458 BE65              MakeString PROC 
6459 BE65
6460 BE65              ;This routine is called by ChooseFont and DrawSize.
6461 BE65              ;The calling routine has set A to be the 'size' which is to be converted
6462 BE65              ;into a string.
6463 BE65
6464 BE65
6465 BE65              ;convert size into a string
6466 BE65 48                    pha                            ;value to be converted to string
6467 BE66              ;
6468 BE66              ;push pointer to string
6469 BE66 A5 4C                 lda   <FMParamPtr
6470 BE68 18                    clc   
6471 BE69 69 65 01              adc   #(TheStr-FMParams)
6472 BE6C AA                    tax                            ;temporary storage
6473 BE6D A5 4E                 lda   <FMParamPtr+2
6474 BE6F 69 00 00              adc   #0
6475 BE72 48                    pha   
6476 BE73 85 90                 sta   <temp1Ptr+2              ;and save for later
6477 BE75 DA                    phx   
6478 BE76 86 8E                 stx   <temp1Ptr
6479 BE78              ;
6480 BE78 F4 03 00              PushWord #3                    ;string length
6481 BE7B F4 00 00              PushWord #0                    ;unsigned conversion
6482 BE7E A2 0B 26 22           _Int2Dec 
6483 BE85
6484 BE85              ;remove leading blanks from size string
6485 BE85
6486 BE85 A2 03 00              ldx   #3                       ;length, with blanks
6487 BE88              RemoveBlanks                            ;
6488 BE88 A7 8E                 lda   [<temp1Ptr]
6489 BE8A 29 FF 00              and   #$00FF
6490 BE8D C9 20 00              cmp   #$20
6491 BE90 D0 0B                 bne   Done
6492 BE92 A0 01 00              ldy   #1
6493 BE95 B7 8E                 lda   [<temp1Ptr],y
6494 BE97 88                    dey   
6495 BE98 97 8E                 sta   [<temp1Ptr],y
6496 BE9A CA                    dex   
6497 BE9B 80 EB                 bra   RemoveBlanks
6498 BE9D              ;
6499 BE9D 86 92        Done     stx   <temp2Ptr                ;actual length, temp storage
6500 BE9F A7 8E                 lda   [<temp1Ptr]              ;first 2 characters in string
6501 BEA1 29 FF 00              and   #$00FF                   ;first 1
6502 BEA4 EB                    xba                            ;move it up a byte
6503 BEA5 05 92                 ora   <temp2Ptr                ;and merge string length in
6504 BEA7              ;
6505 BEA7 A0 64 01              ldy   #(StrLen-FMParams)       ;put 'em back
6506 BEAA 97 4C                 sta   [<FMParamPtr],y
6507 BEAC              ;
6508 BEAC 60                    rts   
6509 BEAD                       ENDP 
6510 BEAD
6511 BEAD
6512 BEAD              ;                COPY stdstuff
6513 BEAD              ****  ProDOS calls changed - 11/4/87
6514 BEAD              ;the ProDOS calls now go through the stack-based entry point, and
6515 BEAD              ;are no longer self-modifying.  Also, except for GetDirEntry, they
6516 BEAD              ;all share parameter block space on 0-page.  Note that the refernce
6517 BEAD              ;number - OpenRef, ReadRef, etc. - are actually all the same location.
6518 BEAD              ;In particular, after an Open call, the new ref number is in place for
6519 BEAD              ;a read call. - BHM  x6245
6520 BEAD              ;
6521 BEAD              ;These ProDOS calls are all the same except for the call number, so
6522 BEAD              ;we may combine them in the future.  Pre-computing and saving the
6523 BEAD              ;ProDOSParams address would also save a little time and space.
6524 BEAD              ;(Very little.)
6525 BEAD              ;
6526 BEAD              ****************************************************************
6527 BEAD              *
6528 BEAD              * CreateFile
6529 BEAD              *
6530 BEAD              ****************************************************************
6531 BEAD
6532 BEAD                       ENTRY CreateFile
6533 BEAD              CreateFile PROC 
6534 BEAD
6535 BEAD F4 00 00              pea   0                        ;high word of parameter block address
6536 BEB0
6537 BEB0 7B                    tdc   
6538 BEB1 18                    clc   
6539 BEB2 69 6C 00              adc   #ProDOSParams            ;low word
6540 BEB5 48                    pha   
6541 BEB6
6542 BEB6 F4 01 00              pea   CreateCall               ;call number
6543 BEB9
6544 BEB9 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6545 BEBD
6546 BEBD AA                    tax                            ;error code (if any)
6547 BEBE 60                    rts   
6548 BEBF                       ENDP 
6549 BEBF
6550 BEBF              ****************************************************************
6551 BEBF              *
6552 BEBF              * OpenFile
6553 BEBF              *
6554 BEBF              ****************************************************************
6555 BEBF
6556 BEBF                       ENTRY OpenFile
6557 BEBF              OpenFile PROC 
6558 BEBF
6559 BEBF F4 00 00              pea   0                        ;high word of parameter block address
6560 BEC2
6561 BEC2 7B                    tdc   
6562 BEC3 18                    clc   
6563 BEC4 69 6C 00              adc   #ProDOSParams            ;low word
6564 BEC7 48                    pha   
6565 BEC8
6566 BEC8 F4 10 00              pea   OpenCall                 ;call number
6567 BECB
6568 BECB 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6569 BECF
6570 BECF AA                    tax                            ;error code (if any)
6571 BED0 60                    rts   
6572 BED1                       ENDP 
6573 BED1
6574 BED1              ****************************************************************
6575 BED1              *
6576 BED1              * ReadFile
6577 BED1              *
6578 BED1              ****************************************************************
6579 BED1
6580 BED1                       ENTRY ReadFile
6581 BED1              ReadFile PROC 
6582 BED1
6583 BED1 F4 00 00              pea   0                        ;high word of parameter block address
6584 BED4
6585 BED4 7B                    tdc   
6586 BED5 18                    clc   
6587 BED6 69 6C 00              adc   #ProDOSParams            ;low word
6588 BED9 48                    pha   
6589 BEDA
6590 BEDA F4 12 00              pea   ReadCall                 ;call number
6591 BEDD
6592 BEDD 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6593 BEE1
6594 BEE1 AA                    tax                            ;error code (if any)
6595 BEE2 60                    rts   
6596 BEE3                       ENDP 
6597 BEE3
6598 BEE3              ****************************************************************
6599 BEE3              *
6600 BEE3              * WriteFile
6601 BEE3              *
6602 BEE3              ****************************************************************
6603 BEE3
6604 BEE3                       ENTRY WriteFile
6605 BEE3              WriteFile PROC 
6606 BEE3
6607 BEE3 F4 00 00              pea   0                        ;high word of parameter block address
6608 BEE6
6609 BEE6 7B                    tdc   
6610 BEE7 18                    clc   
6611 BEE8 69 6C 00              adc   #ProDOSParams            ;low word
6612 BEEB 48                    pha   
6613 BEEC
6614 BEEC F4 13 00              pea   WriteCall                ;call number
6615 BEEF
6616 BEEF 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6617 BEF3
6618 BEF3 AA                    tax                            ;error code (if any)
6619 BEF4 60                    rts   
6620 BEF5                       ENDP 
6621 BEF5
6622 BEF5              ****************************************************************
6623 BEF5              *
6624 BEF5              * CloseFile
6625 BEF5              *
6626 BEF5              ****************************************************************
6627 BEF5
6628 BEF5                       ENTRY CloseFile
6629 BEF5              CloseFile PROC 
6630 BEF5
6631 BEF5 F4 00 00              pea   0                        ;high word of parameter block address
6632 BEF8
6633 BEF8 7B                    tdc   
6634 BEF9 18                    clc   
6635 BEFA 69 6C 00              adc   #ProDOSParams            ;low word
6636 BEFD 48                    pha   
6637 BEFE
6638 BEFE F4 14 00              pea   CloseCall                ;call number
6639 BF01
6640 BF01 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6641 BF05
6642 BF05 AA                    tax                            ;error code (if any)
6643 BF06 60                    rts   
6644 BF07                       ENDP 
6645 BF07
6646 BF07              ****************************************************************
6647 BF07              *
6648 BF07              * SetMark
6649 BF07              *
6650 BF07              ****************************************************************
6651 BF07
6652 BF07                       ENTRY SetMark
6653 BF07              SetMark  PROC 
6654 BF07
6655 BF07 F4 00 00              pea   0                        ;high word of parameter block address
6656 BF0A
6657 BF0A 7B                    tdc   
6658 BF0B 18                    clc   
6659 BF0C 69 6C 00              adc   #ProDOSParams            ;low word
6660 BF0F 48                    pha   
6661 BF10
6662 BF10 F4 16 00              pea   SetMarkCall              ;call number
6663 BF13
6664 BF13 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6665 BF17
6666 BF17 AA                    tax                            ;error code (if any)
6667 BF18 60                    rts   
6668 BF19                       ENDP 
6669 BF19
6670 BF19              ****************************************************************
6671 BF19              *
6672 BF19              * GetEOF
6673 BF19              *
6674 BF19              ****************************************************************
6675 BF19
6676 BF19                       ENTRY GetEOF
6677 BF19              GetEOF   PROC 
6678 BF19
6679 BF19 F4 00 00              pea   0                        ;high word of parameter block address
6680 BF1C
6681 BF1C 7B                    tdc   
6682 BF1D 18                    clc   
6683 BF1E 69 6C 00              adc   #ProDOSParams            ;low word
6684 BF21 48                    pha   
6685 BF22
6686 BF22 F4 19 00              pea   GetEOFCall               ;call number
6687 BF25
6688 BF25 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6689 BF29
6690 BF29 AA                    tax                            ;error code (if any)
6691 BF2A 60                    rts   
6692 BF2B                       ENDP 
6693 BF2B              ;
6694 BF2B              ****************************************************************
6695 BF2B              *
6696 BF2B              * SetEOF
6697 BF2B              *
6698 BF2B              ****************************************************************
6699 BF2B
6700 BF2B                       ENTRY SetEOF
6701 BF2B              SetEOF   PROC 
6702 BF2B
6703 BF2B F4 00 00              pea   0                        ;high word of parameter block address
6704 BF2E
6705 BF2E 7B                    tdc   
6706 BF2F 18                    clc   
6707 BF30 69 6C 00              adc   #ProDOSParams            ;low word
6708 BF33 48                    pha   
6709 BF34
6710 BF34 F4 18 00              pea   SetEOFCall               ;call number
6711 BF37
6712 BF37 22 B0 00 E1           jsl   StackProDOS              ;ProDOS/16 stack-based entry vector
6713 BF3B
6714 BF3B AA                    tax                            ;error code (if any)
6715 BF3C 60                    rts   
6716 BF3D                       ENDP 
6717 BF3D
6718 BF3D
6719 BF3D              ****************************************************************
6720 BF3D              *
6721 BF3D              * GetDirEntry
6722 BF3D              *
6723 BF3D              ****************************************************************
6724 BF3D
6725 BF3D                       ENTRY GetDirEntry
6726 BF3D              GetDirEntry PROC 
6727 BF3D              ;
6728 BF3D              ;GetDirEntry is a little different because its parameter block is in
6729 BF3D              ;the FMParams RAM block, rather than on 0-page
6730 BF3D              ;
6731 BF3D D4 4E D4 4C           PushZLong <FMParamPtr 
6732 BF41 F4 1C 00              pea   GDECall
6733 BF44 22 B0 00 E1           jsl   $E100B0
6734 BF48 60                    rts   
6735 BF49                       ENDP 
6736 BF49              ;
6737 BF49
6738 BF49
6739 BF49              ;
6740 BF49              ****  end of changed ProDOS calls - BHM  x6245  11/4/87
6741 BF49              ;
6742 BF49
6743 BF49
6744 BF49              ****************************************************************
6745 BF49              *
6746 BF49              * GetHandle
6747 BF49              *
6748 BF49              ****************************************************************
6749 BF49
6750 BF49                       ENTRY GetHandle
6751 BF49              GetHandle PROC 
6752 BF49
6753 BF49              ;
6754 BF49              ; Call the Memory Manager to get a block of memory.  The calling routine has put
6755 BF49              ; the low word of the requested size in A.  The handle is returned in A and X.
6756 BF49              ;
6757 BF49 A0 00 00              ldy   #0
6758 BF4C 5A                    phy                            ;space for result
6759 BF4D 5A                    phy   
6760 BF4E 5A                    phy   
6761 BF4F 48                    pha                            ;lo word of size (set by calling proc)
6762 BF50 D4 84                 PushZWord <ProgID              ;ID
6763 BF52 5A                    phy                            ;unpurgeable
6764 BF53 5A                    phy                            ;loc not important
6765 BF54 5A                    phy   
6766 BF55 A2 02 09 22           _NewHandle                     ;allocate space
6767 BF5C 90 04                 bcc   OK
6768 BF5E AA                    tax                            ;error code
6769 BF5F 68                    pla                            ;clean up
6770 BF60 68                    pla   
6771 BF61 60                    rts   
6772 BF62
6773 BF62 68           OK       pla                            ;pull handle off stack
6774 BF63 FA                    plx   
6775 BF64 60                    rts                            ;and return it
6776 BF65                       ENDP 
6777 BF65
6778 BF65
6779 BF65
6780 BF65              ****************************************************************
6781 BF65              *
6782 BF65              * CheckHandle
6783 BF65              *
6784 BF65              ****************************************************************
6785 BF65
6786 BF65                       ENTRY CheckHandle
6787 BF65              CheckHandle PROC 
6788 BF65
6789 BF65              ;Check to see if the font handle in the ID list entry pointed to by IDPtr
6790 BF65              ;is a valid handle.  Also, store the handle in FontHandle for future use
6791 BF65              ;by the calling routine.
6792 BF65
6793 BF65 A0 0A 00              ldy   #10
6794 BF68 B7 30                 lda   [<IDPtr],y               ;get handle to font and save for
6795 BF6A 85 14                 sta   <FontHandle              ;future use by the calling proc
6796 BF6C C8                    iny   
6797 BF6D C8                    iny   
6798 BF6E B7 30                 lda   [<IDPtr],y
6799 BF70 85 16                 sta   <FontHandle+2
6800 BF72 05 14                 ora   <FontHandle              ;return 'not equal' if handle is valid
6801 BF74 60                    rts                            ;else return 'equal'
6802 BF75                       ENDP 
6803 BF75
6804 BF75
6805 BF75
6806 BF75              ****************************************************************
6807 BF75              *
6808 BF75              * CheckNil
6809 BF75              *
6810 BF75              ****************************************************************
6811 BF75
6812 BF75                       ENTRY CheckNil
6813 BF75              CheckNil PROC 
6814 BF75
6815 BF75              ;Check to see if the handle contained in FontHandle is nil.
6816 BF75
6817 BF75 A7 14                 lda   [<FontHandle]
6818 BF77 A0 02 00              ldy   #2
6819 BF7A 17 14                 ora   [<FontHandle],y          ;return 'not equal' if handle is not
6820 BF7C 60                    rts                            ;nil, else return 'equal'
6821 BF7D                       ENDP 
6822 BF7D
6823 BF7D
6824 BF7D
6825 BF7D              ****************************************************************
6826 BF7D              *
6827 BF7D              * CheckFontID
6828 BF7D              *
6829 BF7D              ****************************************************************
6830 BF7D
6831 BF7D                       ENTRY CheckFontID
6832 BF7D              CheckFontID PROC 
6833 BF7D
6834 BF7D              ;Y contains fam # to check.  A contains style/size to check.
6835 BF7D              ;If fam # = 0, convert it to system font's fam #.
6836 BF7D              ;If fam # and style/size = 0, convert both to system font ID.
6837 BF7D              ;If fam # = $FFFF, return error.
6838 BF7D              ;If fam # <> 0 and size = 0, return error.
6839 BF7D
6840 BF7D C0 FF FF              cpy   #Illegal                 ;illegal fam #?
6841 BF80 D0 05                 bne   NumOK                    ;no
6842 BF82 A2 08 1B              ldx   #FamNumErr               ;yes - so return error
6843 BF85 38                    sec   
6844 BF86 60                    rts   
6845 BF87
6846 BF87 C0 00 00     NumOK    cpy   #0                       ;is fam # 0?
6847 BF8A D0 0B                 bne   NotZero                  ;no
6848 BF8C A4 86                 ldy   <SysFontID               ;convert fam # of 0 to system fam #
6849 BF8E C9 00 00              cmp   #0                       ;is style/size 0?
6850 BF91 D0 04                 bne   NotZero                  ;no
6851 BF93 A5 88                 lda   <SysFontID+2             ;convert to system style/size
6852 BF95 18                    clc   
6853 BF96 60                    rts   
6854 BF97
6855 BF97 48           NotZero  pha                            ;save style/size
6856 BF98 29 00 FF              and   #$FF00                   ;get size
6857 BF9B D0 06                 bne   SizeOK                   ;OK if not 0
6858 BF9D 68                    pla                            ;clean up
6859 BF9E A2 09 1B              ldx   #SizeErr                 ;return error
6860 BFA1 38                    sec   
6861 BFA2 60                    rts   
6862 BFA3
6863 BFA3 68           SizeOK   pla                            ;retrieve style/size
6864 BFA4 18                    clc   
6865 BFA5 60                    rts   
6866 BFA6                       ENDP 
6867 BFA6
6868 BFA6
6869 BFA6
6870 BFA6              ****************************************************************
6871 BFA6              *
6872 BFA6              * CheckSysFont
6873 BFA6              *
6874 BFA6              ****************************************************************
6875 BFA6
6876 BFA6                       ENTRY CheckSysFont
6877 BFA6              CheckSysFont PROC 
6878 BFA6
6879 BFA6              ;Check to see if the ID list entry pointed to by IDPtr is the system font.
6880 BFA6
6881 BFA6 A7 30                 lda   [<IDPtr]
6882 BFA8 C5 86                 cmp   <SysFontID               ;does fam # match?
6883 BFAA D0 07                 bne   Ret                      ;no - so return 'not equal'
6884 BFAC A0 02 00              ldy   #2
6885 BFAF B7 30                 lda   [<IDPtr],y
6886 BFB1 C5 88                 cmp   <SysFontID+2             ;does style/size match?
6887 BFB3 60           Ret      rts                            ;return 'equal' if fam # and size/style
6888 BFB4                       ENDP 
6889 BFB4
6890 BFB4
6891 BFB4
6892 BFB4              ****************************************************************
6893 BFB4              *
6894 BFB4              * CopyFamName
6895 BFB4              *
6896 BFB4              ****************************************************************
6897 BFB4
6898 BFB4                       ENTRY CopyFamName
6899 BFB4              CopyFamName PROC 
6900 BFB4
6901 BFB4              ;Copy the font family name pointed to by TempPtr into the Name list entry
6902 BFB4              ;pointed to by NamePtr.
6903 BFB4
6904 BFB4 A7 28                 lda   [<TempPtr]
6905 BFB6 29 FF 00              and   #$00FF                   ;get length of name
6906 BFB9 C9 1A 00              cmp   #MaxNameLen+1            ;is length OK ?
6907 BFBC 90 03                 bcc   OK                       ;yes
6908 BFBE A9 19 00              lda   #MaxNameLen              ;no, it's too long - so truncate name
6909 BFC1 48           OK       pha                            ;save new length for later
6910 BFC2 A8                    tay   
6911 BFC3 88                    dey   
6912 BFC4 B7 28        Loop     lda   [<TempPtr],y             ;copy name into famname list
6913 BFC6 97 38                 sta   [<NamePtr],y
6914 BFC8 88                    dey   
6915 BFC9 F0 F9                 beq   Loop
6916 BFCB 88                    dey   
6917 BFCC 10 F6                 bpl   Loop
6918 BFCE
6919 BFCE A7 38                 lda   [<NamePtr]               ;get first word of name
6920 BFD0 29 00 FF              and   #$FF00                   ;mask off length byte
6921 BFD3 03 01                 ora   1,s                      ;OR with new length byte
6922 BFD5 87 38                 sta   [<NamePtr]               ;and save
6923 BFD7 68                    pla                            ;clean up
6924 BFD8 60                    rts   
6925 BFD9                       ENDP 
6926 BFD9
6927 BFD9
6928 BFD9
6929 BFD9              ****************************************************************
6930 BFD9              *
6931 BFD9              * CopyFileName
6932 BFD9              *
6933 BFD9              ****************************************************************
6934 BFD9
6935 BFD9                       ENTRY CopyFileName
6936 BFD9              CopyFileName PROC 
6937 BFD9              ****  changed to use FMParams block - BHM  x6245  11/12/87
6938 BFD9              ;
6939 BFD9              ;Copy the file name pointed to by FilePtr into the data string FileName.
6940 BFD9              ;Adjust the string length of the complete pathname accordingly.
6941 BFD9
6942 BFD9              ;
6943 BFD9 A5 4C                 lda   <FMParamPtr
6944 BFDB 18                    clc   
6945 BFDC 69 53 00              adc   #(FileName-FMParams)
6946 BFDF 85 28                 sta   <tempPtr                 ;point to filename space
6947 BFE1 A5 4E                 lda   <FMParamPtr+2
6948 BFE3 69 00 00              adc   #0
6949 BFE6 85 2A                 sta   <tempPtr+2
6950 BFE8
6951 BFE8
6952 BFE8 A7 2C                 lda   [<FilePtr]
6953 BFEA 29 FF 00              and   #$00FF                   ;get length of name
6954 BFED A8                    tay   
6955 BFEE 18                    clc   
6956 BFEF 69 0F 00              adc   #DirNameLen+1            ;add length of '*:SYSTEM:FONTS:'
6957 BFF2 48                    pha                            ;save for later
6958 BFF3 88                    dey   
6959 BFF4              Loop                                    ;
6960 BFF4 B7 2C                 lda   [<FilePtr],y             ;copy name into pathname string
6961 BFF6 97 28                 sta   [<tempPtr],y
6962 BFF8 88                    dey   
6963 BFF9 88                    dey   
6964 BFFA 10 F8                 bpl   Loop
6965 BFFC
6966 BFFC A0 53 00              ldy   #(FileName-FMParams)
6967 BFFF B7 4C                 lda   [<FMParamPtr],y
6968 C001 29 00 FF              and   #$FF00                   ;get first byte of filename and make
6969 C004 09 2F 00              ora   #$2F                     ;sure it's a '/'
6970 C007 97 4C                 sta   [<FMParamPtr],y
6971 C009
6972 C009 A0 44 00              ldy   #(DirName-FMParams)
6973 C00C B7 4C                 lda   [<FMParamPtr],y          ;get first word of pathname
6974 C00E 29 00 FF              and   #$FF00                   ;mask off length byte
6975 C011 03 01                 ora   1,s                      ;OR with new length byte
6976 C013 97 4C                 sta   [<FMParamPtr],y          ;and save
6977 C015 68                    pla                            ;clean up
6978 C016 60                    rts   
6979 C017                       ENDP 
6980 C017
6981 C017
6982 C017
6983 C017              ****************************************************************
6984 C017              *
6985 C017              * MakeCurrent
6986 C017              *
6987 C017              ****************************************************************
6988 C017
6989 C017                       ENTRY MakeCurrent
6990 C017              MakeCurrent PROC 
6991 C017
6992 C017              ;Make the font pointed to by FontPtr the current font.  IDPtr must point
6993 C017              ;to the font's ID list entry.
6994 C017
6995 C017 D4 16 D4 14           PushZLong <FontHandle 
6996 C01B A2 04 94 22           _SetFont                       ;make font the current font
6997 C022
6998 C022              ;grow the QuickDraw text buffer if needed
6999 C022
7000 C022 A0 08 00              ldy   #8
7001 C025 B7 3C                 lda   [<FontPtr],y             ;get version # of font
7002 C027 C9 00 01              cmp   #$0100                   ;version 1.0 ?
7003 C02A F0 07                 beq   RomFont                  ;yes - so handle differently
7004 C02C A0 0A 00              ldy   #10
7005 C02F B7 3C                 lda   [<FontPtr],y             ;get 'fbrExtent' field
7006 C031 80 02                 bra   PushWidth
7007 C033
7008 C033 A5 8A        RomFont  lda   <RomFbrExtent            ;get 'fbrExtent' for ROM font
7009 C035
7010 C035 48           PushWidth pha   
7011 C036 18                    clc   
7012 C037 A7 3C                 lda   [<FontPtr]               ;get 'OffsetToMF' field (in words)
7013 C039 0A                    asl   a                        ;convert to bytes
7014 C03A 69 0E 00              adc   #14
7015 C03D A8                    tay   
7016 C03E B7 3C                 lda   [<FontPtr],y             ;get 'fRectHeight' field
7017 C040 48                    pha   
7018 C041 A2 04 D7 22           _InflateTextBuffer             ;grow QuickDraw text buffer if needed
7019 C048
7020 C048              ;set fields in the QuickDraw GrafPort
7021 C048
7022 C048 A0 02 00              ldy   #2                       ;get font ID
7023 C04B B7 30                 lda   [<IDPtr],y
7024 C04D 48                    pha   
7025 C04E A7 30                 lda   [<IDPtr]
7026 C050 48                    pha   
7027 C051 A2 04 D0 22           _SetFontID                     ;set the fontID field in the grafport
7028 C058
7029 C058 A0 02 00              ldy   #2
7030 C05B B7 30                 lda   [<IDPtr],y               ;get font style
7031 C05D 29 FF 00              and   #$00FF
7032 C060 48                    pha   
7033 C061 A2 04 9A 22           _SetTextFace                   ;set text face field in the grafport
7034 C068
7035 C068 A0 02 00              ldy   #2
7036 C06B B7 30                 lda   [<IDPtr],y               ;get font size
7037 C06D 29 00 FF              and   #$FF00
7038 C070 EB                    xba   
7039 C071 48                    pha   
7040 C072 A2 04 D2 22           _SetTextSize                   ;set text size field in the grafport
7041 C079
7042 C079 60                    rts   
7043 C07A
7044 C07A
7045 C07A                       ENDP 
7046 C07A
7047 C07A
7048 C07A
7049 C07A              ****************************************************************
7050 C07A              *
7051 C07A              * IncFilePtr
7052 C07A              *
7053 C07A              ****************************************************************
7054 C07A
7055 C07A                       ENTRY IncFilePtr
7056 C07A              IncFilePtr PROC 
7057 C07A
7058 C07A              ;Increment FilePtr to point to the next entry in the File list.
7059 C07A
7060 C07A A7 2C                 lda   [<FilePtr]               ;get filename length
7061 C07C 29 0F 00              and   #$000F                   ;mask off all but length nibble
7062 C07F 1A                    inc   a                        ;add 1 for the length byte itself
7063 C080 18                    clc   
7064 C081 65 2C                 adc   <FilePtr                 ;add to filename ptr
7065 C083 85 2C                 sta   <FilePtr                 ;to create ptr to next filename in list
7066 C085 A5 2E                 lda   <FilePtr+2
7067 C087 69 00 00              adc   #0
7068 C08A 85 2E                 sta   <FilePtr+2
7069 C08C 60                    rts   
7070 C08D                       ENDP 
7071 C08D
7072 C08D
7073 C08D
7074 C08D              ****************************************************************
7075 C08D              *
7076 C08D              * IncIDPtr
7077 C08D              *
7078 C08D              ****************************************************************
7079 C08D
7080 C08D                       ENTRY IncIDPtr
7081 C08D              IncIDPtr PROC 
7082 C08D
7083 C08D              ;Increment IDPtr to point to the next entry in the ID list.
7084 C08D
7085 C08D 18                    clc   
7086 C08E A5 30                 lda   <IDPtr
7087 C090 69 0E 00              adc   #14
7088 C093 85 30                 sta   <IDPtr
7089 C095 A5 32                 lda   <IDPtr+2
7090 C097 69 00 00              adc   #0
7091 C09A 85 32                 sta   <IDPtr+2
7092 C09C 60                    rts   
7093 C09D                       ENDP 
7094 C09D
7095 C09D
7096 C09D
7097 C09D              ****************************************************************
7098 C09D              *
7099 C09D              * IncFamPtr
7100 C09D              *
7101 C09D              ****************************************************************
7102 C09D
7103 C09D                       ENTRY IncFamPtr
7104 C09D              IncFamPtr PROC 
7105 C09D
7106 C09D              ;Increment FamPtr to point to the next entry in the Fam list.
7107 C09D
7108 C09D 18                    clc   
7109 C09E A5 34                 lda   <FamPtr
7110 C0A0 69 06 00              adc   #6
7111 C0A3 85 34                 sta   <FamPtr
7112 C0A5 A5 36                 lda   <FamPtr+2
7113 C0A7 69 00 00              adc   #0
7114 C0AA 85 36                 sta   <FamPtr+2
7115 C0AC 60                    rts   
7116 C0AD                       ENDP 
7117 C0AD
7118 C0AD
7119 C0AD
7120 C0AD              ****************************************************************
7121 C0AD              *
7122 C0AD              * IncNamePtr
7123 C0AD              *
7124 C0AD              ****************************************************************
7125 C0AD
7126 C0AD                       ENTRY IncNamePtr
7127 C0AD              IncNamePtr PROC 
7128 C0AD
7129 C0AD              ;Increment NamePtr to point to the next entry in the Name list.
7130 C0AD
7131 C0AD A7 38                 lda   [<NamePtr]               ;get famname length
7132 C0AF 29 FF 00              and   #$00FF
7133 C0B2 1A                    inc   a                        ;add 1 for the length byte itself
7134 C0B3 18                    clc   
7135 C0B4 65 38                 adc   <NamePtr                 ;add to famname ptr
7136 C0B6 85 38                 sta   <NamePtr                 ;to create ptr to next famname in list
7137 C0B8 A5 3A                 lda   <NamePtr+2
7138 C0BA 69 00 00              adc   #0
7139 C0BD 85 3A                 sta   <NamePtr+2
7140 C0BF 60                    rts   
7141 C0C0                       ENDP 
7142 C0C0
7143 C0C0
7144 C0C0
7145 C0C0              ****************************************************************
7146 C0C0              *
7147 C0C0              * IncMDPtr
7148 C0C0              *
7149 C0C0              ****************************************************************
7150 C0C0
7151 C0C0                       ENTRY IncMDPtr
7152 C0C0              IncMDPtr PROC 
7153 C0C0
7154 C0C0              ;Increment MDPtr to point to the next entry in the MD list.
7155 C0C0
7156 C0C0 18                    clc   
7157 C0C1 A5 44                 lda   <MDPtr
7158 C0C3 69 08 00              adc   #8
7159 C0C6 85 44                 sta   <MDPtr
7160 C0C8 A5 46                 lda   <MDPtr+2
7161 C0CA 69 00 00              adc   #0
7162 C0CD 85 46                 sta   <MDPtr+2
7163 C0CF 60                    rts   
7164 C0D0                       ENDP 
7165 C0D0
7166 C0D0
7167 C0D0
7168 C0D0              ****************************************************************
7169 C0D0              *
7170 C0D0              * IncItemPtr
7171 C0D0              *
7172 C0D0              ****************************************************************
7173 C0D0
7174 C0D0                       ENTRY IncItemPtr
7175 C0D0              IncItemPtr PROC 
7176 C0D0
7177 C0D0              ;Increment ItemPtr to point to the next entry in the Item list.
7178 C0D0
7179 C0D0 18                    clc   
7180 C0D1 A5 48                 lda   <ItemPtr
7181 C0D3 69 02 00              adc   #2
7182 C0D6 85 48                 sta   <ItemPtr
7183 C0D8 A5 4A                 lda   <ItemPtr+2
7184 C0DA 69 00 00              adc   #0
7185 C0DD 85 4A                 sta   <ItemPtr+2
7186 C0DF 60                    rts   
7187 C0E0                       ENDP 
7188 C0E0
7189 C0E0
7190 C0E0
7191 C0E0              ****************************************************************
7192 C0E0              *
7193 C0E0              * LockFileList
7194 C0E0              *
7195 C0E0              ****************************************************************
7196 C0E0
7197 C0E0                       ENTRY LockFileList
7198 C0E0              LockFileList PROC 
7199 C0E0 A2 04 00              ldx   #4
7200 C0E3 4C 51 C1              jmp   Lock
7201 C0E6                       ENDP 
7202 C0E6
7203 C0E6
7204 C0E6
7205 C0E6              ****************************************************************
7206 C0E6              *
7207 C0E6              * UnLockFileList
7208 C0E6              *
7209 C0E6              ****************************************************************
7210 C0E6
7211 C0E6                       ENTRY UnLockFileList
7212 C0E6              UnLockFileList PROC 
7213 C0E6 A2 04 00              ldx   #4
7214 C0E9 4C 6F C1              jmp   UnLock
7215 C0EC                       ENDP 
7216 C0EC
7217 C0EC
7218 C0EC
7219 C0EC              ****************************************************************
7220 C0EC              *
7221 C0EC              * LockIDList
7222 C0EC              *
7223 C0EC              ****************************************************************
7224 C0EC
7225 C0EC                       ENTRY LockIDList
7226 C0EC              LockIDList PROC 
7227 C0EC A2 08 00              ldx   #8
7228 C0EF 4C 51 C1              jmp   Lock
7229 C0F2                       ENDP 
7230 C0F2
7231 C0F2
7232 C0F2
7233 C0F2              ****************************************************************
7234 C0F2              *
7235 C0F2              * UnLockIDList
7236 C0F2              *
7237 C0F2              ****************************************************************
7238 C0F2
7239 C0F2                       ENTRY UnLockIDList
7240 C0F2              UnLockIDList PROC 
7241 C0F2 A2 08 00              ldx   #8
7242 C0F5 4C 6F C1              jmp   UnLock
7243 C0F8                       ENDP 
7244 C0F8
7245 C0F8
7246 C0F8
7247 C0F8              ****************************************************************
7248 C0F8              *
7249 C0F8              * LockFamList
7250 C0F8              *
7251 C0F8              ****************************************************************
7252 C0F8
7253 C0F8                       ENTRY LockFamList
7254 C0F8              LockFamList PROC 
7255 C0F8 A2 0C 00              ldx   #12
7256 C0FB 4C 51 C1              jmp   Lock
7257 C0FE                       ENDP 
7258 C0FE
7259 C0FE
7260 C0FE
7261 C0FE              ****************************************************************
7262 C0FE              *
7263 C0FE              * UnLockFamList
7264 C0FE              *
7265 C0FE              ****************************************************************
7266 C0FE
7267 C0FE                       ENTRY UnLockFamList
7268 C0FE              UnLockFamList PROC 
7269 C0FE A2 0C 00              ldx   #12
7270 C101 4C 6F C1              jmp   UnLock
7271 C104                       ENDP 
7272 C104
7273 C104
7274 C104
7275 C104              ****************************************************************
7276 C104              *
7277 C104              * LockNameList
7278 C104              *
7279 C104              ****************************************************************
7280 C104
7281 C104                       ENTRY LockNameList
7282 C104              LockNameList PROC 
7283 C104 A2 10 00              ldx   #16
7284 C107 4C 51 C1              jmp   Lock
7285 C10A                       ENDP 
7286 C10A
7287 C10A
7288 C10A
7289 C10A              ****************************************************************
7290 C10A              *
7291 C10A              * UnLockNameList
7292 C10A              *
7293 C10A              ****************************************************************
7294 C10A
7295 C10A                       ENTRY UnLockNameList
7296 C10A              UnLockNameList PROC 
7297 C10A
7298 C10A A5 80                 lda   <MenuMade                ;don't unlock NameList if it's been
7299 C10C F0 01                 beq   OK                       ;used in a menu
7300 C10E 60                    rts   
7301 C10F
7302 C10F A2 10 00     OK       ldx   #16
7303 C112 4C 6F C1              jmp   UnLock
7304 C115                       ENDP 
7305 C115
7306 C115
7307 C115
7308 C115              ****************************************************************
7309 C115              *
7310 C115              * LockFont
7311 C115              *
7312 C115              ****************************************************************
7313 C115
7314 C115                       ENTRY LockFont
7315 C115              LockFont PROC 
7316 C115 A2 14 00              ldx   #20
7317 C118 4C 51 C1              jmp   Lock
7318 C11B                       ENDP 
7319 C11B
7320 C11B
7321 C11B
7322 C11B              ****************************************************************
7323 C11B              *
7324 C11B              * UnLockFont
7325 C11B              *
7326 C11B              ****************************************************************
7327 C11B
7328 C11B                       ENTRY UnLockFont
7329 C11B              UnLockFont PROC 
7330 C11B A2 14 00              ldx   #20
7331 C11E 4C 6F C1              jmp   UnLock
7332 C121                       ENDP 
7333 C121
7334 C121
7335 C121
7336 C121              ****************************************************************
7337 C121              *
7338 C121              * LockBlock
7339 C121              *
7340 C121              ****************************************************************
7341 C121
7342 C121                       ENTRY LockBlock
7343 C121              LockBlock PROC 
7344 C121 A2 18 00              ldx   #24
7345 C124 4C 51 C1              jmp   Lock
7346 C127                       ENDP 
7347 C127
7348 C127
7349 C127
7350 C127              ****************************************************************
7351 C127              *
7352 C127              * UnLockBlock
7353 C127              *
7354 C127              ****************************************************************
7355 C127
7356 C127                       ENTRY UnLockBlock
7357 C127              UnLockBlock PROC 
7358 C127 A2 18 00              ldx   #24
7359 C12A 4C 6F C1              jmp   UnLock
7360 C12D                       ENDP 
7361 C12D
7362 C12D
7363 C12D
7364 C12D              ****************************************************************
7365 C12D              *
7366 C12D              * LockMDList
7367 C12D              *
7368 C12D              ****************************************************************
7369 C12D
7370 C12D                       ENTRY LockMDList
7371 C12D              LockMDList PROC 
7372 C12D A2 1C 00              ldx   #28
7373 C130 4C 51 C1              jmp   Lock
7374 C133                       ENDP 
7375 C133
7376 C133
7377 C133
7378 C133              ****************************************************************
7379 C133              *
7380 C133              * UnLockMDList
7381 C133              *
7382 C133              ****************************************************************
7383 C133
7384 C133                       ENTRY UnLockMDList
7385 C133              UnLockMDList PROC 
7386 C133 A2 1C 00              ldx   #28
7387 C136 4C 6F C1              jmp   UnLock
7388 C139                       ENDP 
7389 C139
7390 C139
7391 C139
7392 C139              ****************************************************************
7393 C139              *
7394 C139              * LockItemList
7395 C139              *
7396 C139              ****************************************************************
7397 C139
7398 C139                       ENTRY LockItemList
7399 C139              LockItemList PROC 
7400 C139 A2 20 00              ldx   #32
7401 C13C 4C 51 C1              jmp   Lock
7402 C13F                       ENDP 
7403 C13F
7404 C13F
7405 C13F
7406 C13F              ****************************************************************
7407 C13F              *
7408 C13F              * UnLockItemList
7409 C13F              *
7410 C13F              ****************************************************************
7411 C13F
7412 C13F                       ENTRY UnLockItemList
7413 C13F              UnLockItemList PROC 
7414 C13F A2 20 00              ldx   #32
7415 C142 4C 6F C1              jmp   UnLock
7416 C145                       ENDP 
7417 C145
7418 C145
7419 C145              ****************************************************************
7420 C145              *
7421 C145              * LockFMParams
7422 C145              *
7423 C145              ****************************************************************
7424 C145
7425 C145                       ENTRY LockFMParams
7426 C145              LockFMParams PROC 
7427 C145 A2 24 00              ldx   #36
7428 C148 4C 51 C1              jmp   Lock
7429 C14B                       ENDP 
7430 C14B
7431 C14B
7432 C14B
7433 C14B              ****************************************************************
7434 C14B              *
7435 C14B              * UnLockFMParams
7436 C14B              *
7437 C14B              ****************************************************************
7438 C14B
7439 C14B                       ENTRY UnLockFMParams
7440 C14B              UnLockFMParams PROC 
7441 C14B A2 24 00              ldx   #36
7442 C14E 4C 6F C1              jmp   UnLock
7443 C151                       ENDP 
7444 C151
7445 C151
7446 C151
7447 C151
7448 C151              ****************************************************************
7449 C151              *
7450 C151              * Lock
7451 C151              *
7452 C151              ****************************************************************
7453 C151
7454 C151                       ENTRY Lock
7455 C151              Lock     PROC 
7456 C151
7457 C151 B5 00                 lda   <TempHandle,x            ;copy correct handle into TempHandle
7458 C153 85 00                 sta   <TempHandle
7459 C155 B5 02                 lda   <TempHandle+2,x
7460 C157 85 02                 sta   <TempHandle+2
7461 C159
7462 C159 A0 04 00              ldy   #4
7463 C15C B7 00                 lda   [<TempHandle],y
7464 C15E 09 00 80              ora   #$8000                   ;set locked bit in attribute word
7465 C161 97 00                 sta   [<TempHandle],y
7466 C163
7467 C163 A7 00                 lda   [<TempHandle]            ;dereference handle into correct ptr
7468 C165 95 28                 sta   <TempPtr,x
7469 C167 A0 02 00              ldy   #2
7470 C16A B7 00                 lda   [<TempHandle],y
7471 C16C 95 2A                 sta   <TempPtr+2,x
7472 C16E 60                    rts   
7473 C16F                       ENDP 
7474 C16F
7475 C16F
7476 C16F
7477 C16F              ****************************************************************
7478 C16F              *
7479 C16F              * UnLock
7480 C16F              *
7481 C16F              ****************************************************************
7482 C16F
7483 C16F                       ENTRY UnLock
7484 C16F              UnLock   PROC 
7485 C16F
7486 C16F B5 00                 lda   <TempHandle,x            ;copy correct handle into TempHandle
7487 C171 85 00                 sta   <TempHandle
7488 C173 B5 02                 lda   <TempHandle+2,x
7489 C175 85 02                 sta   <TempHandle+2
7490 C177
7491 C177 A0 04 00              ldy   #4
7492 C17A B7 00                 lda   [<TempHandle],y
7493 C17C 29 FF 7F              and   #$7FFF                   ;clear locked bit in attribute word
7494 C17F 97 00                 sta   [<TempHandle],y
7495 C181 60                    rts   
7496 C182                       ENDP 
7497 C182
7498 C182
7499 C182
7500 C182              ****************************************************************
7501 C182              *
7502 C182              * oStdEnd0
7503 C182              *
7504 C182              ****************************************************************
7505 C182
7506 C182                       ENTRY oStdEnd0
7507 C182              oStdEnd0 PROC 
7508 C182 A0 00 00              ldy   #0                       ;# bytes of param to strip
7509 C185 5C ED FC FE           jml   oendcall
7510 C189                       ENDP 
7511 C189
7512 C189
7513 C189
7514 C189              ****************************************************************
7515 C189              *
7516 C189              * StdEnd4
7517 C189              *
7518 C189              ****************************************************************
7519 C189
7520 C189                       ENTRY StdEnd4
7521 C189              StdEnd4  PROC 
7522 C189 A0 04 00              ldy   #4                       ;# bytes of param to strip
7523 C18C 5C B0 FC FE           jml   endcall
7524 C190                       ENDP 
7525 C190
7526 C190
7527 C190
7528 C190              ****************************************************************
7529 C190              *
7530 C190              * StdErr4
7531 C190              *
7532 C190              ****************************************************************
7533 C190
7534 C190                       ENTRY StdErr4
7535 C190              StdErr4  PROC 
7536 C190 A0 04 00              ldy   #4                       ;# bytes of param to strip
7537 C193 5C B3 FC FE           jml   errout
7538 C197                       ENDP 
7539 C197
7540 C197
7541 C197
7542 C197              ****************************************************************
7543 C197              *
7544 C197              * StdEnd6
7545 C197              *
7546 C197              ****************************************************************
7547 C197
7548 C197                       ENTRY StdEnd6
7549 C197              StdEnd6  PROC 
7550 C197 A0 06 00              ldy   #6                       ;# bytes of param to strip
7551 C19A 5C B0 FC FE           jml   endcall
7552 C19E                       ENDP 
7553 C19E
7554 C19E
7555 C19E
7556 C19E              ****************************************************************
7557 C19E              *
7558 C19E              * StdErr6
7559 C19E              *
7560 C19E              ****************************************************************
7561 C19E
7562 C19E                       ENTRY StdErr6
7563 C19E              StdErr6  PROC 
7564 C19E A0 06 00              ldy   #6                       ;# bytes of param to strip
7565 C1A1 5C B3 FC FE           jml   errout
7566 C1A5                       ENDP 
7567 C1A5
7568 C1A5              ;                COPY scalestuff
7569 C1A5              ;
7570 C1A5              ******************************************************************************
7571 C1A5              *                                                                            *
7572 C1A5              *    subroutine AddScaledFont                                                *
7573 C1A5              *                                                                            *
7574 C1A5              *              Started 2/10/87                                               *
7575 C1A5              *              Bennet Marks  x6245                                           *
7576 C1A5              *                                                                            *
7577 C1A5              *  This subroutine takes the newly-scaled font from ScaleFont, enters it     *
7578 C1A5              *  into the Font Manager's lists, makes it unpurgeable, and makes it         *
7579 C1A5              *  current.                                                                  *
7580 C1A5              *                                                                            *
7581 C1A5              *  The code is adapted from AddFontVar.                                      *
7582 C1A5              *                                                                            *
7583 C1A5              ******************************************************************************
7584 C1A5              ;
7585 C1A5              ***************************************
7586 C1A5              *                                     *
7587 C1A5              *  9/18/87  10:30 am                  *
7588 C1A5              *                                     *
7589 C1A5              ***************************************
7590 C1A5              ;
7591 C1A5                       ENTRY AddScaledFont
7592 C1A5              AddScaledFont PROC 
7593 C1A5                       INCLUDE 'SomeFMEqus'           ;added 2/12/87 - BHM
7594 C1A5              ;
7595 C1A5 85 14                 sta   <FontHandle
7596 C1A7 86 16                 stx   <FontHandle+2
7597 C1A9              ;
7598 C1A9 20 15 C1              jsr   LockFont
7599 C1AC
7600 C1AC 20 F2 C0              jsr   UnlockIDList
7601 C1AF
7602 C1AF A5 60                 lda   <IDListSize              ;get current size of ID list
7603 C1B1 18                    clc   
7604 C1B2 69 0E 00              adc   #14                      ;add size of new entry
7605 C1B5 85 BC                 sta   <NewIDSize               ;and save
7606 C1B7
7607 C1B7 F4 00 00              PushWord #0                    ;hi word of size
7608 C1BA 48                    pha                            ;lo word of size
7609 C1BB D4 0A D4 08           PushZLong <IDHandle            ;handle to list
7610 C1BF A2 02 19 22           _SetHandleSize                 ;grow the list
7611 C1C6 90 0C                 bcc   OK
7612 C1C8 48                    pha                            ;save error code
7613 C1C9 20 1B C1              jsr   UnLockFont               ;clean up
7614 C1CC 20 EC C0              jsr   LockIDList               ;exper.
7615 C1CF 68                    pla                            ;retrieve error code
7616 C1D0 FA                    plx                            ;pull of font stat bits
7617 C1D1 FA                    plx                            ;pull off fam name offset
7618 C1D2 38                    sec   
7619 C1D3 6B                    rtl   
7620 C1D4              ;
7621 C1D4 20 EC C0     OK       jsr   LockIDList
7622 C1D7
7623 C1D7 18                    clc   
7624 C1D8 A5 30                 lda   <IDPtr                   ;create ptr to new ID entry
7625 C1DA 65 60                 adc   <IDListSize
7626 C1DC 85 30                 sta   <IDPtr
7627 C1DE A5 32                 lda   <IDPtr+2
7628 C1E0 69 00 00              adc   #0
7629 C1E3 85 32                 sta   <IDPtr+2
7630 C1E5              ;
7631 C1E5              ; Create alternate entry point for case when the idptr is going to be an existing entry
7632 C1E5              ; 6/12/89 Mensch
7633 C1E5              IDSetup   
7634 C1E5 A0 02 00              ldy   #2
7635 C1E8 B7 3C                 lda   [<fontPtr],y             ;fam num
7636 C1EA 87 30                 sta   [<IDPtr]
7637 C1EC
7638 C1EC A0 04 00              ldy   #4
7639 C1EF B7 3C                 lda   [<FontPtr],y             ;get font's style word
7640 C1F1 29 FF 00              and   #$00FF                   ;mask off hi byte
7641 C1F4 48                    pha                            ;save on stack
7642 C1F5 C8                    iny   
7643 C1F6 C8                    iny   
7644 C1F7 B7 3C                 lda   [<FontPtr],y             ;get font's size word
7645 C1F9 29 FF 00              and   #$00FF                   ;mask off hi byte
7646 C1FC EB                    xba                            ;swap bytes
7647 C1FD 03 01                 ora   1,s                      ;OR with style word
7648 C1FF 7A                    ply                            ;clean up
7649 C200
7650 C200 A0 02 00              ldy   #2
7651 C203 97 30                 sta   [<IDPtr],y               ;save style/size word in new ID entry
7652 C205              ;
7653 C205              **  Let's wipe out all references to BestPtr
7654 C205              **  (exper.)
7655 C205              ;
7656 C205 A5 B4                 lda   <NewLevel                ;temp storage for font stat bits
7657 C207 29 0C 00              and   #(ApFamBit+ApVarBit)     ;inherit these two bits
7658 C20A 09 23 00              ora   #(MemBit+UnrealBit+NotDiskBit)
7659 C20D              ;(those 3 are set to 1's; the leftovers are 0)
7660 C20D A0 08 00              ldy   #8
7661 C210 97 30                 sta   [<IDPtr],y
7662 C212              ;
7663 C212 A5 B2                 lda   <MatchLevel              ;temp. storage for offset to fam name
7664 C214 A0 04 00              ldy   #4
7665 C217 97 30                 sta   [<IDPtr],y
7666 C219
7667 C219
7668 C219
7669 C219
7670 C219
7671 C219
7672 C219 A9 00 00              lda   #0
7673 C21C A0 06 00              ldy   #6
7674 C21F 97 30                 sta   [<IDPtr],y               ;set filename offset to 0
7675 C221
7676 C221              ;
7677 C221              ;
7678 C221 A5 14                 lda   <FontHandle              ;get font handle
7679 C223 A0 0A 00              ldy   #10
7680 C226 97 30                 sta   [<IDPtr],y               ;and save in new ID entry
7681 C228 A5 16                 lda   <FontHandle+2
7682 C22A C8                    iny   
7683 C22B C8                    iny   
7684 C22C 97 30                 sta   [<IDPtr],y
7685 C22E
7686 C22E
7687 C22E A5 BC                 lda   <NewIDSize               ;get new size of ID list
7688 C230 85 60                 sta   <IDListSize              ;and save
7689 C232 E6 68                 inc   <IDCount                 ;inc # of ID entries
7690 C234
7691 C234 F4 00 00              Pushword #0 
7692 C237 D4 16 D4 14           PushZLong <FontHandle 
7693 C23B A2 02 24 22           _SetPurge                      ;make font unpurgeable
7694 C242
7695 C242 20 17 C0              jsr   MakeCurrent              ;make new font the current font
7696 C245
7697 C245 20 1B C1              jsr   UnLockFont
7698 C248 18                    clc                            ;signal no error
7699 C249
7700 C249 6B                    rtl   
7701 C24A
7702 C24A
7703 C24A                       ENDP 
7704 C24A
7705 C24A                       END   
7706 C24A
